/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Motion;
import jp.sourceforge.acerola3d.a3viewer.JTextAreaOutputStream;
import jp.sourceforge.acerola3d.a3viewer.MyExamController;

public class A3Viewer
implements ActionListener,
ChangeListener {
    JFrame frame;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem proxyMenuItem;
    JMenuItem resetViewMenuItem;
    JMenuItem snapshotMenuItem;
    JMenuItem backgroundMenuItem;
    JTextField urlTextField;
    JButton refButton;
    JFileChooser fileChooser;
    A3Canvas a3canvas;
    JComboBox actionNameCB;
    JButton resetViewButton;
    JTextArea commentTextArea;
    JLabel statusBarLabel;
    JFrame consoleFrame;
    JTextArea consoleTextArea;
    JButton clearConsoleButton;
    JCheckBox pauseCheckBox;
    JSlider slider;
    int sliderLength = 100;
    double motionLength;
    Action3D a3;
    String actionName = "0";
    MyExamController controller;
    ProxyPanel proxyPanel = null;
    String[] proxyData = new String[]{"", "", "", ""};

    public A3Viewer(String[] args) {
        this.frame = new JFrame("A3Viewer");
        Box baseBox = Box.createVerticalBox();
        this.frame.getContentPane().add(baseBox);
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        this.menuBar.add(Box.createHorizontalGlue());
        this.configMenu = new JMenu("Config");
        this.menuBar.add(this.configMenu);
        this.consoleMenuItem = new JMenuItem("Console");
        this.consoleMenuItem.addActionListener(this);
        this.configMenu.add(this.consoleMenuItem);
        this.proxyMenuItem = new JMenuItem("Proxy");
        this.proxyMenuItem.addActionListener(this);
        this.configMenu.add(this.proxyMenuItem);
        this.resetViewMenuItem = new JMenuItem("ResetView");
        this.resetViewMenuItem.addActionListener(this);
        this.configMenu.add(this.resetViewMenuItem);
        this.snapshotMenuItem = new JMenuItem("Snapshot");
        this.snapshotMenuItem.addActionListener(this);
        this.configMenu.add(this.snapshotMenuItem);
        this.backgroundMenuItem = new JMenuItem("Background");
        this.backgroundMenuItem.addActionListener(this);
        this.configMenu.add(this.backgroundMenuItem);
        this.consoleFrame = new JFrame("Console");
        Box b = Box.createVerticalBox();
        this.consoleTextArea = new JTextArea(20, 60);
        this.consoleTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.consoleTextArea);
        b.add(sp);
        this.clearConsoleButton = new JButton("Clear");
        this.clearConsoleButton.addActionListener(this);
        b.add(this.clearConsoleButton);
        this.consoleFrame.getContentPane().add(b);
        this.consoleFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                A3Viewer.this.consoleFrame.setVisible(false);
            }
        });
        PrintStream systemOut = System.out;
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(this.consoleTextArea, systemOut);
        PrintStream ps = new PrintStream(jtaos, true);
        System.setOut(ps);
        System.setErr(ps);
        this.consoleFrame.pack();
        Box box1 = Box.createHorizontalBox();
        baseBox.add(box1);
        box1.add(new JLabel("URL:"));
        this.urlTextField = new JTextField();
        try {
            File f = null;
            f = args != null && args.length == 2 && args[0].equals("-open") ? new File(args[1]) : new File(args[0]);
            this.urlTextField.setText(f.toURI().toString());
        }
        catch (Exception e) {
            this.urlTextField.setText("x-res:///jp/sourceforge/acerola3d/a3viewer/resources/acerola3d.a3");
        }
        this.urlTextField.addActionListener(this);
        this.urlTextField.setMaximumSize(new Dimension(3000, 30));
        box1.add(this.urlTextField);
        this.refButton = new JButton("ref");
        this.refButton.addActionListener(this);
        box1.add(this.refButton);
        Box box2 = Box.createHorizontalBox();
        baseBox.add(box2);
        this.a3canvas = A3Canvas.createA3Canvas((int)300, (int)300);
        this.controller = new MyExamController();
        this.a3canvas.setA3Controller((A3Controller)this.controller);
        box2.add((Component)this.a3canvas);
        Box controlBox = this.makeControlBox();
        box2.add(controlBox);
        Box box3 = Box.createHorizontalBox();
        this.pauseCheckBox = new JCheckBox("pause");
        this.pauseCheckBox.setSelected(false);
        this.pauseCheckBox.addActionListener(this);
        box3.add(this.pauseCheckBox);
        this.slider = new JSlider();
        this.slider.setMinimum(0);
        this.slider.setMaximum(this.sliderLength);
        this.slider.addChangeListener(this);
        box3.add(this.slider);
        baseBox.add(box3);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.add(this.statusBarLabel);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                A3Viewer.this.frame.dispose();
                System.exit(0);
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
        this.loadAction3D();
    }

    Box makeControlBox() {
        Box controlBox = Box.createVerticalBox();
        controlBox.add(new JLabel("ActionName:"));
        this.actionNameCB = new JComboBox();
        this.actionNameCB.setPreferredSize(new Dimension(50, 30));
        this.actionNameCB.setMaximumSize(new Dimension(30000, 30));
        this.actionNameCB.addActionListener(this);
        controlBox.add(this.actionNameCB);
        this.resetViewButton = new JButton("Reset View");
        this.resetViewButton.addActionListener(this);
        controlBox.add(this.resetViewButton);
        controlBox.add(new JLabel("Left drag: rotation"));
        controlBox.add(new JLabel("Center drag: translation"));
        controlBox.add(new JLabel("Right drag: scale"));
        controlBox.add(Box.createVerticalGlue());
        controlBox.add(new JLabel("***Comment***"));
        this.commentTextArea = new JTextArea(10, 30);
        this.commentTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.commentTextArea);
        sp.setPreferredSize(new Dimension(50, 150));
        sp.setMaximumSize(new Dimension(30000, 150));
        controlBox.add(sp);
        controlBox.add(Box.createVerticalGlue());
        String buildTime = null;
        try {
            URL url = this.getClass().getClassLoader().getResource("buildTime.txt");
            InputStreamReader isr = new InputStreamReader(url.openStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            buildTime = br.readLine();
        }
        catch (Exception e) {
            buildTime = "???";
        }
        controlBox.add(new JLabel("build time:"));
        controlBox.add(new JLabel("   " + buildTime));
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.actionNameCB) {
            this.actionName = (String)this.actionNameCB.getSelectedItem();
            if (this.actionName == null) {
                System.out.println("gaha1");
                return;
            }
            System.out.println("actionName:" + this.actionName);
            this.repaint();
        } else if (ae.getSource() == this.urlTextField) {
            this.loadAction3D();
        } else if (ae.getSource() == this.resetViewButton) {
            this.a3.setLocImmediately(0.0, 0.0, 0.0);
            this.a3.setQuatImmediately(0.0, 0.0, 0.0, 1.0);
            this.a3.setScaleImmediately(1.0);
        } else if (ae.getSource() == this.refButton) {
            this.ref();
        } else if (ae.getSource() == this.consoleMenuItem) {
            this.consoleFrame.setVisible(true);
        } else if (ae.getSource() == this.clearConsoleButton) {
            this.consoleTextArea.setText("");
        } else if (ae.getSource() == this.proxyMenuItem) {
            this.proxyConfig();
        } else if (ae.getSource() == this.resetViewMenuItem) {
            this.a3.setLocImmediately(0.0, 0.0, 0.0);
            this.a3.setQuatImmediately(0.0, 0.0, 0.0, 1.0);
            this.a3.setScaleImmediately(1.0);
        } else if (ae.getSource() == this.snapshotMenuItem) {
            try {
                File f = new File("snapshot.png");
                this.a3canvas.saveImage(f);
            }
            catch (Exception e) {
                System.out.println("A3Viewer:snapshot");
                e.printStackTrace();
            }
        } else if (ae.getSource() == this.backgroundMenuItem) {
            this.setBackground();
        } else if (ae.getSource() == this.pauseCheckBox) {
            if (this.a3 == null) {
                return;
            }
            if (this.pauseCheckBox.isSelected()) {
                this.a3.changeImmediately((Serializable)((Object)this.actionName));
                this.a3.setMode(Motion.Mode.PAUSE);
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.a3.setPauseTime(t);
            } else {
                this.a3.changeImmediately((Serializable)((Object)this.actionName));
                this.a3.setMode(Motion.Mode.PLAY);
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.a3.setPauseTime(t);
            }
        } else {
            System.out.append("gaha???");
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.a3 == null) {
            return;
        }
        double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
        this.a3.setPauseTime(t);
    }

    void loadAction3D() {
        Action3D.clearCash();
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        if (this.a3 != null) {
            this.a3canvas.del((A3Object)this.a3);
        }
        String urlString = this.urlTextField.getText();
        try {
            A23.initA23();
            this.a3 = Action3D.load((String)urlString);
            this.controller.setA3((A3Object)this.a3);
        }
        catch (Exception e) {
            System.out.println("A3Viewer.loadAction3D. error!");
            e.printStackTrace();
        }
        this.actionNameCB.removeAllItems();
        String[] sss = this.a3.getActionNames();
        for (int i = 0; i < sss.length; ++i) {
            this.actionNameCB.addItem(sss[i]);
        }
        this.a3canvas.add((A3Object)this.a3);
        this.commentTextArea.setText(this.a3.getComment());
        if (this.pauseCheckBox.isSelected()) {
            this.a3.setMode(Motion.Mode.PAUSE);
        } else {
            this.a3.setMode(Motion.Mode.PLAY);
        }
        this.motionLength = this.a3.getMotionLength(this.actionName);
        this.slider.setValue(0);
        this.a3.setLocImmediately(0.0, 0.0, 0.0);
        this.a3.setQuatImmediately(0.0, 0.0, 0.0, 1.0);
        this.a3.setScaleImmediately(1.0);
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    void repaint() {
        if (this.a3 == null) {
            return;
        }
        this.a3.changeImmediately((Serializable)((Object)this.actionName));
        this.motionLength = this.a3.getMotionLength(this.actionName);
        this.slider.setValue(0);
    }

    void proxyConfig() {
        if (this.proxyPanel == null) {
            this.proxyPanel = new ProxyPanel();
            this.proxyData[0] = System.getProperty("proxyHost");
            this.proxyData[1] = System.getProperty("proxyPort");
            this.proxyData[2] = System.getProperty("ftpProxyHost");
            this.proxyData[3] = System.getProperty("ftpProxyPort");
        }
        this.proxyPanel.setData(this.proxyData);
        Object[] options = new Object[]{"Ok", "Cancel"};
        int result = JOptionPane.showOptionDialog(this.frame, this.proxyPanel, "proxy", -1, 1, null, options, options[0]);
        if (result == 0) {
            this.proxyData = this.proxyPanel.getData();
            if (!this.proxyData[0].equals("")) {
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("proxyHost", this.proxyData[0]);
                System.getProperties().put("proxyPort", this.proxyData[1]);
            } else {
                System.getProperties().put("proxySet", "false");
                System.getProperties().put("proxyHost", "");
                System.getProperties().put("proxyPort", "");
            }
            if (!this.proxyData[2].equals("")) {
                System.getProperties().put("ftpProxySet", "true");
                System.getProperties().put("ftpProxyHost", this.proxyData[2]);
                System.getProperties().put("ftpProxyPort", this.proxyData[3]);
            } else {
                System.getProperties().put("ftpProxySet", "false");
                System.getProperties().put("ftpProxyHost", "");
                System.getProperties().put("ftpProxyPort", "");
            }
        }
    }

    void ref() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this.frame)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = new URL(f.toURI().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        this.urlTextField.setText(url.toExternalForm());
        this.loadAction3D();
    }

    void setBackground() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this.frame)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = new URL(f.toURI().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        Action3D a = null;
        try {
            a = Action3D.load((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (a != null) {
            this.a3canvas.setBackground((A3Object)a);
        }
    }

    public static void main(String[] args) {
        System.setSecurityManager(null);
        final String[] argsCopy = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new A3Viewer(argsCopy);
            }
        });
    }

    class ProxyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField httpHostTF;
        JTextField httpPortTF;
        JTextField ftpHostTF;
        JTextField ftpPortTF;

        public ProxyPanel() {
            Box b0 = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            Box b2 = Box.createHorizontalBox();
            this.add(b0);
            b0.add(b1);
            b0.add(b2);
            b1.add(new JLabel("http: host"));
            this.httpHostTF = new JTextField(40);
            b1.add(this.httpHostTF);
            b1.add(new JLabel(" port "));
            this.httpPortTF = new JTextField(5);
            b1.add(this.httpPortTF);
            b2.add(new JLabel("ftp: host"));
            this.ftpHostTF = new JTextField(40);
            b2.add(this.ftpHostTF);
            b2.add(new JLabel(" port "));
            this.ftpPortTF = new JTextField(5);
            b2.add(this.ftpPortTF);
        }

        public void setData(String[] proxyData) {
            this.httpHostTF.setText(proxyData[0]);
            this.httpPortTF.setText(proxyData[1]);
            this.ftpHostTF.setText(proxyData[2]);
            this.ftpPortTF.setText(proxyData[3]);
        }

        public String[] getData() {
            String[] ret = new String[]{this.httpHostTF.getText(), this.httpPortTF.getText(), this.ftpHostTF.getText(), this.ftpPortTF.getText()};
            return ret;
        }
    }
}

