/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3viewerlg3d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.media.j3d.BranchGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.vecmath.Vector3f;
import jp.sourceforge.acerola3d.a3.Action3D;
import org.jdesktop.lg3d.sg.Appearance;
import org.jdesktop.lg3d.sg.Node;
import org.jdesktop.lg3d.utils.action.ActionNoArg;
import org.jdesktop.lg3d.utils.eventadapter.MouseClickedEventAdapter;
import org.jdesktop.lg3d.utils.shape.Box;
import org.jdesktop.lg3d.utils.shape.Cone;
import org.jdesktop.lg3d.utils.shape.SimpleAppearance;
import org.jdesktop.lg3d.wg.Component3D;
import org.jdesktop.lg3d.wg.Frame3D;
import org.jdesktop.lg3d.wg.Java3DGraph;
import org.jdesktop.lg3d.wg.event.LgEventListener;
import org.jdesktop.lg3d.wg.event.LgEventSource;

public class A3ViewerLG3D {
    Frame3D frame = new Frame3D();
    Java3DGraph j3DGraph = null;
    Action3D action3D = null;
    int actionNo = 0;
    Component3D upButton = null;
    Component3D fileButton = null;
    Component3D downButton = null;
    JFileChooser fileChooser = null;
    JDialog fileChooserDialog = null;

    public A3ViewerLG3D() {
        SimpleAppearance app = new SimpleAppearance(0.8f, 0.6f, 0.6f, 0.7f);
        this.upButton = new Component3D();
        this.upButton.addChild((Node)new Cone(0.01f, 0.01f, (Appearance)app));
        this.upButton.setTranslation(-0.05f, 0.05f, 0.0f);
        this.upButton.addListener((LgEventListener)new MouseClickedEventAdapter((ActionNoArg)new UpAction()));
        this.frame.addChild(this.upButton);
        this.fileButton = new Component3D();
        this.fileButton.addChild((Node)new Box(0.01f, 0.01f, 0.01f, (Appearance)app));
        this.fileButton.setTranslation(-0.05f, -0.0f, 0.0f);
        this.fileButton.addListener((LgEventListener)new MouseClickedEventAdapter((ActionNoArg)new FileAction()));
        this.frame.addChild(this.fileButton);
        this.downButton = new Component3D();
        this.downButton.addChild((Node)new Cone(0.01f, 0.01f, (Appearance)app));
        this.downButton.setTranslation(-0.05f, -0.05f, 0.0f);
        this.downButton.setRotationAxis(1.0f, 0.0f, 0.0f);
        this.downButton.setRotationAngle((float)Math.PI);
        this.downButton.addListener((LgEventListener)new MouseClickedEventAdapter((ActionNoArg)new DownAction()));
        this.frame.addChild(this.downButton);
        this.fileChooser = new JFileChooser();
        this.fileChooser.addActionListener(new FCActionListener());
        this.fileChooserDialog = new JDialog();
        this.fileChooserDialog.getContentPane().add(this.fileChooser);
        this.fileChooserDialog.pack();
        this.fileChooserDialog.setVisible(false);
        this.j3DGraph = new Java3DGraph();
        URL url = this.getClass().getClassLoader().getResource("jp/sourceforge/acerola3d/a3viewerlg3d/resources/acerola3d.a3");
        this.loadAction3D(url);
        this.frame.addChild((Component3D)this.j3DGraph);
        this.frame.setPreferredSize(new Vector3f(0.2f, 0.2f, 0.2f));
        this.frame.changeEnabled(true);
        this.frame.changeVisible(true);
    }

    void loadAction3D(URL url) {
        try {
            Action3D.clearCash();
            this.j3DGraph.removeAllChildren();
            this.action3D = Action3D.load((URL)url);
            this.action3D.change(0);
            this.action3D.setScale(0.1);
            this.action3D.setLoc(0.0, -0.03, 0.0);
            this.j3DGraph.addJ3dChild((BranchGroup)this.action3D.getNode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        A3ViewerLG3D v = new A3ViewerLG3D();
    }

    class FCActionListener
    implements ActionListener {
        FCActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                System.out.println("gaha:FCActionListener");
                A3ViewerLG3D.this.fileChooserDialog.setVisible(false);
                File f = A3ViewerLG3D.this.fileChooser.getSelectedFile();
                URL url = f.toURI().toURL();
                A3ViewerLG3D.this.loadAction3D(url);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    class DownAction
    implements ActionNoArg {
        DownAction() {
        }

        public void performAction(LgEventSource e) {
            System.out.println("gaha:DownAction");
            --A3ViewerLG3D.this.actionNo;
            if (A3ViewerLG3D.this.actionNo < 0) {
                A3ViewerLG3D.this.actionNo += A3ViewerLG3D.this.action3D.getActionCount();
            }
            A3ViewerLG3D.this.actionNo %= A3ViewerLG3D.this.action3D.getActionCount();
            A3ViewerLG3D.this.action3D.change(A3ViewerLG3D.this.actionNo);
        }
    }

    class UpAction
    implements ActionNoArg {
        UpAction() {
        }

        public void performAction(LgEventSource e) {
            System.out.println("gaha:UpAction");
            ++A3ViewerLG3D.this.actionNo;
            A3ViewerLG3D.this.actionNo %= A3ViewerLG3D.this.action3D.getActionCount();
            A3ViewerLG3D.this.action3D.change(A3ViewerLG3D.this.actionNo);
        }
    }

    class FileAction
    implements ActionNoArg {
        FileAction() {
        }

        public void performAction(LgEventSource e) {
            System.out.println("gaha:FileAction");
            A3ViewerLG3D.this.fileChooserDialog.setVisible(true);
        }
    }
}

