/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.SharedGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import org.jdesktop.j3d.loaders.vrml97.impl.Light;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFColor;
import org.jdesktop.j3d.loaders.vrml97.impl.SFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.SFVec3f;

public class PointLight
extends Light {
    SFFloat ambientIntensity;
    SFVec3f attenuation;
    SFColor color;
    SFFloat intensity;
    SFVec3f location;
    SFBool on;
    SFFloat radius;
    Color3f lightColor;
    Point3f lightPos;
    Point3f lightAtt;
    BoundingSphere bounds;
    javax.media.j3d.PointLight pntLight;

    public PointLight(Loader loader) {
        super(loader);
        this.ambientIntensity = new SFFloat(0.0f);
        this.attenuation = new SFVec3f(1.0f, 0.0f, 0.0f);
        this.color = new SFColor(1.0f, 1.0f, 1.0f);
        this.intensity = new SFFloat(1.0f);
        this.location = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.on = new SFBool(true);
        this.radius = new SFFloat(100.0f);
        this.initFields();
    }

    PointLight(Loader loader, SFFloat ambientIntensity, SFVec3f attenuation, SFColor color, SFFloat intensity, SFVec3f location, SFBool on, SFFloat radius) {
        super(loader);
        this.ambientIntensity = ambientIntensity;
        this.attenuation = attenuation;
        this.color = color;
        this.intensity = intensity;
        this.location = location;
        this.on = on;
        this.radius = radius;
        this.initFields();
    }

    void initImpl() {
        this.lightColor = new Color3f();
        this.lightPos = new Point3f();
        this.lightAtt = new Point3f();
        this.bounds = new BoundingSphere();
        this.bounds.setRadius((double)this.radius.value);
        this.sharedGroup = new SharedGroup();
        this.lightColor.x = this.color.color[0] * this.ambientIntensity.value;
        this.lightColor.y = this.color.color[1] * this.ambientIntensity.value;
        this.lightColor.z = this.color.color[2] * this.ambientIntensity.value;
        this.ambLight = new AmbientLight(this.on.value, this.lightColor);
        this.ambLight.setInfluencingBounds((Bounds)this.bounds);
        this.sharedGroup.addChild((Node)this.ambLight);
        this.lightColor.x = this.color.color[0] * this.intensity.value;
        this.lightColor.y = this.color.color[1] * this.intensity.value;
        this.lightColor.z = this.color.color[2] * this.intensity.value;
        this.lightPos.x = this.location.value[0];
        this.lightPos.y = this.location.value[1];
        this.lightPos.z = this.location.value[2];
        this.lightAtt.x = this.attenuation.value[0];
        this.lightAtt.y = this.attenuation.value[1];
        this.lightAtt.z = this.attenuation.value[2];
        this.pntLight = new javax.media.j3d.PointLight(this.on.value, this.lightColor, this.lightPos, this.lightAtt);
        this.light = this.pntLight;
        this.pntLight.setInfluencingBounds((Bounds)this.bounds);
        this.sharedGroup.addChild((Node)this.pntLight);
        this.implReady = true;
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("AmbientIntensity")) {
            this.lightColor.x = this.color.color[0] * this.ambientIntensity.value;
            this.lightColor.y = this.color.color[1] * this.ambientIntensity.value;
            this.lightColor.z = this.color.color[2] * this.ambientIntensity.value;
            this.ambLight.setColor(this.lightColor);
        } else if (eventInName.equals("color") || eventInName.equals("intensity")) {
            this.lightColor.x = this.color.color[0] * this.ambientIntensity.value;
            this.lightColor.y = this.color.color[1] * this.ambientIntensity.value;
            this.lightColor.z = this.color.color[2] * this.ambientIntensity.value;
            this.ambLight.setColor(this.lightColor);
            this.lightColor.x = this.color.color[0] * this.intensity.value;
            this.lightColor.y = this.color.color[1] * this.intensity.value;
            this.lightColor.z = this.color.color[2] * this.intensity.value;
            this.pntLight.setColor(this.lightColor);
        } else if (eventInName.equals("location")) {
            this.lightPos.x = this.location.value[0];
            this.lightPos.y = this.location.value[1];
            this.lightPos.z = this.location.value[2];
            this.pntLight.setPosition(this.lightPos);
        } else if (eventInName.equals("attenuation")) {
            this.lightAtt.x = this.attenuation.value[0];
            this.lightAtt.y = this.attenuation.value[1];
            this.lightAtt.z = this.attenuation.value[2];
            this.pntLight.setAttenuation(this.lightAtt);
        } else if (eventInName.equals("on")) {
            this.ambLight.setEnable(this.on.value);
            this.pntLight.setEnable(this.on.value);
        } else if (eventInName.equals("radius")) {
            this.bounds.setRadius((double)this.radius.value);
            this.ambLight.setInfluencingBounds((Bounds)this.bounds);
            this.pntLight.setInfluencingBounds((Bounds)this.bounds);
        } else if (eventInName.equals("route_on")) {
            this.ambLight.setCapability(13);
            this.pntLight.setCapability(13);
        } else if (eventInName.equals("route_location")) {
            this.pntLight.setCapability(19);
        } else if (eventInName.equals("route_attenuation")) {
            this.pntLight.setCapability(21);
        } else if (eventInName.equals("route_color") || eventInName.equals("route_intensity")) {
            this.ambLight.setCapability(15);
            this.pntLight.setCapability(15);
        } else if (eventInName.equals("route_ambientIntensity")) {
            this.ambLight.setCapability(15);
        } else if (eventInName.equals("route_radius")) {
            this.ambLight.setCapability(17);
            this.pntLight.setCapability(17);
        }
    }

    public Object clone() {
        PointLight l = new PointLight(this.loader, (SFFloat)this.ambientIntensity.clone(), (SFVec3f)this.attenuation.clone(), (SFColor)this.color.clone(), (SFFloat)this.intensity.clone(), (SFVec3f)this.location.clone(), (SFBool)this.on.clone(), (SFFloat)this.radius.clone());
        return l;
    }

    public String getType() {
        return "PointLight";
    }

    void initFields() {
        this.ambientIntensity.init(this, this.FieldSpec, 3, "ambientIntensity");
        this.attenuation.init(this, this.FieldSpec, 3, "attenuation");
        this.color.init(this, this.FieldSpec, 3, "color");
        this.intensity.init(this, this.FieldSpec, 3, "intensity");
        this.location.init(this, this.FieldSpec, 3, "location");
        this.on.init(this, this.FieldSpec, 3, "on");
        this.radius.init(this, this.FieldSpec, 3, "radius");
    }
}

