package jp.sourceforge.acerola3d.a3viewerlg3d;

import jp.sourceforge.acerola3d.a3.*;
import org.jdesktop.lg3d.wg.*;
import org.jdesktop.lg3d.wg.event.LgEventSource;
import org.jdesktop.lg3d.utils.shape.*;
import org.jdesktop.lg3d.utils.shape.Box;
import org.jdesktop.lg3d.utils.eventadapter.MouseClickedEventAdapter;
import org.jdesktop.lg3d.utils.action.ActionNoArg;

import javax.media.j3d.BranchGroup;
import javax.vecmath.Vector3f;

import javax.swing.*;
import java.awt.event.*;
import java.io.File;
import java.net.URL;

public class A3ViewerLG3D {
	Frame3D frame = null;
	Java3DGraph j3DGraph = null;
    Action3D action3D = null;
    int actionNo = 0;
    Component3D upButton = null;
    Component3D fileButton = null;
    Component3D downButton = null;
    JFileChooser fileChooser = null;
    JDialog fileChooserDialog = null;

    public A3ViewerLG3D() {
        frame = new Frame3D();
        SimpleAppearance app = new SimpleAppearance(0.8f, 0.6f, 0.6f, 0.7f);
        upButton = new Component3D();
        upButton.addChild(new Cone(0.01f,0.01f,app));
        upButton.setTranslation(-0.05f,0.05f,0.0f);
        upButton.addListener(new MouseClickedEventAdapter(new UpAction()));
        frame.addChild(upButton);
        fileButton = new Component3D();
        fileButton.addChild(new Box(0.01f,0.01f,0.01f,app));
        fileButton.setTranslation(-0.05f,-0.0f,0.0f);
        fileButton.addListener(new MouseClickedEventAdapter(new FileAction()));
        frame.addChild(fileButton);
        downButton = new Component3D();
        downButton.addChild(new Cone(0.01f,0.01f,app));
        downButton.setTranslation(-0.05f,-0.05f,0.0f);
        downButton.setRotationAxis(1.0f,0.0f,0.0f);
        downButton.setRotationAngle((float)Math.PI);
        downButton.addListener(new MouseClickedEventAdapter(new DownAction()));
        frame.addChild(downButton);
        fileChooser = new JFileChooser();
        fileChooser.addActionListener(new FCActionListener());
        fileChooserDialog = new JDialog();
        fileChooserDialog.getContentPane().add(fileChooser);
        fileChooserDialog.pack();
        fileChooserDialog.setVisible(false);
        j3DGraph = new Java3DGraph();
        //URL url = new URL("resource:///axis.a3");
        URL url = getClass().getClassLoader().getResource("jp/sourceforge/acerola3d/a3viewerlg3d/resources/acerola3d.a3");
        loadAction3D(url);
        frame.addChild(j3DGraph);
        frame.setPreferredSize(new Vector3f(0.2f, 0.2f, 0.2f));
        frame.changeEnabled(true);
        frame.changeVisible(true);        
    }

    void loadAction3D(URL url) {
        try {
            Action3D.clearCash();
            j3DGraph.removeAllChildren();
            action3D = Action3D.load(url);
            action3D.change(0);//gaha
            action3D.setScale(0.1);
            action3D.setLoc(0.0,-0.03,0.0);
            j3DGraph.addJ3dChild((BranchGroup)action3D.getNode());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    class FileAction implements ActionNoArg {
		public void performAction(LgEventSource e) {
            System.out.println("gaha:FileAction");
            fileChooserDialog.setVisible(true);
		}
    	
    }
    class UpAction implements ActionNoArg {
        public void performAction(LgEventSource e) {
            System.out.println("gaha:UpAction");
            actionNo++;
            actionNo = actionNo%action3D.getActionCount();
            action3D.change(actionNo);
        }
    }
    class DownAction implements ActionNoArg {
        public void performAction(LgEventSource e) {
            System.out.println("gaha:DownAction");
            actionNo--;
            if (actionNo<0)
                actionNo += action3D.getActionCount();
            actionNo = actionNo%action3D.getActionCount();
            action3D.change(actionNo);
        }
    }
    class FCActionListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                System.out.println("gaha:FCActionListener");
                fileChooserDialog.setVisible(false);
                File f = fileChooser.getSelectedFile();
                URL url = f.toURI().toURL();
                loadAction3D(url);
            } catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }
    public static void main(String[] args) {
        A3ViewerLG3D v = new A3ViewerLG3D();
    }
}
