/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3board;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3Adapter;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3Event;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3board.JTextAreaOutputStream;

public class A3Board
implements ActionListener {
    JFrame frame;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenu configMenu;
    JMenuItem loadMenuItem;
    JMenuItem consoleMenuItem;
    JMenuItem proxyMenuItem;
    JMenuItem resetViewMenuItem;
    JMenuItem snapshotMenuItem;
    JMenuItem backgroundMenuItem;
    JMenuItem exitMenuItem;
    JMenuItem headLightMenuItem;
    JCheckBox naviModeCheckBox;
    JCheckBox editModeCheckBox;
    JCheckBox examModeCheckBox;
    JFileChooser fileChooser = new JFileChooser(".");
    A3Canvas a3canvas;
    JLabel objectNameLabel;
    JButton deleteButton;
    JComboBox actionNameCB;
    JButton resetViewButton;
    JLabel statusBarLabel;
    JFrame consoleFrame;
    JTextArea consoleTextArea;
    JButton clearConsoleButton;
    Vector3d cameraV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d cameraQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Mode mode = Mode.NAVI;
    boolean headLight = true;
    A3Object selectedA3Object = null;
    String actionName = "0";
    ProxyPanel proxyPanel = null;
    String[] proxyData = new String[]{"", "", "", ""};

    public A3Board(String[] args) {
        this.frame = new JFrame("A3Board");
        Box baseBox = Box.createVerticalBox();
        this.frame.getContentPane().add(baseBox);
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        this.menuBar.add(Box.createHorizontalGlue());
        this.fileMenu = new JMenu("File");
        this.menuBar.add(this.fileMenu);
        this.loadMenuItem = new JMenuItem("Load");
        this.loadMenuItem.addActionListener(this);
        this.fileMenu.add(this.loadMenuItem);
        this.backgroundMenuItem = new JMenuItem("Background");
        this.backgroundMenuItem.addActionListener(this);
        this.fileMenu.add(this.backgroundMenuItem);
        this.snapshotMenuItem = new JMenuItem("Snapshot");
        this.snapshotMenuItem.addActionListener(this);
        this.fileMenu.add(this.snapshotMenuItem);
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.addActionListener(this);
        this.fileMenu.add(this.exitMenuItem);
        this.configMenu = new JMenu("Config");
        this.menuBar.add(this.configMenu);
        this.consoleMenuItem = new JMenuItem("Console");
        this.consoleMenuItem.addActionListener(this);
        this.configMenu.add(this.consoleMenuItem);
        this.proxyMenuItem = new JMenuItem("Proxy");
        this.proxyMenuItem.addActionListener(this);
        this.configMenu.add(this.proxyMenuItem);
        this.resetViewMenuItem = new JMenuItem("ResetView");
        this.resetViewMenuItem.addActionListener(this);
        this.configMenu.add(this.resetViewMenuItem);
        this.headLightMenuItem = new JMenuItem("HeadLight");
        this.headLightMenuItem.addActionListener(this);
        this.configMenu.add(this.headLightMenuItem);
        this.consoleFrame = new JFrame("Console");
        Box b = Box.createVerticalBox();
        this.consoleTextArea = new JTextArea(20, 60);
        this.consoleTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.consoleTextArea);
        b.add(sp);
        this.clearConsoleButton = new JButton("Clear");
        this.clearConsoleButton.addActionListener(this);
        b.add(this.clearConsoleButton);
        this.consoleFrame.getContentPane().add(b);
        this.consoleFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                A3Board.this.consoleFrame.setVisible(false);
            }
        });
        PrintStream systemOut = System.out;
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(this.consoleTextArea, systemOut);
        PrintStream ps = new PrintStream(jtaos, true);
        System.setOut(ps);
        System.setErr(ps);
        this.consoleFrame.pack();
        Box box1 = Box.createHorizontalBox();
        baseBox.add(box1);
        ButtonGroup bg = new ButtonGroup();
        this.naviModeCheckBox = new JCheckBox("navi");
        this.naviModeCheckBox.addActionListener(this);
        box1.add(this.naviModeCheckBox);
        bg.add(this.naviModeCheckBox);
        this.editModeCheckBox = new JCheckBox("edit");
        this.editModeCheckBox.addActionListener(this);
        box1.add(this.editModeCheckBox);
        bg.add(this.editModeCheckBox);
        this.examModeCheckBox = new JCheckBox("exam");
        this.examModeCheckBox.addActionListener(this);
        box1.add(this.examModeCheckBox);
        bg.add(this.examModeCheckBox);
        Box box2 = Box.createHorizontalBox();
        baseBox.add(box2);
        this.a3canvas = A3Canvas.createA3Canvas((int)300, (int)300);
        this.a3canvas.setCameraLocImmediately(this.cameraV);
        this.a3canvas.setCameraQuatImmediately(this.cameraQ);
        this.a3canvas.addKeyListener((KeyListener)new MyKeyAdapter());
        this.a3canvas.addA3Listener((A3Listener)new MyA3Adapter());
        this.a3canvas.setHeadLightEnable(this.headLight);
        box2.add((Component)this.a3canvas);
        this.naviModeCheckBox.setSelected(true);
        this.a3canvas.setNavigationMode(A3Canvas.NaviMode.WALK);
        Box controlBox = this.makeControlBox();
        box2.add(controlBox);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.add(this.statusBarLabel);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                A3Board.this.frame.dispose();
                System.exit(0);
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
    }

    Box makeControlBox() {
        Box controlBox = Box.createVerticalBox();
        controlBox.add(new JLabel("ObjectName:"));
        this.objectNameLabel = new JLabel("0:null");
        controlBox.add(this.objectNameLabel);
        this.deleteButton = new JButton("delete");
        this.deleteButton.addActionListener(this);
        controlBox.add(this.deleteButton);
        controlBox.add(new JLabel("ActionName:"));
        this.actionNameCB = new JComboBox();
        this.actionNameCB.setPreferredSize(new Dimension(150, 30));
        this.actionNameCB.setMaximumSize(new Dimension(150, 30));
        this.actionNameCB.addActionListener(this);
        controlBox.add(this.actionNameCB);
        this.resetViewButton = new JButton("Reset View");
        this.resetViewButton.addActionListener(this);
        controlBox.add(this.resetViewButton);
        controlBox.add(new JLabel("Left drag: rotation"));
        controlBox.add(new JLabel("Center drag: translation"));
        controlBox.add(new JLabel("Right drag: scale"));
        controlBox.add(Box.createVerticalGlue());
        String buildTime = null;
        try {
            URL url = this.getClass().getClassLoader().getResource("buildTime.txt");
            InputStreamReader isr = new InputStreamReader(url.openStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            buildTime = br.readLine();
        }
        catch (Exception e) {
            buildTime = "???";
        }
        controlBox.add(new JLabel("build time:"));
        controlBox.add(new JLabel("   " + buildTime));
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.actionNameCB) {
            this.actionName = (String)this.actionNameCB.getSelectedItem();
            if (this.actionName == null) {
                System.out.println("gaha1");
                return;
            }
            System.out.println("actionName:" + this.actionName);
            this.repaint();
        } else if (ae.getSource() == this.loadMenuItem) {
            this.loadAction3D();
        } else if (ae.getSource() == this.naviModeCheckBox) {
            this.mode = Mode.NAVI;
            this.a3canvas.setNavigationMode(A3Canvas.NaviMode.WALK);
            System.out.println("Mode: NAVI");
        } else if (ae.getSource() == this.editModeCheckBox) {
            this.mode = Mode.EDIT;
            this.a3canvas.setNavigationMode(A3Canvas.NaviMode.EDIT);
            System.out.println("Mode: EDIT");
        } else if (ae.getSource() == this.examModeCheckBox) {
            this.mode = Mode.EXAM;
            this.a3canvas.setNavigationMode(A3Canvas.NaviMode.EXAMINE);
            System.out.println("Mode: EXAM");
        } else if (ae.getSource() == this.deleteButton) {
            if (this.selectedA3Object != null) {
                this.a3canvas.del(this.selectedA3Object);
            }
        } else if (ae.getSource() == this.resetViewButton) {
            this.cameraV.set(0.0, 0.0, 2.0);
            this.cameraQ.set(0.0, 0.0, 0.0, 1.0);
            this.a3canvas.setCameraLocImmediately(this.cameraV);
            this.a3canvas.setCameraQuatImmediately(this.cameraQ);
        } else if (ae.getSource() == this.consoleMenuItem) {
            this.consoleFrame.setVisible(true);
        } else if (ae.getSource() == this.clearConsoleButton) {
            this.consoleTextArea.setText("");
        } else if (ae.getSource() == this.proxyMenuItem) {
            this.proxyConfig();
        } else if (ae.getSource() == this.resetViewMenuItem) {
            this.cameraV.set(0.0, 0.0, 2.0);
            this.cameraQ.set(0.0, 0.0, 0.0, 1.0);
            this.a3canvas.setCameraLocImmediately(this.cameraV);
            this.a3canvas.setCameraQuatImmediately(this.cameraQ);
        } else if (ae.getSource() == this.headLightMenuItem) {
            this.headLight = !this.headLight;
            this.a3canvas.setHeadLightEnable(this.headLight);
        } else if (ae.getSource() == this.snapshotMenuItem) {
            try {
                File f = new File("snapshot.png");
                this.a3canvas.saveImage(f);
            }
            catch (Exception e) {
                System.out.println("A3Board:snapshot");
                e.printStackTrace();
            }
        } else if (ae.getSource() == this.backgroundMenuItem) {
            this.setBackground();
        } else if (ae.getSource() == this.exitMenuItem) {
            System.exit(0);
        } else {
            System.out.append("gaha???");
        }
    }

    void loadAction3D() {
        Action3D.clearCash();
        int returnVal = this.fileChooser.showOpenDialog(this.frame);
        if (returnVal != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = new URL(f.toURI().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        Action3D a3 = null;
        try {
            A23.initA23();
            a3 = Action3D.load((URL)url);
        }
        catch (Exception e) {
            System.out.println("A3Board.loadAction3D. error!");
            e.printStackTrace();
        }
        this.actionNameCB.removeAllItems();
        String[] sss = a3.getActionNames();
        for (int i = 0; i < sss.length; ++i) {
            this.actionNameCB.addItem(sss[i]);
        }
        this.a3canvas.add((A3Object)a3);
        if (this.selectedA3Object != null) {
            this.selectedA3Object.setSelected(false);
        }
        a3.setSelected(true);
        this.selectedA3Object = a3;
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    void repaint() {
        if (this.selectedA3Object == null) {
            return;
        }
        if (!(this.selectedA3Object instanceof Action3D)) {
            return;
        }
        ((Action3D)this.selectedA3Object).change((Serializable)((Object)this.actionName));
    }

    void proxyConfig() {
        if (this.proxyPanel == null) {
            this.proxyPanel = new ProxyPanel();
            this.proxyData[0] = System.getProperty("proxyHost");
            this.proxyData[1] = System.getProperty("proxyPort");
            this.proxyData[2] = System.getProperty("ftpProxyHost");
            this.proxyData[3] = System.getProperty("ftpProxyPort");
        }
        this.proxyPanel.setData(this.proxyData);
        Object[] options = new Object[]{"Ok", "Cancel"};
        int result = JOptionPane.showOptionDialog(this.frame, this.proxyPanel, "proxy", -1, 1, null, options, options[0]);
        if (result == 0) {
            this.proxyData = this.proxyPanel.getData();
            if (!this.proxyData[0].equals("")) {
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("proxyHost", this.proxyData[0]);
                System.getProperties().put("proxyPort", this.proxyData[1]);
            } else {
                System.getProperties().put("proxySet", "false");
                System.getProperties().put("proxyHost", "");
                System.getProperties().put("proxyPort", "");
            }
            if (!this.proxyData[2].equals("")) {
                System.getProperties().put("ftpProxySet", "true");
                System.getProperties().put("ftpProxyHost", this.proxyData[2]);
                System.getProperties().put("ftpProxyPort", this.proxyData[3]);
            } else {
                System.getProperties().put("ftpProxySet", "false");
                System.getProperties().put("ftpProxyHost", "");
                System.getProperties().put("ftpProxyPort", "");
            }
        }
    }

    void setBackground() {
        int returnVal = this.fileChooser.showOpenDialog(this.frame);
        if (returnVal != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = new URL(f.toURI().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        Action3D a = null;
        try {
            a = Action3D.load((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (a != null) {
            this.a3canvas.setBackground((A3Object)a);
        }
    }

    public static void main(String[] args) {
        System.setSecurityManager(null);
        final String[] argsCopy = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new A3Board(argsCopy);
            }
        });
    }

    class MyA3Adapter
    extends A3Adapter {
        MyA3Adapter() {
        }

        public void mouseClicked(A3Event ae) {
            A3Object a3 = ae.getA3Object();
            if (a3 == null) {
                if (A3Board.this.selectedA3Object != null) {
                    A3Board.this.selectedA3Object.setSelected(false);
                    A3Board.this.selectedA3Object = null;
                }
            } else {
                if (A3Board.this.selectedA3Object != null) {
                    A3Board.this.selectedA3Object.setSelected(false);
                }
                a3.setSelected(true);
                A3Board.this.selectedA3Object = a3;
                if (a3 instanceof Action3D) {
                    int an = ((Action3D)a3).getActionNo();
                    A3Board.this.actionNameCB.removeAllItems();
                    String[] sss = ((Action3D)a3).getActionNames();
                    for (int i = 0; i < sss.length; ++i) {
                        A3Board.this.actionNameCB.addItem(sss[i]);
                    }
                    A3Board.this.actionNameCB.setSelectedIndex(an);
                }
            }
        }

        public void mouseDoubleClicked(A3Event ae) {
            A3Object a3 = ae.getA3Object();
            if (a3 == null) {
                return;
            }
            System.out.println("double clicked!");
        }
    }

    class MyKeyAdapter
    extends KeyAdapter {
        MyKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent ke) {
            System.out.println("'" + ke.getKeyChar() + "' pressed.");
        }
    }

    class ProxyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField httpHostTF;
        JTextField httpPortTF;
        JTextField ftpHostTF;
        JTextField ftpPortTF;

        public ProxyPanel() {
            Box b0 = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            Box b2 = Box.createHorizontalBox();
            this.add(b0);
            b0.add(b1);
            b0.add(b2);
            b1.add(new JLabel("http: host"));
            this.httpHostTF = new JTextField(40);
            b1.add(this.httpHostTF);
            b1.add(new JLabel(" port "));
            this.httpPortTF = new JTextField(5);
            b1.add(this.httpPortTF);
            b2.add(new JLabel("ftp: host"));
            this.ftpHostTF = new JTextField(40);
            b2.add(this.ftpHostTF);
            b2.add(new JLabel(" port "));
            this.ftpPortTF = new JTextField(5);
            b2.add(this.ftpPortTF);
        }

        public void setData(String[] proxyData) {
            this.httpHostTF.setText(proxyData[0]);
            this.httpPortTF.setText(proxyData[1]);
            this.ftpHostTF.setText(proxyData[2]);
            this.ftpPortTF.setText(proxyData[3]);
        }

        public String[] getData() {
            String[] ret = new String[]{this.httpHostTF.getText(), this.httpPortTF.getText(), this.ftpHostTF.getText(), this.ftpPortTF.getText()};
            return ret;
        }
    }

    static enum Mode {
        NAVI,
        EDIT,
        EXAM;

    }
}

