/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.ruleset.Rule;
import com.sun.deploy.security.ruleset.RuleAction;
import com.sun.deploy.security.ruleset.RuleId;
import com.sun.deploy.security.ruleset.RuleParseException;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.GeneralUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RuleSetParser
extends DefaultHandler {
    private List ruleList = new ArrayList();
    private String idTitle;
    private String idLocation;
    private String idCertAlgorithm;
    private String idCertHash;
    private String idChecksumAlgorithm;
    private String idChecksumHash;
    private String actionPerms;
    private String actionVersion;
    private boolean actionForced;
    private String actionMessage;
    private String drsVersion;
    private RuleAction actionRule;
    private ArrayList idJnlpChecksum;
    private RuleId idRule;
    private boolean inRuleSet;
    private boolean inRule;
    private boolean inId;
    private boolean inMessage;
    private boolean inAction;
    private String customerStr;
    private String customerRecord;
    private String lastCharacters;
    private static final String DTD_DOWNLOAD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String EXTERNAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETERS = "http://xml.org/sax/features/external-parameter-entities";

    public Rule[] parse(InputStream inputStream) throws RuleParseException {
        Rule[] ruleArray = new Rule[]{};
        SAXParserFactory sAXParserFactory = Config.isJavaVersionAtLeast16() ? SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", null) : SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        try {
            sAXParserFactory.setFeature(DTD_DOWNLOAD, false);
            sAXParserFactory.setFeature(EXTERNAL_ENTITIES, false);
            sAXParserFactory.setFeature(EXTERNAL_PARAMETERS, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Trace.ignored(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Trace.ignored(sAXException);
        }
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
            ruleArray = this.ruleList.toArray(new Rule[0]);
            if (this.drsVersion == null) {
                String string = ResourceManager.getString("deployment.blocked.ruleset.spec.version", this.drsVersion);
                Trace.println("Deployment Rule Set parsing error: ruleset version required attribute missing.", TraceLevel.RULESET);
                throw new RuleParseException(string, null, RuleParseException.REASON_INVALID_DRS_VERSION, 0);
            }
            VersionString versionString = new VersionString(this.drsVersion);
            if (!(versionString.contains(new VersionID("1.0")) || versionString.contains(new VersionID("1.1")) || versionString.contains(new VersionID("1.2")) || versionString.contains(new VersionID("1.3")))) {
                String string = ResourceManager.getString("deployment.blocked.ruleset.spec.version", this.drsVersion);
                Trace.println("Deployment Rule Set parsing error: ruleset version: " + versionString + " not supported.", TraceLevel.RULESET);
                throw new RuleParseException(string, null, RuleParseException.REASON_INVALID_DRS_VERSION, 0);
            }
        }
        catch (SAXException sAXException) {
            Trace.println("exception parsing ruleset file: " + sAXException, TraceLevel.RULESET);
            Trace.ignored(sAXException);
            String string = ResourceManager.getString("deployment.blocked.ruleset.exception");
            throw new RuleParseException(string, (Throwable)sAXException, RuleParseException.REASON_EXCEPTION, this.ruleList.size());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Trace.println("exception parsing ruleset file: " + parserConfigurationException, TraceLevel.RULESET);
            Trace.ignored(parserConfigurationException);
            String string = ResourceManager.getString("deployment.blocked.ruleset.exception");
            throw new RuleParseException(string, (Throwable)parserConfigurationException, RuleParseException.REASON_EXCEPTION, this.ruleList.size());
        }
        catch (IOException iOException) {
            Trace.println("exception parsing ruleset file: " + iOException, TraceLevel.RULESET);
            Trace.ignored(iOException);
            String string = ResourceManager.getString("deployment.blocked.ruleset.exception");
            throw new RuleParseException(string, (Throwable)iOException, RuleParseException.REASON_EXCEPTION, this.ruleList.size());
        }
        int n = ruleArray.length;
        Trace.println("RuleSetParser.parse() returning " + n + " rules:", TraceLevel.RULESET);
        for (int i = 0; i < n; ++i) {
            Trace.println(ruleArray[i].toString(), TraceLevel.RULESET);
        }
        return ruleArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.customerStr != null) {
            this.customerStr = this.customerStr + "<" + string3;
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.customerStr = this.customerStr + " " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"";
            }
            this.customerStr = this.customerStr + ">";
        } else if (string3.equalsIgnoreCase("ruleset")) {
            this.inRuleSet = true;
            this.drsVersion = attributes.getValue("version");
            arrayList.add("version");
            arrayList.add("href");
        } else if (string3.equalsIgnoreCase("rule")) {
            if (!this.inRuleSet) {
                throw new SAXException("element " + string3 + " is invalid outsize of ruleset element.");
            }
            this.inRule = true;
            this.idRule = null;
            this.actionRule = null;
        } else if (string3.equalsIgnoreCase("id")) {
            if (!this.inRule) {
                throw new SAXException("element " + string3 + " is invalid outsize of rule element.");
            }
            this.idLocation = attributes.getValue("location");
            arrayList.add("location");
            this.idTitle = attributes.getValue("title");
            arrayList.add("title");
            this.idCertHash = null;
            this.idCertAlgorithm = null;
            this.idChecksumHash = null;
            this.idChecksumAlgorithm = null;
            this.idJnlpChecksum = new ArrayList();
            this.inId = true;
        } else if (string3.equalsIgnoreCase("action")) {
            if (!this.inRule) {
                throw new SAXException("element " + string3 + " is invalid outsize of rule element.");
            }
            this.inAction = true;
            this.actionPerms = attributes.getValue("permission");
            arrayList.add("permission");
            if (!(this.actionPerms == null || this.actionPerms.equalsIgnoreCase("run") || this.actionPerms.equalsIgnoreCase("block") || this.actionPerms.equalsIgnoreCase("default"))) {
                throw new SAXException("value " + this.actionPerms + " is invalid value for permission attribute.");
            }
            this.actionVersion = attributes.getValue("version");
            arrayList.add("version");
            if (!this.isValidJavaVersion(this.actionVersion)) {
                throw new SAXException("value " + this.actionVersion + " is invalid value for version attribute.");
            }
            boolean bl = "true".equalsIgnoreCase(attributes.getValue("force"));
            arrayList.add("force");
            if (bl && this.actionVersion != null) {
                if (this.DRSVersionAtLeast11()) {
                    this.actionForced = true;
                } else {
                    Trace.println("WARNING: run rule version with force=true not used because DRS version is: " + this.drsVersion);
                }
            } else if (bl) {
                Trace.println("WARNING: run rule force set without version");
            }
        } else if (string3.equalsIgnoreCase("certificate")) {
            if (!this.inId) throw new SAXException("element " + string3 + " is invalid outsize of id element.");
            this.idCertHash = attributes.getValue("hash");
            arrayList.add("hash");
            if (this.idCertHash == null) {
                throw new SAXException("<certificate> element must have hash attribute.");
            }
            this.idCertHash = this.idCertHash.replaceAll(":", "");
            this.idCertAlgorithm = attributes.getValue("algorithm");
            arrayList.add("algorithm");
        } else if (string3.equalsIgnoreCase("checksum")) {
            if (!this.inId) throw new SAXException("element " + string3 + " is invalid outsize of id element.");
            if (!this.DRSVersionAtLeast12()) throw new SAXException("element " + string3 + " is invalid in DRS version " + this.drsVersion);
            this.idChecksumHash = attributes.getValue("hash");
            arrayList.add("hash");
            if (this.idChecksumHash == null) {
                throw new SAXException("<checksum> element must have hash attribute.");
            }
            String string4 = attributes.getValue("algorithm");
            if (string4 == null || string4.equalsIgnoreCase("SHA-256")) {
                this.idChecksumAlgorithm = string4;
            } else {
                Trace.println("Warning: Unexpected value \"" + string4 + "\" for algorithm attribute in element \"" + string3 + "\" found when processing the Deployment Rule Set.");
            }
            arrayList.add("algorithm");
        } else if (string3.equalsIgnoreCase("message")) {
            if (!this.DRSVersionAtLeast12() && !this.inAction) {
                throw new SAXException("element " + string3 + " is invalid outsize of action element.");
            }
            String string5 = attributes.getValue("locale");
            arrayList.add("locale");
            if (string5 == null || GeneralUtil.matchLocale(string5, Locale.getDefault())) {
                this.inMessage = true;
            }
        } else if (string3.equalsIgnoreCase("jnlp-checksum")) {
            if (!this.inId || this.idLocation == null) throw new SAXException("element " + string3 + " is invalid outsize of location based id element.");
            String string6 = attributes.getValue("hash");
            arrayList.add("hash");
            if (string6 == null || this.idJnlpChecksum == null) throw new SAXException("<jnlp-checksum> element must have hash attribute.");
            this.idJnlpChecksum.add(string6);
        } else if (string3.equalsIgnoreCase("customer")) {
            this.customerStr = this.getIndent() + "<" + string3;
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.customerStr = this.customerStr + " " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"";
            }
            this.customerStr = this.customerStr + ">";
        } else {
            Trace.println("Warning: Unexpected element \"" + string3 + "\" found when processing the Deployment Rule Set.  This may cause all applications to be blocked in a future release.");
        }
        if (this.customerStr != null) return;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string7 = attributes.getQName(i);
            if (arrayList.contains(string7)) continue;
            Trace.println("Warning: Unexpected attribute \"" + string7 + "\" for element \"" + string3 + "\" found when processing the Deployment Rule Set.");
        }
    }

    private boolean DRSVersionAtLeast11() {
        VersionString versionString = new VersionString("1.1+");
        return versionString.contains(this.drsVersion);
    }

    private boolean DRSVersionAtLeast12() {
        VersionString versionString = new VersionString("1.2+");
        return versionString.contains(this.drsVersion);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.lastCharacters = null;
        if (this.customerStr != null) {
            if (string3.equalsIgnoreCase("customer")) {
                this.customerStr = this.customerStr + "</" + string3 + ">";
                Trace.println(this.customerStr);
                this.addCustomerRecord(this.customerStr);
                this.customerStr = null;
            } else {
                this.customerStr = this.customerStr + "</" + string3 + ">";
            }
        } else if (string3.equalsIgnoreCase("ruleset")) {
            this.inRuleSet = false;
        } else if (string3.equalsIgnoreCase("rule")) {
            if (this.inRule) {
                if (this.idRule == null || this.actionRule == null) {
                    throw new SAXException("<rule> element must have both <id> and <action> sub-elements.");
                }
                this.validateRule(this.idRule, this.actionRule, this.ruleList.size());
                Rule rule = new Rule(this.idRule, this.actionRule, this.customerRecord);
                this.idRule = null;
                this.actionRule = null;
                this.customerRecord = null;
                this.ruleList.add(rule);
            }
            this.inRule = false;
        } else if (string3.equalsIgnoreCase("id")) {
            String[] stringArray = null;
            if (this.idJnlpChecksum != null && !this.idJnlpChecksum.isEmpty()) {
                stringArray = this.idJnlpChecksum.toArray(new String[0]);
            }
            this.idRule = new RuleId(this.idTitle, this.idLocation, this.idCertAlgorithm, this.idCertHash, this.idChecksumAlgorithm, this.idChecksumHash, stringArray);
            this.idLocation = null;
            this.idTitle = null;
            this.idCertHash = null;
            this.idCertAlgorithm = null;
            this.idChecksumHash = null;
            this.idChecksumAlgorithm = null;
            this.idJnlpChecksum = null;
            this.inId = false;
        } else if (string3.equalsIgnoreCase("action")) {
            this.inAction = false;
            this.actionRule = new RuleAction(this.actionPerms, this.actionVersion, this.actionForced, this.actionMessage);
            this.actionPerms = null;
            this.actionVersion = null;
            this.actionMessage = null;
            this.actionForced = false;
        } else if (!string3.equalsIgnoreCase("certificate") && string3.equalsIgnoreCase("message")) {
            this.inMessage = false;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.inMessage) {
            this.actionMessage = this.actionMessage == null ? string : this.actionMessage + string;
        } else if (this.customerStr != null) {
            this.customerStr = this.customerStr + string;
        } else {
            this.lastCharacters = string;
        }
    }

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        Trace.println("Warning: entity " + string + ", " + string2 + " ignored while parsing ruleset.xml", TraceLevel.RULESET);
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    private String getIndent() {
        if (this.lastCharacters == null) {
            return "";
        }
        int n = this.lastCharacters.lastIndexOf("\n");
        return n >= 0 && n < this.lastCharacters.length() - 1 ? this.lastCharacters.substring(n + 1) : this.lastCharacters;
    }

    private void validateRule(RuleId ruleId, RuleAction ruleAction, int n) throws RuleParseException {
        String string;
        int n2;
        boolean bl = false;
        int n3 = RuleParseException.REASON_UNKNOWN;
        if (ruleAction.isRun() && ruleId.location == null && ruleId.certHash == null && ruleId.checksumHash == null) {
            Trace.println("Deployment Rule Set invalid rule: run rule must must have either location, certificate, or checksum.", TraceLevel.RULESET);
            bl = true;
            n3 = RuleParseException.REASON_INVALID_RUN_RULE;
        }
        if (ruleAction.isDefault() && ruleId.title != null && ruleId.location == null && ruleId.certHash == null && ruleId.checksumHash == null) {
            Trace.println("Deployment Rule Set invalid rule: default rule with title must have either location, certificate, or checksum.", TraceLevel.RULESET);
            bl = true;
            n3 = RuleParseException.REASON_INVALID_DEFAULT_RULE;
        }
        if (this.actionRule.isRun() && this.idLocation != null && this.idRule.certHash == null && this.idRule.checksumHash == null && !this.idLocation.startsWith("https")) {
            Trace.println("It is recommended to use https protocol when defining a run rule based solely on location", TraceLevel.RULESET);
        }
        if (!bl && ruleId.certHash != null) {
            n2 = ruleId.certHash.length();
            string = ruleId.certHash;
            if (n2 == 0) {
                Trace.println("Deployment Rule Set invalid rule: certificate hash empty String.", TraceLevel.RULESET);
                bl = true;
                n3 = RuleParseException.REASON_INVALID_CERT_HASH;
            } else if ((ruleId.certAlgorithm == null || ruleId.certAlgorithm.equals("SHA-256")) && n2 != 64) {
                Trace.println("Deployment Rule Set invalid rule: certificate hash for SHA-256 not 64 characters.", TraceLevel.RULESET);
                bl = true;
                n3 = RuleParseException.REASON_INVALID_CERT_HASH;
            }
        }
        if (!bl && ruleId.checksumHash != null && (n2 = ruleId.checksumHash.length()) == 0) {
            Trace.println("Deployment Rule Set invalid rule: checksum hash empty String.", TraceLevel.RULESET);
            bl = true;
            n3 = RuleParseException.REASON_INVALID_CHECKSUM_HASH;
        }
        if (!bl && ruleId.jnlpHash != null) {
            for (String string2 : ruleId.jnlpHash) {
                int n4 = string2.length();
                if (n4 != 0) continue;
                Trace.println("Deployment Rule Set invalid rule: jnlp-checksum hash empty String.", TraceLevel.RULESET);
                bl = true;
                n3 = RuleParseException.REASON_INVALID_CHECKSUM_HASH;
            }
        }
        if (!bl && ruleId.title != null) {
            int n5 = ruleId.title.length();
            if (n5 == 0) {
                Trace.println("Deployment Rule Set invalid rule: title is empty String", TraceLevel.RULESET);
                bl = true;
                n3 = RuleParseException.REASON_INVALID_TITLE;
            } else if (n5 > 140) {
                Trace.println("Deployment Rule Set invalid rule: title exceeds 140 characters.", TraceLevel.RULESET);
                bl = true;
                n3 = RuleParseException.REASON_INVALID_TITLE;
            }
        }
        if (!bl && ruleId.location != null) {
            int n6 = ruleId.location.length();
            if (n6 > 256) {
                Trace.println("Deployment Rule Set invalid rule: location exceeds 256 characters.", TraceLevel.RULESET);
                bl = true;
                n3 = RuleParseException.REASON_INVALID_LOCATION;
            } else {
                string = null;
                int n7 = ruleId.location.indexOf("://");
                if (n7 > 0) {
                    string = ruleId.location.substring(0, n7);
                }
                if (!(string == null || "http".equals(string) || "https".equals(string) || "file".equals(string))) {
                    Trace.println("Deployment Rule Set invalid rule: location uses invalid protocol: " + string, TraceLevel.RULESET);
                    bl = true;
                    n3 = RuleParseException.REASON_INVALID_LOCATION;
                }
            }
        }
        if (bl) {
            String string3 = ResourceManager.getString("deployment.blocked.ruleset.invalid.rule");
            Trace.println(string3, TraceLevel.RULESET);
            throw new RuleParseException(string3, null, n3, n);
        }
    }

    private boolean isValidJavaVersion(String string) {
        if (string == null) {
            return true;
        }
        if (string.equals("SECURE")) {
            return true;
        }
        if (string.startsWith("SECURE-")) {
            char c;
            String string2 = string.substring("SECURE-".length());
            if (string2 == null) {
                return false;
            }
            return string2.length() >= 3 && string2.startsWith("1.") && (c = string2.charAt(2)) >= '3' && c <= '9';
        }
        VersionString versionString = new VersionString(string);
        return versionString != null;
    }

    private void addCustomerRecord(String string) {
        this.customerRecord = this.customerRecord == null ? string : this.customerRecord + "\n" + string;
    }
}

