/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class ZeroCrossingCounter
extends UnitGenerator {
    private static final double THRESHOLD = 1.0E-4;
    public UnitInputPort input = new UnitInputPort("Input");
    public UnitOutputPort output;
    private long count;
    private boolean armed;

    public ZeroCrossingCounter() {
        this.addPort(this.input);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.output.getValues();
        for (int i = n; i < n2; ++i) {
            double d = dArray[i];
            if (d < -1.0E-4) {
                this.armed = true;
            } else if (this.armed & d > 1.0E-4) {
                ++this.count;
                this.armed = false;
            }
            dArray2[i] = d;
        }
    }

    public long getCount() {
        return this.count;
    }
}

