/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.GrainCommon;
import com.jsyn.unitgen.GrainSource;
import com.jsyn.unitgen.SineOscillator;

public class GrainSourceSine
extends GrainCommon
implements GrainSource {
    protected double phase;
    protected double phaseIncrement;

    public GrainSourceSine() {
        this.setRate(1.0);
    }

    public void setPhaseIncrement(double d) {
        this.phaseIncrement = d;
    }

    @Override
    public double next() {
        this.phase += this.phaseIncrement;
        if (this.phase > 1.0) {
            this.phase -= 2.0;
        }
        return SineOscillator.fastSin(this.phase);
    }

    @Override
    public void setRate(double d) {
        this.setPhaseIncrement(d * 0.1 / Math.PI);
    }
}

