/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

public class Spectrum {
    private double[] real;
    private double[] imaginary;
    public static final int DEFAULT_SIZE_LOG_2 = 9;
    public static final int DEFAULT_SIZE = 512;

    public Spectrum() {
        this(512);
    }

    public Spectrum(int n) {
        this.setSize(n);
    }

    public double[] getReal() {
        return this.real;
    }

    public double[] getImaginary() {
        return this.imaginary;
    }

    public void setSize(int n) {
        if (this.real == null || this.real.length != n) {
            this.real = new double[n];
            this.imaginary = new double[n];
        }
    }

    public int size() {
        return this.real.length;
    }

    public void copyTo(Spectrum spectrum) {
        assert (this.size() == spectrum.size());
        System.arraycopy(this.real, 0, spectrum.real, 0, this.real.length);
        System.arraycopy(this.imaginary, 0, spectrum.imaginary, 0, this.imaginary.length);
    }

    public void clear() {
        for (int i = 0; i < this.real.length; ++i) {
            this.real[i] = 0.0;
            this.imaginary[i] = 0.0;
        }
    }
}

