/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.util.Callback;

abstract class MultipleSelectionModelBase<T>
extends MultipleSelectionModel<T> {
    final BitSet selectedIndices;
    final BitSetReadOnlyUnbackedObservableList selectedIndicesSeq;
    private final ReadOnlyUnbackedObservableList<T> selectedItemsSeq;
    ListChangeListener.Change selectedItemChange;
    private int atomicityCount = 0;

    public MultipleSelectionModelBase() {
        this.selectedIndexProperty().addListener(observable -> this.setSelectedItem(this.getModelItem(this.getSelectedIndex())));
        this.selectedIndices = new BitSet();
        this.selectedIndicesSeq = new BitSetReadOnlyUnbackedObservableList(this.selectedIndices);
        final MappingChange.Map<Integer, Object> map = n -> this.getModelItem((int)n);
        this.selectedIndicesSeq.addListener(new ListChangeListener<Integer>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Integer> change) {
                boolean bl = false;
                while (change.next() && !bl) {
                    bl = change.wasAdded() || change.wasRemoved();
                }
                if (bl) {
                    if (MultipleSelectionModelBase.this.selectedItemChange != null) {
                        MultipleSelectionModelBase.this.selectedItemsSeq.callObservers(MultipleSelectionModelBase.this.selectedItemChange);
                    } else {
                        change.reset();
                        MultipleSelectionModelBase.this.selectedItemsSeq.callObservers(new MappingChange(change, map, MultipleSelectionModelBase.this.selectedItemsSeq));
                    }
                }
                change.reset();
            }
        });
        this.selectedItemsSeq = new ReadOnlyUnbackedObservableList<T>(){

            @Override
            public T get(int n) {
                int n2 = MultipleSelectionModelBase.this.selectedIndicesSeq.get(n);
                return MultipleSelectionModelBase.this.getModelItem(n2);
            }

            @Override
            public int size() {
                return MultipleSelectionModelBase.this.selectedIndices.cardinality();
            }
        };
    }

    @Override
    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndicesSeq;
    }

    @Override
    public ObservableList<T> getSelectedItems() {
        return this.selectedItemsSeq;
    }

    boolean isAtomic() {
        return this.atomicityCount > 0;
    }

    void startAtomic() {
        ++this.atomicityCount;
    }

    void stopAtomic() {
        this.atomicityCount = Math.max(0, --this.atomicityCount);
    }

    protected abstract int getItemCount();

    protected abstract T getModelItem(int var1);

    protected abstract void focus(int var1);

    protected abstract int getFocusedIndex();

    void shiftSelection(int n, int n2, Callback<ShiftParams, Void> callback) {
        int n3;
        if (n < 0) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        int n4 = this.selectedIndices.cardinality();
        if (n4 == 0) {
            return;
        }
        int n5 = this.selectedIndices.size();
        int[] nArray = new int[n5];
        int n6 = 0;
        boolean bl2 = false;
        if (n2 > 0) {
            for (n3 = n5 - 1; n3 >= n && n3 >= 0; --n3) {
                boolean bl = this.selectedIndices.get(n3);
                if (callback == null) {
                    this.selectedIndices.clear(n3);
                    this.selectedIndices.set(n3 + n2, bl);
                } else {
                    callback.call(new ShiftParams(n3, n3 + n2, bl));
                }
                if (!bl) continue;
                nArray[n6++] = n3 + 1;
                bl2 = true;
            }
            this.selectedIndices.clear(n);
        } else if (n2 < 0) {
            for (n3 = n; n3 < n5; ++n3) {
                if (n3 + n2 < 0 || n3 + 1 + n2 < n) continue;
                boolean bl = this.selectedIndices.get(n3 + 1);
                if (callback == null) {
                    this.selectedIndices.clear(n3 + 1);
                    this.selectedIndices.set(n3 + 1 + n2, bl);
                } else {
                    callback.call(new ShiftParams(n3 + 1, n3 + 1 + n2, bl));
                }
                if (!bl) continue;
                nArray[n6++] = n3;
                bl2 = true;
            }
        }
        n3 = this.getSelectedIndex();
        if (n3 >= n && n3 > -1) {
            int n7 = Math.max(0, n3 + n2);
            this.setSelectedIndex(n7);
            if (bl2) {
                this.selectedIndices.set(n7, true);
            } else {
                this.select(n7);
            }
        }
        if (bl2) {
            this.selectedIndicesSeq.callObservers(new NonIterableChange.SimplePermutationChange<Integer>(0, n4, nArray, this.selectedIndicesSeq));
        }
    }

    @Override
    public void clearAndSelect(int n) {
        ListChangeListener.Change<Integer> change;
        if (n < 0 || n >= this.getItemCount()) {
            this.clearSelection();
            return;
        }
        boolean bl = this.isSelected(n);
        if (bl && this.getSelectedIndices().size() == 1 && this.getSelectedItem() == this.getModelItem(n)) {
            return;
        }
        BitSet bitSet = new BitSet();
        bitSet.or(this.selectedIndices);
        bitSet.clear(n);
        BitSetReadOnlyUnbackedObservableList bitSetReadOnlyUnbackedObservableList = new BitSetReadOnlyUnbackedObservableList(bitSet);
        this.startAtomic();
        this.clearSelection();
        this.select(n);
        this.stopAtomic();
        if (bl) {
            change = ControlUtils.buildClearAndSelectChange(this.selectedIndicesSeq, bitSetReadOnlyUnbackedObservableList, n);
        } else {
            int n2 = this.selectedIndicesSeq.indexOf(n);
            change = new NonIterableChange.GenericAddRemoveChange<Integer>(n2, n2 + 1, bitSetReadOnlyUnbackedObservableList, this.selectedIndicesSeq);
        }
        this.selectedIndicesSeq.callObservers(change);
    }

    @Override
    public void select(int n) {
        if (n == -1) {
            this.clearSelection();
            return;
        }
        if (n < 0 || n >= this.getItemCount()) {
            return;
        }
        boolean bl = n == this.getSelectedIndex();
        Object t = this.getSelectedItem();
        T t2 = this.getModelItem(n);
        boolean bl2 = t2 != null && t2.equals(t);
        boolean bl3 = bl && !bl2;
        this.startAtomic();
        if (!this.selectedIndices.get(n)) {
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            this.selectedIndices.set(n);
        }
        this.setSelectedIndex(n);
        this.focus(n);
        this.stopAtomic();
        if (!this.isAtomic()) {
            int n2 = Math.max(0, this.selectedIndicesSeq.indexOf(n));
            this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(n2, n2 + 1, this.selectedIndicesSeq));
        }
        if (bl3) {
            this.setSelectedItem(t2);
        }
    }

    @Override
    public void select(T t) {
        if (t == null && this.getSelectionMode() == SelectionMode.SINGLE) {
            this.clearSelection();
            return;
        }
        Object object = null;
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            object = this.getModelItem(i);
            if (object == null || !object.equals(t)) continue;
            if (this.isSelected(i)) {
                return;
            }
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            this.select(i);
            return;
        }
        this.setSelectedIndex(-1);
        this.setSelectedItem(t);
    }

    @Override
    public void selectIndices(int n, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            this.select(n);
            return;
        }
        int n2 = this.getItemCount();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n3 = nArray[i];
                if (n3 < 0 || n3 >= n2) continue;
                this.selectedIndices.set(n3);
                this.select(n3);
                break;
            }
            if (this.selectedIndices.isEmpty() && n > 0 && n < n2) {
                this.selectedIndices.set(n);
                this.select(n);
            }
            this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(0, 1, this.selectedIndicesSeq));
        } else {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n4 = -1;
            if (n >= 0 && n < n2) {
                n4 = n;
                if (!this.selectedIndices.get(n)) {
                    this.selectedIndices.set(n);
                    arrayList.add(n);
                }
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n5 = nArray[i];
                if (n5 < 0 || n5 >= n2) continue;
                n4 = n5;
                if (this.selectedIndices.get(n5)) continue;
                this.selectedIndices.set(n5);
                arrayList.add(n5);
            }
            if (n4 != -1) {
                this.setSelectedIndex(n4);
                this.focus(n4);
                this.setSelectedItem(this.getModelItem(n4));
            }
            Collections.sort(arrayList);
            ListChangeListener.Change<Integer> change = MultipleSelectionModelBase.createRangeChange(this.selectedIndicesSeq, arrayList, false);
            this.selectedIndicesSeq.callObservers(change);
        }
    }

    static ListChangeListener.Change<Integer> createRangeChange(final ObservableList<Integer> observableList, final List<Integer> list, final boolean bl) {
        ListChangeListener.Change<Integer> change = new ListChangeListener.Change<Integer>(observableList){
            private final int[] EMPTY_PERM;
            private final int addedSize;
            private boolean invalid;
            private int pos;
            private int from;
            private int to;
            {
                super(observableList3);
                this.EMPTY_PERM = new int[0];
                this.addedSize = list.size();
                this.invalid = true;
                this.from = this.pos = 0;
                this.to = this.pos;
            }

            @Override
            public int getFrom() {
                this.checkState();
                return this.from;
            }

            @Override
            public int getTo() {
                this.checkState();
                return this.to;
            }

            @Override
            public List<Integer> getRemoved() {
                this.checkState();
                return Collections.emptyList();
            }

            @Override
            protected int[] getPermutation() {
                this.checkState();
                return this.EMPTY_PERM;
            }

            @Override
            public int getAddedSize() {
                return this.to - this.from;
            }

            @Override
            public boolean next() {
                if (this.pos >= this.addedSize) {
                    return false;
                }
                int n = (Integer)list.get(this.pos++);
                this.from = observableList.indexOf(n);
                this.to = this.from + 1;
                int n2 = n;
                while (this.pos < this.addedSize) {
                    int n3 = n2;
                    n2 = (Integer)list.get(this.pos++);
                    ++this.to;
                    if (!bl || n3 == n2 - 1) continue;
                    break;
                }
                if (this.invalid) {
                    this.invalid = false;
                    return true;
                }
                return bl && this.pos < this.addedSize;
            }

            @Override
            public void reset() {
                this.invalid = true;
                this.pos = 0;
                this.to = 0;
                this.from = 0;
            }

            private void checkState() {
                if (this.invalid) {
                    throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
                }
            }
        };
        return change;
    }

    @Override
    public void selectAll() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        if (this.getItemCount() <= 0) {
            return;
        }
        int n = this.getItemCount();
        int n2 = this.getFocusedIndex();
        this.clearSelection();
        this.selectedIndices.set(0, n, true);
        this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(0, n, this.selectedIndicesSeq));
        if (n2 == -1) {
            this.setSelectedIndex(n - 1);
            this.focus(n - 1);
        } else {
            this.setSelectedIndex(n2);
            this.focus(n2);
        }
    }

    @Override
    public void selectFirst() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (this.getItemCount() > 0) {
            this.select(0);
        }
    }

    @Override
    public void selectLast() {
        int n;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if ((n = this.getItemCount()) > 0 && this.getSelectedIndex() < n - 1) {
            this.select(n - 1);
        }
    }

    @Override
    public void clearSelection(int n) {
        if (n < 0) {
            return;
        }
        boolean bl = this.selectedIndices.isEmpty();
        this.selectedIndices.clear(n);
        if (!bl && this.selectedIndices.isEmpty()) {
            this.clearSelection();
        }
        if (!this.isAtomic()) {
            this.selectedIndicesSeq.callObservers(new NonIterableChange.GenericAddRemoveChange<Integer>(n, n, Collections.singletonList(n), this.selectedIndicesSeq));
        }
    }

    @Override
    public void clearSelection() {
        BitSetReadOnlyUnbackedObservableList bitSetReadOnlyUnbackedObservableList = new BitSetReadOnlyUnbackedObservableList((BitSet)this.selectedIndices.clone());
        this.quietClearSelection();
        if (!this.isAtomic()) {
            this.setSelectedIndex(-1);
            this.focus(-1);
            this.selectedIndicesSeq.callObservers(new NonIterableChange.GenericAddRemoveChange<Integer>(0, 0, bitSetReadOnlyUnbackedObservableList, this.selectedIndicesSeq));
        }
    }

    private void quietClearSelection() {
        this.selectedIndices.clear();
    }

    @Override
    public boolean isSelected(int n) {
        if (n >= 0 && n < this.selectedIndices.length()) {
            return this.selectedIndices.get(n);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.selectedIndices.isEmpty();
    }

    @Override
    public void selectPrevious() {
        int n = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (n == -1) {
            this.select(this.getItemCount() - 1);
        } else if (n > 0) {
            this.select(n - 1);
        }
    }

    @Override
    public void selectNext() {
        int n = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (n == -1) {
            this.select(0);
        } else if (n != this.getItemCount() - 1) {
            this.select(n + 1);
        }
    }

    class BitSetReadOnlyUnbackedObservableList
    extends ReadOnlyUnbackedObservableList<Integer> {
        private final BitSet bitset;
        private int lastGetIndex = -1;
        private int lastGetValue = -1;

        public BitSetReadOnlyUnbackedObservableList(BitSet bitSet) {
            this.bitset = bitSet;
        }

        @Override
        public Integer get(int n) {
            int n2 = MultipleSelectionModelBase.this.getItemCount();
            if (n < 0 || n >= n2) {
                return -1;
            }
            if (n == this.lastGetIndex + 1 && this.lastGetValue < n2) {
                ++this.lastGetIndex;
                this.lastGetValue = this.bitset.nextSetBit(this.lastGetValue + 1);
                return this.lastGetValue;
            }
            if (n == this.lastGetIndex - 1 && this.lastGetValue > 0) {
                --this.lastGetIndex;
                this.lastGetValue = this.bitset.previousSetBit(this.lastGetValue - 1);
                return this.lastGetValue;
            }
            this.lastGetIndex = 0;
            this.lastGetValue = this.bitset.nextSetBit(0);
            while (this.lastGetValue >= 0 || this.lastGetIndex == n) {
                if (this.lastGetIndex == n) {
                    return this.lastGetValue;
                }
                ++this.lastGetIndex;
                this.lastGetValue = this.bitset.nextSetBit(this.lastGetValue + 1);
            }
            return -1;
        }

        @Override
        public int size() {
            return this.bitset.cardinality();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Number) {
                Number number = (Number)object;
                int n = number.intValue();
                return n >= 0 && n < this.bitset.length() && this.bitset.get(n);
            }
            return false;
        }

        public void reset() {
            this.lastGetIndex = -1;
            this.lastGetValue = -1;
        }
    }

    static class ShiftParams {
        private final int clearIndex;
        private final int setIndex;
        private final boolean selected;

        ShiftParams(int n, int n2, boolean bl) {
            this.clearIndex = n;
            this.setIndex = n2;
            this.selected = bl;
        }

        public final int getClearIndex() {
            return this.clearIndex;
        }

        public final int getSetIndex() {
            return this.setIndex;
        }

        public final boolean isSelected() {
            return this.selected;
        }
    }
}

