/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import javax.swing.DefaultBoundedRangeModel;

public class DoubleBoundedRangeModel
extends DefaultBoundedRangeModel {
    private static final long serialVersionUID = 284361767102120148L;
    protected String name;
    private double dmin;
    private double dmax;

    public DoubleBoundedRangeModel(String string, int n, double d, double d2, double d3) {
        this.name = string;
        this.dmin = d;
        this.dmax = d2;
        this.setMinimum(0);
        this.setMaximum(n);
        this.setDoubleValue(d3);
    }

    public boolean equivalentTo(Object object) {
        if (!(object instanceof DoubleBoundedRangeModel)) {
            return false;
        }
        DoubleBoundedRangeModel doubleBoundedRangeModel = (DoubleBoundedRangeModel)object;
        return this.getValue() == doubleBoundedRangeModel.getValue();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public double getDoubleMinimum() {
        return this.dmin;
    }

    public double getDoubleMaximum() {
        return this.dmax;
    }

    public double sliderToDouble(int n) {
        double d = this.getDoubleMinimum();
        return d + (this.getDoubleMaximum() - d) * (double)n / (double)this.getMaximum();
    }

    public int doubleToSlider(double d) {
        double d2 = this.getDoubleMinimum();
        return (int)Math.round((double)this.getMaximum() * (d - d2) / (this.getDoubleMaximum() - d2));
    }

    public double getDoubleValue() {
        return this.sliderToDouble(this.getValue());
    }

    public void setDoubleValue(double d) {
        this.setValue(this.doubleToSlider(d));
    }
}

