/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JFrame;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PSurface;
import processing.data.Table;
import processing.data.TableRow;
import processing.sound.SoundFile;

public class AbilityTimer
extends PApplet {
    final String SaveFileName = "save.csv";
    final String ChimeFileName = "chime.mp3";
    ArrayList<GuiItem> timerModeItems = new ArrayList();
    ArrayList<GuiItem> checklistModeItems = new ArrayList();
    ArrayList<Mission> missions = new ArrayList();
    long prevEpochSecond = 0L;
    int toggle = 0;
    int prevMouseX = 0;
    int prevMouseY = 0;
    static final short[][] OcrNumber = new short[][]{{60, 126, 238, 231, 199, 199, 199, 231, 254, 126, 24}, {12, 60, 60, 60, 28, 28, 28, 28, 30, 63, 63}, {62, 127, 103, 7, 7, 7, 14, 28, 60, 127, 63}, {126, 127, 7, 7, 30, 31, 7, 3, 111, 127, 60}, {14, 30, 30, 62, 102, 103, 255, 255, 7, 6, 2}, {127, 126, 112, 112, 126, 127, 7, 3, 111, 126, 56}, {31, 63, 112, 126, 127, 119, 99, 99, 127, 63, 28}, {255, 255, 14, 14, 12, 28, 24, 56, 48, 112, 96}, {126, 127, 231, 247, 126, 127, 231, 227, 255, 127, 28}, {62, 127, 231, 227, 227, 127, 127, 7, 127, 126, 56}, new short[11]};
    int next_y = 5;
    final float[] dmmGemTimeTable = new float[]{12.0f, 20.0f, -1.0f, 12.5f, 21.0f, -1.0f, -1.0f, 18.0f, 21.0f, -1.0f, 19.0f, 22.0f, -1.0f, 20.0f, 23.0f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};
    final float[] nutakuGemTimeTable = new float[]{12.0f, 19.0f, -1.0f, 12.5f, 19.5f, -1.0f, -1.0f, 18.0f, 22.5f, -1.0f, 19.0f, 23.0f, -1.0f, 19.5f, 23.5f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};

    public void settings() {
        this.size(240, 320);
    }

    public void setup() {
        this.surface.setAlwaysOnTop(true);
        PSurfaceAWT.SmoothCanvas smoothCanvas = (PSurfaceAWT.SmoothCanvas)this.surface.getNative();
        JFrame jframe = (JFrame)smoothCanvas.getFrame();
        jframe.dispose();
        jframe.setUndecorated(true);
        jframe.setVisible(true);
        this.surface.setResizable(true);
        this.smooth();
        TimerDisplay tmdisp = new TimerDisplay(20, 5);
        this.timerModeItems.add(tmdisp);
        CloseButton cbutton_t = new CloseButton(110, 0);
        this.timerModeItems.add(cbutton_t);
        MinimizeButton mbutton_t = new MinimizeButton(90, 0);
        this.timerModeItems.add(mbutton_t);
        TimerBar tmbar = new TimerBar(180, 5, 5, tmdisp);
        this.checklistModeItems.add(tmbar);
        PFont font12 = this.loadFont("mplus-2p-bold-12.vlw");
        PFont font24 = this.loadFont("mplus-2m-bold-24.vlw");
        Glbl.setInstances(this.surface, jframe, font12, font24, new SoundFile((PApplet)this, "chime.mp3"));
        Table chkTbl = this.loadTable("save.csv", "header");
        Table itemTbl = this.loadTable("Items.csv", "header");
        ZoneId zoneid = ZoneId.of("America/Los_Angeles");
        int i = 0;
        for (TableRow itemRow : itemTbl.rows()) {
            String name;
            String kind = itemRow.getString("kind");
            if (kind.equals("mission")) {
                TableRow chkRow;
                name = itemRow.getString("name");
                int items = itemRow.getInt("value");
                int value = 0;
                if (chkTbl != null && i < chkTbl.getRowCount() && (chkRow = chkTbl.getRow(i)) != null) {
                    value = chkRow.getInt("value");
                    ++i;
                }
                Mission m = new Mission(name, items, value);
                this.checklistModeItems.add(m);
                this.missions.add(m);
                continue;
            }
            if (!kind.equals("service") || !(name = itemRow.getString("name")).equals("DMM")) continue;
            zoneid = ZoneId.of("Asia/Tokyo");
        }
        WallClock wallc = new WallClock(zoneid);
        this.checklistModeItems.add(wallc);
        this.checklistModeItems.add(new TimerBarLabel(tmbar));
        CloseButton closeb = new CloseButton(220, 0);
        this.checklistModeItems.add(closeb);
        MinimizeButton minib = new MinimizeButton(200, 0);
        this.checklistModeItems.add(minib);
        DrawerButton drawerb = new DrawerButton(220, 127);
        this.checklistModeItems.add(drawerb);
    }

    public void draw() {
        block18: {
            boolean changed;
            block17: {
                Glbl.setBgSelected(true);
                changed = Glbl.prevMode != Glbl.mode;
                Glbl.prevMode = Glbl.mode;
                if (!Glbl.isTimerMode()) break block17;
                this.background(224);
                if (changed) {
                    Glbl.changeSize();
                }
                for (GuiItem item : this.timerModeItems) {
                    item.render();
                }
                break block18;
            }
            boolean mustRedraw = false;
            long currentEpochSecond = Instant.now().getEpochSecond();
            boolean passage0p5sec = false;
            int mil = this.millis() % 1000;
            if (this.toggle == 0) {
                if (mil >= 0 && mil <= 499) {
                    this.toggle = 1;
                    passage0p5sec = true;
                }
            } else if (500 <= mil && mil <= 999) {
                this.toggle = 0;
                passage0p5sec = true;
            }
            if (this.mousePressed) {
                mustRedraw = true;
            } else if (this.pmouseX != this.mouseX || this.pmouseY != this.mouseY) {
                mustRedraw = true;
            } else if (Glbl.isLastOneMinute && currentEpochSecond != this.prevEpochSecond) {
                mustRedraw = true;
            } else if (Glbl.scouterEnabled && passage0p5sec) {
                mustRedraw = true;
            } else if (currentEpochSecond / 60L != this.prevEpochSecond / 60L) {
                mustRedraw = true;
            }
            this.prevEpochSecond = currentEpochSecond;
            if (changed) {
                Glbl.changeSize();
                this.prevEpochSecond = 0L;
            }
            if (!mustRedraw) break block18;
            this.background(224);
            for (GuiItem item : this.checklistModeItems) {
                item.render();
            }
        }
    }

    public void mousePressed() {
        this.prevMouseX = this.mouseX;
        this.prevMouseY = this.mouseY;
        if (Glbl.isTimerMode()) {
            for (GuiItem item : this.timerModeItems) {
                item.press();
            }
        } else {
            for (GuiItem item : this.checklistModeItems) {
                item.press();
            }
        }
    }

    public void mouseReleased() {
    }

    public void mouseDragged() {
        if (Glbl.isBgSelected()) {
            Point mouse = MouseInfo.getPointerInfo().getLocation();
            this.surface.setLocation(mouse.x - this.prevMouseX, mouse.y - this.prevMouseY - 0);
        }
    }

    public void exit() {
        Table tbl = new Table();
        tbl.addColumn("value");
        for (Mission m : this.missions) {
            TableRow row = tbl.addRow();
            row.setInt("value", m.getValue());
        }
        this.saveTable(tbl, "save.csv");
        super.exit();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"AbilityTimer"};
        if (passedArgs != null) {
            PApplet.main((String[])AbilityTimer.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Checkbox
    extends GuiItem {
        boolean checked;
        static final int W = 20;
        static final int H = 20;

        Checkbox(int _x, int _y, boolean _checked) {
            super(_x, _y, 20, 20);
            this.checked = _checked;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 224 : 255);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            if (this.checked) {
                AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.line(this.x + 2, this.y + 10, this.x + 10, this.y + 15);
                AbilityTimer.this.line(this.x + 10, this.y + 15, this.x + 17, this.y + 3);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.checked = !this.checked;
            }
        }

        public boolean get() {
            return this.checked;
        }

        public void set() {
            this.checked = true;
        }

        public void reset() {
            this.checked = false;
        }
    }

    class CloseButton
    extends GuiItem {
        static final int W = 20;
        static final int H = 20;

        CloseButton(int _x, int _y) {
            super(_x, _y, 20, 20);
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 255 : 224);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x + 3, this.y + 3, this.x + 16, this.y + 16);
            AbilityTimer.this.line(this.x + 3, this.y + 16, this.x + 16, this.y + 3);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                AbilityTimer.this.exit();
            }
        }
    }

    class DrawerButton
    extends GuiItem {
        Scouter scouter;
        static final int W = 20;
        static final int H = 40;

        DrawerButton(int _x, int _y) {
            super(_x, _y, 20, 40);
            this.scouter = new Scouter();
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 64 : 0);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 39.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            if (Glbl.scouterEnabled) {
                AbilityTimer.this.line(this.x + 16, this.y + 3, this.x + 3, this.y + 19);
                AbilityTimer.this.line(this.x + 3, this.y + 20, this.x + 16, this.y + 36);
                this.scouter.render();
            } else {
                AbilityTimer.this.line(this.x + 3, this.y + 3, this.x + 16, this.y + 19);
                AbilityTimer.this.line(this.x + 16, this.y + 20, this.x + 3, this.y + 36);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                if (!Glbl.scouterEnabled) {
                    if (this.scouter.initialize()) {
                        Glbl.scouterEnabled = true;
                        Glbl.changeSize();
                    }
                } else {
                    Glbl.scouterEnabled = false;
                    Glbl.changeSize();
                }
            }
        }
    }

    static class Glbl {
        static final int ChecklistMode = 0;
        static final int TimerMode = 1;
        static final int W = 240;
        static final int H = 320;
        static final int TimerW = 130;
        static final int TimerH = 100;
        static final int ScouterWidth = 600;
        static final int OcrNumberW = 8;
        static final int OcrNumberH = 11;
        static int mode = 0;
        static int prevMode = 1;
        static boolean isLastOneMinute = false;
        static boolean scouterEnabled = false;
        static boolean bgSelected = false;
        static PSurface ps;
        static JFrame jf;
        static PFont font12;
        static PFont font24;
        static SoundFile chime;

        Glbl() {
        }

        public static void setInstances(PSurface _ps, JFrame _jf, PFont _f12, PFont _f24, SoundFile _chime) {
            ps = _ps;
            jf = _jf;
            font12 = _f12;
            font24 = _f24;
            chime = _chime;
        }

        public static boolean isTimerMode() {
            return mode == 1;
        }

        public static void changeSize() {
            if (Glbl.isTimerMode()) {
                jf.setOpacity(0.5f);
                ps.setSize(130, 100);
            } else if (scouterEnabled) {
                jf.setOpacity(1.0f);
                ps.setSize(840, 320);
            } else {
                jf.setOpacity(0.75f);
                ps.setSize(240, 320);
            }
        }

        public static void setBgSelected(boolean value) {
            bgSelected = value;
        }

        public static boolean isBgSelected() {
            return bgSelected;
        }

        public static int ocrImage(PImage img) {
            img.filter(16, 0.5f);
            short[] line = new short[11];
            int py = 0;
            while (py < 11) {
                line[py] = 0;
                int px = 0;
                while (px < 8) {
                    int c = img.pixels[8 * py + px];
                    c = (c & 0xFF00) >> 8;
                    int n = py;
                    line[n] = (short)(line[n] << 1);
                    int n2 = py;
                    line[n2] = (short)(line[n2] | (c > 0 ? (short)1 : 0));
                    ++px;
                }
                ++py;
            }
            int num = 0;
            while (num <= 10) {
                boolean match = true;
                int j = 0;
                while (j < 11) {
                    int value = OcrNumber[num][j] ^ line[j];
                    if (value != 0) {
                        int diff = 0;
                        int k = 0;
                        while (k < 8) {
                            diff += value >> k & 1;
                            ++k;
                        }
                        if (diff > 2) {
                            match = false;
                            break;
                        }
                    }
                    ++j;
                }
                if (match) {
                    return num;
                }
                ++num;
            }
            return -1;
        }

        public static int calculateExpToMax(int maxLevel, int level, int nextExp) {
            short[] sArray = new short[50];
            sArray[1] = 10;
            sArray[2] = 15;
            sArray[3] = 20;
            sArray[4] = 25;
            sArray[5] = 30;
            sArray[6] = 35;
            sArray[7] = 40;
            sArray[8] = 45;
            sArray[9] = 50;
            sArray[10] = 55;
            sArray[11] = 60;
            sArray[12] = 65;
            sArray[13] = 70;
            sArray[14] = 75;
            sArray[15] = 80;
            sArray[16] = 85;
            sArray[17] = 90;
            sArray[18] = 95;
            sArray[19] = 100;
            sArray[20] = 120;
            sArray[21] = 140;
            sArray[22] = 160;
            sArray[23] = 180;
            sArray[24] = 200;
            sArray[25] = 220;
            sArray[26] = 240;
            sArray[27] = 260;
            sArray[28] = 280;
            sArray[29] = 300;
            sArray[30] = 320;
            sArray[31] = 340;
            sArray[32] = 360;
            sArray[33] = 380;
            sArray[34] = 400;
            sArray[35] = 420;
            sArray[36] = 440;
            sArray[37] = 460;
            sArray[38] = 480;
            sArray[39] = 500;
            sArray[40] = 520;
            sArray[41] = 540;
            sArray[42] = 560;
            sArray[43] = 580;
            sArray[44] = 600;
            sArray[45] = 620;
            sArray[46] = 640;
            sArray[47] = 660;
            sArray[48] = 680;
            sArray[49] = 700;
            short[] AccessoryExpTable = sArray;
            int result = 0;
            if (level != maxLevel) {
                int i = level + 1;
                while (i <= maxLevel - 1) {
                    result += AccessoryExpTable[i];
                    ++i;
                }
                result += nextExp;
            }
            return result;
        }
    }

    class GuiItem {
        int x;
        int y;
        int itemWidth;
        int itemHeight;

        GuiItem(int _x, int _y, int _itemWidth, int _itemHeight) {
            this.x = _x;
            this.y = _y;
            this.itemWidth = _itemWidth;
            this.itemHeight = _itemHeight;
        }

        GuiItem() {
            this(0, 0, 0, 0);
        }

        public void render() {
        }

        public void press() {
        }

        public boolean isOver() {
            int windowX = Glbl.jf.getX();
            int windowY = Glbl.jf.getY();
            int maxX = windowX + 240;
            int maxY = windowY + 320;
            boolean rc = false;
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info != null) {
                Point mouse = info.getLocation();
                if (windowX <= mouse.x && mouse.x < maxX && windowY <= mouse.y && mouse.y < maxY) {
                    int mx = AbilityTimer.this.mouseX;
                    int my = AbilityTimer.this.mouseY;
                    boolean bl = rc = this.x <= mx && mx < this.x + this.itemWidth && this.y <= my && my < this.y + this.itemHeight;
                }
            }
            if (rc) {
                Glbl.setBgSelected(false);
            }
            return rc;
        }
    }

    class MinimizeButton
    extends GuiItem {
        static final int W = 20;
        static final int H = 20;

        MinimizeButton(int _x, int _y) {
            super(_x, _y, 20, 20);
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 255 : 224);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x + 3, this.y + 12, this.x + 16, this.y + 12);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                Glbl.jf.setExtendedState(Glbl.jf.getExtendedState() | 1);
            }
        }
    }

    class Mission
    extends GuiItem {
        String name;
        Checkbox[] boxes;
        int y;
        final int delta_y = 29;

        Mission(String _name, int _items, int _value) {
            this.name = _name;
            this.boxes = new Checkbox[_items];
            this.y = AbilityTimer.this.next_y;
            AbilityTimer.this.next_y += 29;
            int i = 0;
            while (i < this.boxes.length) {
                this.boxes[i] = new Checkbox(115 + 25 * i, this.y, i < _value);
                ++i;
            }
        }

        @Override
        public void render() {
            boolean isCurrent = false;
            Checkbox[] checkboxArray = this.boxes;
            int n = this.boxes.length;
            int n2 = 0;
            while (n2 < n) {
                Checkbox box = checkboxArray[n2];
                box.render();
                isCurrent = isCurrent ? true : box.isOver();
                ++n2;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            if (isCurrent) {
                AbilityTimer.this.fill(128);
                AbilityTimer.this.text(this.name, 5.0f, this.y + 15);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, 4.0f, this.y + 15 - 1);
            } else {
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, 5.0f, this.y + 15);
            }
        }

        @Override
        public void press() {
            int i = 0;
            while (i < this.boxes.length) {
                int j;
                this.boxes[i].press();
                if (this.boxes[i].get()) {
                    j = i - 1;
                    while (j >= 0) {
                        this.boxes[j].set();
                        --j;
                    }
                } else {
                    j = i + 1;
                    while (j < this.boxes.length) {
                        this.boxes[j].reset();
                        ++j;
                    }
                }
                ++i;
            }
        }

        public int getValue() {
            int i = this.boxes.length - 1;
            while (i >= 0) {
                if (this.boxes[i].get()) break;
                --i;
            }
            return i + 1;
        }
    }

    class Scouter {
        Robot bot;
        Rectangle area;
        PImage fullImg;
        PImage windowImg;
        WritableRaster wr;

        Scouter() {
        }

        public boolean initialize() {
            boolean result = false;
            try {
                this.bot = new Robot();
                this.area = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
                result = true;
            }
            catch (AWTException aWTException) {}
            return result;
        }

        public boolean findKamihimeWindow() {
            BufferedImage bimg = this.bot.createScreenCapture(this.area);
            if (this.fullImg == null) {
                this.fullImg = new PImage((Image)bimg);
                DataBufferInt dbi = new DataBufferInt(this.fullImg.pixels, this.fullImg.pixels.length);
                this.wr = Raster.createWritableRaster(bimg.getSampleModel(), dbi, new Point(0, 0));
                this.fullImg.loadPixels();
            } else {
                bimg.copyData(this.wr);
                this.fullImg.updatePixels();
            }
            int maxX = this.fullImg.width - 1;
            int maxY = this.fullImg.height - 8;
            int px = 0;
            int py = 0;
            px = 0;
            while (px <= maxX) {
                py = 0;
                while (py <= maxY) {
                    int[] g = new int[8];
                    int i = 0;
                    while (i < 8) {
                        int c = this.fullImg.pixels[this.fullImg.width * (py + i) + px];
                        g[i] = (c & 0xFF00) >> 8;
                        ++i;
                    }
                    if (g[0] < 40 && g[1] > 200 && g[2] < 40 && g[3] > 200 && g[4] < 40 && g[5] > 200 && g[6] > 200 && g[7] < 40) {
                        this.windowImg = this.fullImg.get(px - 142, py + 8, 960, 640);
                        return true;
                    }
                    ++py;
                }
                ++px;
            }
            return false;
        }

        public boolean searchHpBar() {
            int pos = 0;
            int hp = 0;
            pos = 358;
            while (pos >= 0) {
                int c = this.windowImg.pixels[this.windowImg.width * 32 + 204 + pos];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                if (r > 240 && g < 40 && b < 90) {
                    hp = pos * 100 / 358;
                }
                if (hp > 0) break;
                --pos;
            }
            if (hp > 0) {
                PImage hpImg = this.windowImg.get(48, 10, 600, 116);
                hpImg.filter(12);
                AbilityTimer.this.image(hpImg, 240.0f, 0.0f);
                AbilityTimer.this.strokeWeight(1.0f);
                AbilityTimer.this.stroke(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.line(396 + pos, 22.0f, 396 + pos, 34.0f);
                AbilityTimer.this.line(396.0f, 26.0f, 396.0f, 31.0f);
                AbilityTimer.this.line(753.0f, 26.0f, 753.0f, 31.0f);
                AbilityTimer.this.line(396.0f, 31.0f, 753.0f, 31.0f);
                AbilityTimer.this.line(575.0f, 25.0f, 575.0f, 31.0f);
                AbilityTimer.this.line(503.4f, 25.0f, 503.4f, 31.0f);
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.text(String.valueOf(AbilityTimer.nf((float)hp)) + "%", 754.0f, 22.0f);
            }
            return hp > 0;
        }

        public boolean searchAccessory() {
            PImage numImg;
            int num;
            String[] rarelityStr = new String[]{"R", "SR", "SSR"};
            int[] rarelityMaxLv = new int[]{30, 40, 50};
            boolean found = false;
            PImage acImg = this.windowImg.get(687, 103, 220, 349);
            int level = 0;
            int i = 0;
            while (i < 2) {
                PImage numImg2 = acImg.get(196 + i * 10, 3, 8, 11);
                int num2 = Glbl.ocrImage(numImg2);
                if (num2 < 0) break;
                if (num2 < 10) {
                    level = level * 10 + num2;
                }
                ++i;
            }
            if (level == 0 && (num = Glbl.ocrImage(numImg = acImg.get(201, 3, 8, 11))) >= 0 && num < 10) {
                level = num;
            }
            int nextExp = 0;
            int i2 = 0;
            while (i2 < 4) {
                PImage numImg3 = acImg.get(111 + i2 * 10, 301, 8, 11);
                int num3 = Glbl.ocrImage(numImg3);
                if (num3 < 0) break;
                if (num3 < 10) {
                    nextExp = nextExp * 10 + num3;
                }
                ++i2;
            }
            int rarelity = 0;
            int c = acImg.pixels[acImg.width * 155 + 162];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            rarelity = 0;
            if (217 <= r && r <= 219 && 215 <= g && g <= 217 && 219 <= b && b <= 221) {
                rarelity = 1;
            } else if (243 <= r && r <= 245 && 230 <= g && g <= 232 && 188 <= b && b <= 190) {
                rarelity = 2;
            }
            if (level > 0 && nextExp > 0) {
                acImg.filter(12);
                AbilityTimer.this.image(acImg, 240.0f, 0.0f);
                int expToMax = Glbl.calculateExpToMax(rarelityMaxLv[rarelity], level, nextExp);
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(rarelityStr[rarelity], 470.0f, 30.0f);
                AbilityTimer.this.text("Lv   " + AbilityTimer.nf((float)level), 470.0f, 50.0f);
                AbilityTimer.this.text("NEXT " + AbilityTimer.nf((float)nextExp), 470.0f, 70.0f);
                AbilityTimer.this.text("to Lv" + AbilityTimer.nf((float)rarelityMaxLv[rarelity]) + ": " + AbilityTimer.nf((float)expToMax) + "exp", 470.0f, 110.0f);
            }
            return found;
        }

        public void render() {
            boolean found = this.findKamihimeWindow();
            if (found && !(found = this.searchHpBar())) {
                this.searchAccessory();
            }
        }
    }

    class TimerBar
    extends GuiItem {
        int seconds;
        TimerDisplay td;
        static final int W = 64;
        static final int H = 310;

        TimerBar(int _seconds, int _x, int _y, TimerDisplay _td) {
            super(_x, _y, 64, 310);
            this.seconds = _seconds;
            this.td = _td;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(224);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.triangle(this.x, this.y + 5, this.x, this.y + 310, this.x + 64 - 1, this.y + 310 - 1);
            AbilityTimer.this.fill(240);
            AbilityTimer.this.triangle(this.x, this.y, this.x + 64, this.y, this.x + 64 - 1, this.y + 310 - 1);
            if (this.isOver()) {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.triangle(this.x, this.y, this.x, AbilityTimer.this.mouseY, this.x + AbilityTimer.this.mouseY / 5, AbilityTimer.this.mouseY);
            }
        }

        public int computeSeconds() {
            int pos = AbilityTimer.this.mouseY / 2;
            if (pos >= 50) {
                pos = 50 + (pos - 50) / 4 * 5;
            }
            return pos;
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.td.start(this.computeSeconds());
            }
        }
    }

    class TimerBarLabel
    extends GuiItem {
        TimerBar tb;

        TimerBarLabel(TimerBar _tb) {
            this.tb = _tb;
        }

        @Override
        public void render() {
            if (this.tb.isOver()) {
                String msg = String.valueOf(AbilityTimer.str((int)this.tb.computeSeconds())) + "sec";
                int y = AbilityTimer.this.mouseY;
                if (y < 20) {
                    y = 20;
                }
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.fill(64);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5 + 2, y + 2);
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5, y);
            }
        }
    }

    class TimerDisplay
    extends GuiItem {
        int endTime;
        static final int W = 70;
        static final int H = 30;

        TimerDisplay(int _x, int _y) {
            super(_x, _y, 70, 30);
            this.endTime = 0;
        }

        public void start(int seconds) {
            this.endTime = AbilityTimer.this.millis() + 1000 * seconds;
            Glbl.mode = 1;
        }

        @Override
        public void render() {
            int currentTime = AbilityTimer.this.millis();
            int remainTime = this.endTime - currentTime;
            if (remainTime <= 0) {
                Glbl.mode = 0;
                Glbl.chime.play();
            } else {
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.stroke(128);
                AbilityTimer.this.fill(this.isOver() ? 64 : 0);
                AbilityTimer.this.rect(this.x, this.y, 69.0f, 29.0f);
                String msg = "000.0";
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                int sec = remainTime / 1000;
                int decimal = remainTime / 100 % 10;
                msg = String.valueOf(AbilityTimer.nf((int)sec, (int)3)) + "." + AbilityTimer.str((int)decimal);
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.text(msg, this.x + 5, this.y + 22);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                Glbl.mode = 0;
            }
        }
    }

    class WallClock
    extends GuiItem {
        ZoneId zid;
        int[] gemTimeTable;
        static final int W = 82;
        static final int H = 20;

        WallClock(ZoneId _zid) {
            super(157, 299, 82, 20);
            this.zid = _zid;
            this.gemTimeTable = new int[AbilityTimer.this.dmmGemTimeTable.length];
            float[] tbl = AbilityTimer.this.dmmGemTimeTable;
            if (this.zid.equals(ZoneId.of("America/Los_Angeles"))) {
                tbl = AbilityTimer.this.nutakuGemTimeTable;
            }
            int i = 0;
            while (i < AbilityTimer.this.dmmGemTimeTable.length) {
                this.gemTimeTable[i] = PApplet.parseInt((float)(tbl[i] * 100.0f));
                ++i;
            }
        }

        @Override
        public void render() {
            Instant currentTime = Instant.now();
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int w = zoneTime.getDayOfWeek().getValue();
            int hour = zoneTime.getHour();
            int minute = zoneTime.getMinute();
            boolean isGemTime = false;
            int nowHour = hour * 100 + minute * 100 / 60;
            Glbl.isLastOneMinute = false;
            int i = 0;
            while (i < 3) {
                int gemHour = this.gemTimeTable[(w - 1) * 3 + i];
                if (gemHour <= nowHour && nowHour < gemHour + 50) {
                    isGemTime = true;
                    if (minute != 29 && minute != 59) break;
                    Glbl.isLastOneMinute = true;
                    break;
                }
                ++i;
            }
            if (this.isOver()) {
                zoneTime = currentTime.atZone(ZoneId.systemDefault());
                hour = zoneTime.getHour();
                minute = zoneTime.getMinute();
            }
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.stroke(128);
            if (isGemTime) {
                AbilityTimer.this.fill(255.0f, 255.0f, 0.0f);
            } else {
                AbilityTimer.this.fill(0);
            }
            AbilityTimer.this.rect(this.x, this.y, 81.0f, 19.0f);
            if (isGemTime) {
                AbilityTimer.this.fill(0);
            } else {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
            }
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(12.0f);
            String dow = zoneTime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.US);
            int day = zoneTime.getDayOfMonth();
            String msg = dow;
            if (!Glbl.isLastOneMinute) {
                msg = String.valueOf(msg) + " " + (day < 10 ? " " : "") + AbilityTimer.str((int)day);
                msg = String.valueOf(msg) + " " + AbilityTimer.nf((int)hour, (int)2) + ":" + AbilityTimer.nf((int)minute, (int)2);
                AbilityTimer.this.text(msg, this.x + 4, this.y + 14);
            } else {
                int second = zoneTime.getSecond();
                msg = String.valueOf(msg) + " " + AbilityTimer.nf((int)hour, (int)2) + ":" + AbilityTimer.nf((int)minute, (int)2) + ":" + AbilityTimer.nf((int)second, (int)2);
                AbilityTimer.this.text(msg, this.x + 4, this.y + 14);
            }
            if (this.isOver()) {
                this.putGemQuestTable(currentTime);
            } else {
                AbilityTimer.this.textFont(Glbl.font12);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.textAlign(39);
                AbilityTimer.this.text(this.zid.toString(), this.x - 2, 312.0f);
                AbilityTimer.this.textAlign(37);
            }
        }

        @Override
        public void press() {
        }

        public void putGemQuestTable(Instant currentTime) {
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int m = zoneTime.getMinute();
            if (m % 15 > 0) {
                zoneTime = zoneTime.plusMinutes(15 - m % 15);
            }
            AbilityTimer.this.stroke(128);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.rect(6.0f, 86.0f, 231.0f, 201.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.rect(5.0f, 85.0f, 230.0f, 200.0f);
            int msgY = 100;
            boolean first = true;
            int[] localGemTimeTable = new int[28];
            int i = 0;
            while (i < 28) {
                localGemTimeTable[i] = Integer.MAX_VALUE;
                ++i;
            }
            i = 0;
            while (i < 672) {
                int w = zoneTime.getDayOfWeek().getValue();
                int hour = zoneTime.getHour();
                int minute = zoneTime.getMinute();
                int nowHour = hour * 100 + minute * 100 / 60;
                int j = 0;
                while (j < 3) {
                    int gemHour = this.gemTimeTable[(w - 1) * 3 + j];
                    if (gemHour == nowHour) {
                        Instant t = Instant.from(zoneTime);
                        ZonedDateTime local = t.atZone(ZoneId.systemDefault());
                        int lw = local.getDayOfWeek().getValue();
                        int lh = local.getHour();
                        int lm = local.getMinute();
                        int found = lh * 100 + lm * 100 / 60;
                        if (first) {
                            first = false;
                        }
                        int index = (lw - 1) * 4;
                        int[] part = new int[]{++found, localGemTimeTable[index + 0], localGemTimeTable[index + 1], localGemTimeTable[index + 2], localGemTimeTable[index + 3]};
                        Arrays.sort(part);
                        System.arraycopy(part, 0, localGemTimeTable, index, 4);
                    }
                    ++j;
                }
                zoneTime = zoneTime.plusMinutes(15L);
                ++i;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text("Gem Quest on your Timezone", 10.0f, msgY);
            msgY = (int)((float)msgY + 30.0f);
            int w = 1;
            while (w <= 7) {
                String msg = DayOfWeek.of(w).getDisplayName(TextStyle.SHORT, Locale.US);
                msg = String.valueOf(msg) + " ";
                int i2 = 0;
                while (i2 < 4) {
                    int index = (w - 1) * 4 + i2;
                    int value = localGemTimeTable[index];
                    if (value != Integer.MAX_VALUE) {
                        int lh = value / 100;
                        int lm = value % 100 * 60 / 100;
                        msg = value % 10 == 1 ? String.valueOf(msg) + ">" + AbilityTimer.nf((int)lh, (int)2) + ":" + AbilityTimer.nf((int)lm, (int)2) + "<" : String.valueOf(msg) + " " + AbilityTimer.nf((int)lh, (int)2) + ":" + AbilityTimer.nf((int)lm, (int)2) + " ";
                    }
                    ++i2;
                }
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(msg, 15.0f, msgY);
                msgY += 20;
                ++w;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(ZoneId.systemDefault().toString(), this.x - 55, this.y - 20);
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x - 10, this.y - 15, this.x, this.y - 3);
        }
    }
}

