/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JFrame;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.data.Table;
import processing.data.TableRow;
import processing.sound.SoundFile;

public class AbilityTimer
extends PApplet {
    final String saveFileName = "save.csv";
    final int checklistModeWidth = 240;
    final int checklistModeHeight = 320;
    final int timerModeWidth = 130;
    final int timerModeHeight = 100;
    final int scouterWidth = 960;
    boolean isBackgroundSelected = true;
    boolean isLastOneMinute = false;
    JFrame jframe;
    PFont font12;
    PFont font24;
    SoundFile chime;
    boolean timerMode = false;
    boolean prevTimerMode = true;
    boolean scouterEnabled = false;
    int next_y = 5;
    final float[] dmmGemTimeTable = new float[]{12.0f, 20.0f, -1.0f, 12.5f, 21.0f, -1.0f, -1.0f, 18.0f, 21.0f, -1.0f, 19.0f, 22.0f, -1.0f, 20.0f, 23.0f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};
    final float[] nutakuGemTimeTable = new float[]{12.0f, 19.0f, -1.0f, 12.5f, 19.5f, -1.0f, -1.0f, 18.0f, 22.5f, -1.0f, 19.0f, 23.0f, -1.0f, 19.5f, 23.5f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};
    ArrayList<GuiItem> timerModeItems = new ArrayList();
    ArrayList<GuiItem> checklistModeItems = new ArrayList();
    ArrayList<Mission> missions = new ArrayList();
    long prevEpochSecond = 0L;
    int prevMouseX = 0;
    int prevMouseY = 0;

    public void settings() {
        this.size(240, 320);
    }

    public void setup() {
        this.frameRate(30.0f);
        this.surface.setAlwaysOnTop(true);
        PSurfaceAWT.SmoothCanvas smoothCanvas = (PSurfaceAWT.SmoothCanvas)this.surface.getNative();
        this.jframe = (JFrame)smoothCanvas.getFrame();
        this.jframe.dispose();
        this.jframe.setUndecorated(true);
        this.jframe.setVisible(true);
        this.surface.setResizable(true);
        this.smooth();
        TimerDisplay tmdisp = new TimerDisplay(20, 5);
        this.timerModeItems.add(tmdisp);
        CloseButton cbutton_t = new CloseButton(110, 0);
        this.timerModeItems.add(cbutton_t);
        MinimizeButton mbutton_t = new MinimizeButton(90, 0);
        this.timerModeItems.add(mbutton_t);
        TimerBar tmbar = new TimerBar(180, 5, 5, tmdisp);
        this.checklistModeItems.add(tmbar);
        this.font12 = this.loadFont("mplus-2p-bold-12.vlw");
        this.font24 = this.loadFont("mplus-2m-bold-24.vlw");
        this.chime = new SoundFile((PApplet)this, "chime.mp3");
        Table chkTbl = this.loadTable("save.csv", "header");
        Table itemTbl = this.loadTable("Items.csv", "header");
        ZoneId zoneid = ZoneId.of("America/Los_Angeles");
        int i = 0;
        for (TableRow itemRow : itemTbl.rows()) {
            String name;
            String kind = itemRow.getString("kind");
            if (kind.equals("mission")) {
                TableRow chkRow;
                name = itemRow.getString("name");
                int items = itemRow.getInt("value");
                int value = 0;
                if (chkTbl != null && i < chkTbl.getRowCount() && (chkRow = chkTbl.getRow(i)) != null) {
                    value = chkRow.getInt("value");
                    ++i;
                }
                Mission m = new Mission(name, items, value);
                this.checklistModeItems.add(m);
                this.missions.add(m);
                continue;
            }
            if (!kind.equals("service") || !(name = itemRow.getString("name")).equals("DMM")) continue;
            zoneid = ZoneId.of("Asia/Tokyo");
        }
        WallClock wallc = new WallClock(zoneid);
        this.checklistModeItems.add(wallc);
        this.checklistModeItems.add(new TimerBarLabel(tmbar));
        CloseButton closeb = new CloseButton(220, 0);
        this.checklistModeItems.add(closeb);
        MinimizeButton minib = new MinimizeButton(200, 0);
        this.checklistModeItems.add(minib);
        DrawerButton drawerb = new DrawerButton(220, 120);
        this.checklistModeItems.add(drawerb);
    }

    public void draw() {
        block16: {
            boolean changed;
            block15: {
                this.isBackgroundSelected = true;
                changed = this.prevTimerMode ^ this.timerMode;
                this.prevTimerMode = this.timerMode;
                if (!this.timerMode) break block15;
                this.background(224);
                if (changed) {
                    this.jframe.setOpacity(0.5f);
                    this.surface.setSize(130, 100);
                }
                for (GuiItem item : this.timerModeItems) {
                    item.render();
                }
                break block16;
            }
            boolean mustRedraw = false;
            long currentEpochSecond = Instant.now().getEpochSecond();
            if (this.mousePressed) {
                mustRedraw = true;
            } else if (this.pmouseX != this.mouseX || this.pmouseY != this.mouseY) {
                mustRedraw = true;
            } else if (this.isLastOneMinute && currentEpochSecond != this.prevEpochSecond) {
                mustRedraw = true;
            } else if (this.scouterEnabled) {
                mustRedraw = true;
            } else if (currentEpochSecond / 60L != this.prevEpochSecond / 60L) {
                mustRedraw = true;
            }
            this.prevEpochSecond = currentEpochSecond;
            if (changed) {
                if (this.scouterEnabled) {
                    this.jframe.setOpacity(1.0f);
                } else {
                    this.jframe.setOpacity(0.75f);
                }
                this.surface.setSize(240 + (this.scouterEnabled ? 960 : 0), 320);
                this.prevEpochSecond = 0L;
            }
            if (!mustRedraw) break block16;
            this.background(224);
            for (GuiItem item : this.checklistModeItems) {
                item.render();
            }
        }
    }

    public void mousePressed() {
        this.prevMouseX = this.mouseX;
        this.prevMouseY = this.mouseY;
        if (this.timerMode) {
            for (GuiItem item : this.timerModeItems) {
                item.press();
            }
        } else {
            for (GuiItem item : this.checklistModeItems) {
                item.press();
            }
        }
    }

    public void mouseReleased() {
    }

    public void mouseDragged() {
        if (this.isBackgroundSelected) {
            Point mouse = MouseInfo.getPointerInfo().getLocation();
            this.surface.setLocation(mouse.x - this.prevMouseX, mouse.y - this.prevMouseY - 0);
        }
    }

    public void exit() {
        Table tbl = new Table();
        tbl.addColumn("value");
        for (Mission m : this.missions) {
            TableRow row = tbl.addRow();
            row.setInt("value", m.getValue());
        }
        this.saveTable(tbl, "save.csv");
        super.exit();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"AbilityTimer"};
        if (passedArgs != null) {
            PApplet.main((String[])AbilityTimer.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Checkbox
    extends GuiItem {
        boolean checked;

        Checkbox(int _x, int _y, boolean _checked) {
            super(_x, _y, 20, 20);
            this.checked = _checked;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 224 : 255);
            AbilityTimer.this.rect(this.x, this.y, this.itemWidth - 1, this.itemHeight - 1);
            if (this.checked) {
                AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.line(this.x + 2, this.y + 10, this.x + 10, this.y + 15);
                AbilityTimer.this.line(this.x + 10, this.y + 15, this.x + 17, this.y + 3);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.checked = !this.checked;
            }
        }

        public boolean get() {
            return this.checked;
        }

        public void set() {
            this.checked = true;
        }

        public void reset() {
            this.checked = false;
        }
    }

    class CloseButton
    extends GuiItem {
        CloseButton(int _x, int _y) {
            super(_x, _y, 20, 20);
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 255 : 224);
            AbilityTimer.this.rect(this.x, this.y, this.itemWidth - 1, this.itemHeight - 1);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x + 3, this.y + 3, this.x + 16, this.y + 16);
            AbilityTimer.this.line(this.x + 3, this.y + 16, this.x + 16, this.y + 3);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                AbilityTimer.this.exit();
            }
        }
    }

    class DrawerButton
    extends GuiItem {
        Robot bot;
        Rectangle area;
        PImage img;
        WritableRaster wr;

        DrawerButton(int _x, int _y) {
            super(_x, _y, 20, 40);
        }

        public void displayScouter() {
            BufferedImage bimg = this.bot.createScreenCapture(this.area);
            if (this.img == null) {
                this.img = new PImage((Image)bimg);
                DataBufferInt dbi = new DataBufferInt(this.img.pixels, this.img.pixels.length);
                this.wr = Raster.createWritableRaster(bimg.getSampleModel(), dbi, new Point(0, 0));
                this.img.loadPixels();
            } else {
                bimg.copyData(this.wr);
                this.img.updatePixels();
            }
            int maxX = this.img.width - 1;
            int maxY = this.img.height - 8;
            boolean found = false;
            int px = 0;
            int py = 0;
            px = 0;
            while (px <= maxX) {
                py = 0;
                while (py <= maxY) {
                    int[] c = new int[8];
                    int i = 0;
                    while (i < 8) {
                        c[i] = (this.img.pixels[this.img.width * (py + i) + px] & 0xFF00) >> 8;
                        ++i;
                    }
                    if (c[0] < 40 && c[1] > 200 && c[2] < 40 && c[3] > 200 && c[4] < 40 && c[5] > 200 && c[6] > 200 && c[7] < 40) {
                        found = true;
                    }
                    if (found) break;
                    ++py;
                }
                if (found) break;
                ++px;
            }
            if (found) {
                this.img.copy(px - 142, py + 8, 960, 640, 0, 0, 960, 640);
                int pos = 0;
                int hp = 0;
                pos = 358;
                while (pos >= 0) {
                    int c = (this.img.pixels[this.img.width * 32 + 204 + pos] & 0xFF0000) >> 16;
                    if (c > 240) {
                        hp = pos * 100 / 358;
                    }
                    if (hp > 0) break;
                    --pos;
                }
                this.img.filter(12);
                AbilityTimer.this.image(this.img, 240.0f, 0.0f);
                if (hp > 0) {
                    AbilityTimer.this.strokeWeight(1.0f);
                    AbilityTimer.this.stroke(0.0f, 255.0f, 0.0f);
                    AbilityTimer.this.line(444 + pos, 32.0f, 444 + pos, 44.0f);
                    AbilityTimer.this.line(444.0f, 36.0f, 444.0f, 41.0f);
                    AbilityTimer.this.line(801.0f, 36.0f, 801.0f, 41.0f);
                    AbilityTimer.this.line(444.0f, 41.0f, 801.0f, 41.0f);
                    AbilityTimer.this.line(623.0f, 35.0f, 623.0f, 41.0f);
                    AbilityTimer.this.line(551.4f, 35.0f, 551.4f, 41.0f);
                    AbilityTimer.this.textFont(AbilityTimer.this.font24);
                    AbilityTimer.this.textSize(24.0f);
                    AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                    AbilityTimer.this.text(String.valueOf(AbilityTimer.nf((float)hp)) + "%", 802.0f, 32.0f);
                }
            }
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 64 : 0);
            AbilityTimer.this.rect(this.x, this.y, this.itemWidth - 1, this.itemHeight - 1);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            if (AbilityTimer.this.scouterEnabled) {
                AbilityTimer.this.line(this.x + 16, this.y + 3, this.x + 3, this.y + 19);
                AbilityTimer.this.line(this.x + 3, this.y + 20, this.x + 16, this.y + 36);
                this.displayScouter();
            } else {
                AbilityTimer.this.line(this.x + 3, this.y + 3, this.x + 16, this.y + 19);
                AbilityTimer.this.line(this.x + 16, this.y + 20, this.x + 3, this.y + 36);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                if (!AbilityTimer.this.scouterEnabled) {
                    try {
                        this.bot = new Robot();
                        this.area = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
                        AbilityTimer.this.jframe.setOpacity(1.0f);
                        AbilityTimer.this.scouterEnabled = true;
                    }
                    catch (AWTException aWTException) {}
                } else {
                    AbilityTimer.this.scouterEnabled = false;
                    AbilityTimer.this.jframe.setOpacity(0.75f);
                }
                if (AbilityTimer.this.scouterEnabled) {
                    AbilityTimer.this.surface.setSize(1200, 320);
                } else {
                    AbilityTimer.this.surface.setSize(240, 320);
                }
            }
        }
    }

    class GuiItem {
        int x;
        int y;
        int itemWidth;
        int itemHeight;

        GuiItem(int _x, int _y, int _itemWidth, int _itemHeight) {
            this.x = _x;
            this.y = _y;
            this.itemWidth = _itemWidth;
            this.itemHeight = _itemHeight;
        }

        GuiItem() {
            this(0, 0, 0, 0);
        }

        public void render() {
        }

        public void press() {
        }

        public boolean isOver() {
            int windowX = AbilityTimer.this.jframe.getX();
            int windowY = AbilityTimer.this.jframe.getY();
            int maxX = windowX + (AbilityTimer.this.timerMode ? 130 : 240);
            int maxY = windowY + (AbilityTimer.this.timerMode ? 100 : 320);
            boolean rc = false;
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info != null) {
                Point mouse = info.getLocation();
                if (windowX <= mouse.x && mouse.x < maxX && windowY <= mouse.y && mouse.y < maxY) {
                    int mx = AbilityTimer.this.mouseX;
                    int my = AbilityTimer.this.mouseY;
                    rc = this.x <= mx && mx < this.x + this.itemWidth && this.y <= my && my < this.y + this.itemHeight;
                }
            }
            AbilityTimer.this.isBackgroundSelected = rc ? false : AbilityTimer.this.isBackgroundSelected;
            return rc;
        }
    }

    class MinimizeButton
    extends GuiItem {
        MinimizeButton(int _x, int _y) {
            super(_x, _y, 20, 20);
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 255 : 224);
            AbilityTimer.this.rect(this.x, this.y, this.itemWidth - 1, this.itemHeight - 1);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x + 3, this.y + 12, this.x + 16, this.y + 12);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                AbilityTimer.this.jframe.setExtendedState(AbilityTimer.this.jframe.getExtendedState() | 1);
            }
        }
    }

    class Mission
    extends GuiItem {
        String name;
        Checkbox[] boxes;
        int y;
        final int delta_y = 29;

        Mission(String _name, int _items, int _value) {
            this.name = _name;
            this.boxes = new Checkbox[_items];
            this.y = AbilityTimer.this.next_y;
            AbilityTimer.this.next_y += 29;
            int i = 0;
            while (i < this.boxes.length) {
                this.boxes[i] = new Checkbox(115 + 25 * i, this.y, i < _value);
                ++i;
            }
        }

        @Override
        public void render() {
            boolean isCurrent = false;
            Checkbox[] checkboxArray = this.boxes;
            int n = this.boxes.length;
            int n2 = 0;
            while (n2 < n) {
                Checkbox box = checkboxArray[n2];
                box.render();
                isCurrent = isCurrent ? true : box.isOver();
                ++n2;
            }
            AbilityTimer.this.textFont(AbilityTimer.this.font12);
            AbilityTimer.this.textSize(12.0f);
            if (isCurrent) {
                AbilityTimer.this.fill(128);
                AbilityTimer.this.text(this.name, 5.0f, this.y + 15);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, 4.0f, this.y + 15 - 1);
            } else {
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, 5.0f, this.y + 15);
            }
        }

        @Override
        public void press() {
            int i = 0;
            while (i < this.boxes.length) {
                int j;
                this.boxes[i].press();
                if (this.boxes[i].get()) {
                    j = i - 1;
                    while (j >= 0) {
                        this.boxes[j].set();
                        --j;
                    }
                } else {
                    j = i + 1;
                    while (j < this.boxes.length) {
                        this.boxes[j].reset();
                        ++j;
                    }
                }
                ++i;
            }
        }

        public int getValue() {
            int i = this.boxes.length - 1;
            while (i >= 0) {
                if (this.boxes[i].get()) break;
                --i;
            }
            return i + 1;
        }
    }

    class TimerBar
    extends GuiItem {
        int seconds;
        TimerDisplay td;

        TimerBar(int _seconds, int _x, int _y, TimerDisplay _td) {
            super(_x, _y, 64, 310);
            this.seconds = _seconds;
            this.td = _td;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(224);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.triangle(this.x, this.y + 5, this.x, this.y + this.itemHeight, this.x + this.itemWidth - 1, this.y + this.itemHeight - 1);
            AbilityTimer.this.fill(240);
            AbilityTimer.this.triangle(this.x, this.y, this.x + this.itemWidth, this.y, this.x + this.itemWidth - 1, this.y + this.itemHeight - 1);
            if (this.isOver()) {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.triangle(this.x, this.y, this.x, AbilityTimer.this.mouseY, this.x + AbilityTimer.this.mouseY / 5, AbilityTimer.this.mouseY);
            }
        }

        public int computeSeconds() {
            int pos = AbilityTimer.this.mouseY / 2;
            if (pos >= 50) {
                pos = 50 + (pos - 50) / 4 * 5;
            }
            return pos;
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.td.start(this.computeSeconds());
            }
        }
    }

    class TimerBarLabel
    extends GuiItem {
        TimerBar tb;

        TimerBarLabel(TimerBar _tb) {
            this.tb = _tb;
        }

        @Override
        public void render() {
            if (this.tb.isOver()) {
                String msg = String.valueOf(AbilityTimer.str((int)this.tb.computeSeconds())) + "sec";
                int y = AbilityTimer.this.mouseY;
                if (y < 20) {
                    y = 20;
                }
                AbilityTimer.this.textFont(AbilityTimer.this.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.fill(64);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5 + 2, y + 2);
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5, y);
            }
        }
    }

    class TimerDisplay
    extends GuiItem {
        int endTime;

        TimerDisplay(int _x, int _y) {
            super(_x, _y, 70, 30);
            this.endTime = 0;
        }

        public void start(int seconds) {
            this.endTime = AbilityTimer.this.millis() + 1000 * seconds;
            AbilityTimer.this.timerMode = true;
        }

        @Override
        public void render() {
            int currentTime = AbilityTimer.this.millis();
            int remainTime = this.endTime - currentTime;
            if (remainTime <= 0) {
                AbilityTimer.this.timerMode = false;
                AbilityTimer.this.chime.play();
            } else {
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.stroke(128);
                AbilityTimer.this.fill(this.isOver() ? 64 : 0);
                AbilityTimer.this.rect(this.x, this.y, this.itemWidth - 1, this.itemHeight - 1);
                String msg = "000.0";
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                int sec = remainTime / 1000;
                int decimal = remainTime / 100 % 10;
                msg = String.valueOf(AbilityTimer.nf((int)sec, (int)3)) + "." + AbilityTimer.str((int)decimal);
                AbilityTimer.this.textFont(AbilityTimer.this.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.text(msg, this.x + 5, this.y + 22);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                AbilityTimer.this.timerMode = false;
            }
        }
    }

    class WallClock
    extends GuiItem {
        ZoneId zid;
        int[] gemTimeTable;

        WallClock(ZoneId _zid) {
            super(157, 299, 82, 20);
            this.zid = _zid;
            this.gemTimeTable = new int[AbilityTimer.this.dmmGemTimeTable.length];
            float[] tbl = AbilityTimer.this.dmmGemTimeTable;
            if (this.zid.equals(ZoneId.of("America/Los_Angeles"))) {
                tbl = AbilityTimer.this.nutakuGemTimeTable;
            }
            int i = 0;
            while (i < AbilityTimer.this.dmmGemTimeTable.length) {
                this.gemTimeTable[i] = PApplet.parseInt((float)(tbl[i] * 100.0f));
                ++i;
            }
        }

        @Override
        public void render() {
            Instant currentTime = Instant.now();
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int w = zoneTime.getDayOfWeek().getValue();
            int hour = zoneTime.getHour();
            int minute = zoneTime.getMinute();
            boolean isGemTime = false;
            int nowHour = hour * 100 + minute * 100 / 60;
            AbilityTimer.this.isLastOneMinute = false;
            int i = 0;
            while (i < 3) {
                int gemHour = this.gemTimeTable[(w - 1) * 3 + i];
                if (gemHour <= nowHour && nowHour < gemHour + 50) {
                    isGemTime = true;
                    if (minute != 29 && minute != 59) break;
                    AbilityTimer.this.isLastOneMinute = true;
                    break;
                }
                ++i;
            }
            if (this.isOver()) {
                zoneTime = currentTime.atZone(ZoneId.systemDefault());
                hour = zoneTime.getHour();
                minute = zoneTime.getMinute();
            }
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.stroke(128);
            if (isGemTime) {
                AbilityTimer.this.fill(255.0f, 255.0f, 0.0f);
            } else {
                AbilityTimer.this.fill(0);
            }
            AbilityTimer.this.rect(this.x, this.y, this.itemWidth - 1, this.itemHeight - 1);
            if (isGemTime) {
                AbilityTimer.this.fill(0);
            } else {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
            }
            AbilityTimer.this.textFont(AbilityTimer.this.font24);
            AbilityTimer.this.textSize(12.0f);
            String dow = zoneTime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.US);
            int day = zoneTime.getDayOfMonth();
            String msg = dow;
            if (!AbilityTimer.this.isLastOneMinute) {
                msg = String.valueOf(msg) + " " + (day < 10 ? " " : "") + AbilityTimer.str((int)day);
                msg = String.valueOf(msg) + " " + AbilityTimer.nf((int)hour, (int)2) + ":" + AbilityTimer.nf((int)minute, (int)2);
                AbilityTimer.this.text(msg, this.x + 4, this.y + 14);
            } else {
                int second = zoneTime.getSecond();
                msg = String.valueOf(msg) + " " + AbilityTimer.nf((int)hour, (int)2) + ":" + AbilityTimer.nf((int)minute, (int)2) + ":" + AbilityTimer.nf((int)second, (int)2);
                AbilityTimer.this.text(msg, this.x + 4, this.y + 14);
            }
            if (this.isOver()) {
                this.putGemQuestTable(currentTime);
            } else {
                AbilityTimer.this.textFont(AbilityTimer.this.font12);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.textAlign(39);
                AbilityTimer.this.text(this.zid.toString(), this.x - 2, 312.0f);
                AbilityTimer.this.textAlign(37);
            }
        }

        @Override
        public void press() {
        }

        public void putGemQuestTable(Instant currentTime) {
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int m = zoneTime.getMinute();
            if (m % 15 > 0) {
                zoneTime = zoneTime.plusMinutes(15 - m % 15);
            }
            AbilityTimer.this.stroke(128);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.rect(6.0f, 86.0f, 231.0f, 201.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.rect(5.0f, 85.0f, 230.0f, 200.0f);
            int msgY = 100;
            boolean first = true;
            int[] localGemTimeTable = new int[28];
            int i = 0;
            while (i < 28) {
                localGemTimeTable[i] = Integer.MAX_VALUE;
                ++i;
            }
            i = 0;
            while (i < 672) {
                int w = zoneTime.getDayOfWeek().getValue();
                int hour = zoneTime.getHour();
                int minute = zoneTime.getMinute();
                int nowHour = hour * 100 + minute * 100 / 60;
                int j = 0;
                while (j < 3) {
                    int gemHour = this.gemTimeTable[(w - 1) * 3 + j];
                    if (gemHour == nowHour) {
                        Instant t = Instant.from(zoneTime);
                        ZonedDateTime local = t.atZone(ZoneId.systemDefault());
                        int lw = local.getDayOfWeek().getValue();
                        int lh = local.getHour();
                        int lm = local.getMinute();
                        int found = lh * 100 + lm * 100 / 60;
                        if (first) {
                            first = false;
                        }
                        int index = (lw - 1) * 4;
                        int[] part = new int[]{++found, localGemTimeTable[index + 0], localGemTimeTable[index + 1], localGemTimeTable[index + 2], localGemTimeTable[index + 3]};
                        Arrays.sort(part);
                        System.arraycopy(part, 0, localGemTimeTable, index, 4);
                    }
                    ++j;
                }
                zoneTime = zoneTime.plusMinutes(15L);
                ++i;
            }
            AbilityTimer.this.textFont(AbilityTimer.this.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text("Gem Quest on your Timezone", 10.0f, msgY);
            msgY = (int)((float)msgY + 30.0f);
            int w = 1;
            while (w <= 7) {
                String msg = DayOfWeek.of(w).getDisplayName(TextStyle.SHORT, Locale.US);
                msg = String.valueOf(msg) + " ";
                int i2 = 0;
                while (i2 < 4) {
                    int index = (w - 1) * 4 + i2;
                    int value = localGemTimeTable[index];
                    if (value != Integer.MAX_VALUE) {
                        int lh = value / 100;
                        int lm = value % 100 * 60 / 100;
                        msg = value % 10 == 1 ? String.valueOf(msg) + ">" + AbilityTimer.nf((int)lh, (int)2) + ":" + AbilityTimer.nf((int)lm, (int)2) + "<" : String.valueOf(msg) + " " + AbilityTimer.nf((int)lh, (int)2) + ":" + AbilityTimer.nf((int)lm, (int)2) + " ";
                    }
                    ++i2;
                }
                AbilityTimer.this.textFont(AbilityTimer.this.font24);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(msg, 15.0f, msgY);
                msgY += 20;
                ++w;
            }
            AbilityTimer.this.textFont(AbilityTimer.this.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(ZoneId.systemDefault().toString(), this.x - 55, this.y - 20);
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x - 10, this.y - 15, this.x, this.y - 3);
        }
    }
}

