/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSPRequest;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

public final class OCSP {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int CONNECT_TIMEOUT = OCSP.initializeTimeout();

    private static int initializeTimeout() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.timeout"));
        if (n == null || n < 0) {
            return 15000;
        }
        return n * 1000;
    }

    private OCSP() {
    }

    public static RevocationStatus check(X509Certificate x509Certificate, X509Certificate x509Certificate2, URI uRI, X509Certificate x509Certificate3, Date date) throws IOException, CertPathValidatorException {
        return OCSP.check(x509Certificate, x509Certificate2, uRI, x509Certificate3, date, Collections.emptyList(), "generic");
    }

    public static RevocationStatus check(X509Certificate x509Certificate, X509Certificate x509Certificate2, URI uRI, X509Certificate x509Certificate3, Date date, List<Extension> list, String string) throws IOException, CertPathValidatorException {
        return OCSP.check(x509Certificate, uRI, null, x509Certificate2, x509Certificate3, date, list, string);
    }

    public static RevocationStatus check(X509Certificate x509Certificate, URI uRI, TrustAnchor trustAnchor, X509Certificate x509Certificate2, X509Certificate x509Certificate3, Date date, List<Extension> list, String string) throws IOException, CertPathValidatorException {
        CertId certId;
        Object object;
        try {
            object = X509CertImpl.toImpl(x509Certificate);
            certId = new CertId(x509Certificate2, ((X509CertImpl)object).getSerialNumberObject());
        }
        catch (IOException | CertificateException exception) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", exception);
        }
        object = OCSP.check(Collections.singletonList(certId), uRI, new OCSPResponse.IssuerInfo(trustAnchor, x509Certificate2), x509Certificate3, date, list, string);
        return ((OCSPResponse)object).getSingleResponse(certId);
    }

    static OCSPResponse check(List<CertId> list, URI uRI, OCSPResponse.IssuerInfo issuerInfo, X509Certificate x509Certificate, Date date, List<Extension> list2, String string) throws IOException, CertPathValidatorException {
        byte[] byArray = null;
        for (Extension object2 : list2) {
            if (!object2.getId().equals(PKIXExtensions.OCSPNonce_Id.toString())) continue;
            byArray = object2.getValue();
        }
        Object object = null;
        try {
            byte[] iOException = OCSP.getOCSPBytes(list, uRI, list2);
            object = new OCSPResponse(iOException);
            ((OCSPResponse)object).verify(list, issuerInfo, x509Certificate, date, byArray, string);
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Unable to determine revocation status due to network error", iOException, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getOCSPBytes(List<CertId> list, URI uRI, List<Extension> list2) throws IOException {
        OCSPRequest oCSPRequest = new OCSPRequest(list, list2);
        byte[] byArray = oCSPRequest.encodeBytes();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        byte[] byArray2 = null;
        try {
            int n;
            URL uRL = uRI.toURL();
            if (debug != null) {
                debug.println("connecting to OCSP service at: " + uRL);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(CONNECT_TIMEOUT);
            httpURLConnection.setReadTimeout(CONNECT_TIMEOUT);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "application/ocsp-request");
            httpURLConnection.setRequestProperty("Content-length", String.valueOf(byArray.length));
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            if (debug != null && httpURLConnection.getResponseCode() != 200) {
                debug.println("Received HTTP error: " + httpURLConnection.getResponseCode() + " - " + httpURLConnection.getResponseMessage());
            }
            inputStream = httpURLConnection.getInputStream();
            int n2 = httpURLConnection.getContentLength();
            if (n2 == -1) {
                n2 = Integer.MAX_VALUE;
            }
            byArray2 = new byte[n2 > 2048 ? 2048 : n2];
            int n3 = 0;
            while (n3 < n2 && (n = inputStream.read(byArray2, n3, byArray2.length - n3)) >= 0) {
                if ((n3 += n) < byArray2.length || n3 >= n2) continue;
                byArray2 = Arrays.copyOf(byArray2, n3 * 2);
            }
            byArray2 = Arrays.copyOf(byArray2, n3);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return byArray2;
    }

    public static URI getResponderURI(X509Certificate x509Certificate) {
        try {
            return OCSP.getResponderURI(X509CertImpl.toImpl(x509Certificate));
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    static URI getResponderURI(X509CertImpl x509CertImpl) {
        AuthorityInfoAccessExtension authorityInfoAccessExtension = x509CertImpl.getAuthorityInfoAccessExtension();
        if (authorityInfoAccessExtension == null) {
            return null;
        }
        List<AccessDescription> list = authorityInfoAccessExtension.getAccessDescriptions();
        for (AccessDescription accessDescription : list) {
            GeneralName generalName;
            if (!accessDescription.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = accessDescription.getAccessLocation()).getType() != 6) continue;
            URIName uRIName = (URIName)generalName.getName();
            return uRIName.getURI();
        }
        return null;
    }

    public static interface RevocationStatus {
        public CertStatus getCertStatus();

        public Date getRevocationTime();

        public CRLReason getRevocationReason();

        public Map<String, Extension> getSingleExtensions();

        public static enum CertStatus {
            GOOD,
            REVOKED,
            UNKNOWN;

        }
    }
}

