/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import processing.core.PApplet;
import processing.sound.JSynAndroidAudioDeviceManager;

class Engine {
    private static AudioDeviceManager audioManager;
    private static Engine singleton;
    protected Synthesizer synth;
    private LineOut lineOut;
    private Multiply leftOut;
    private Multiply rightOut;
    private int sampleRate = 44100;
    private int inputDevice;
    private int outputDevice;

    protected static Engine getEngine(PApplet pApplet) {
        if (singleton == null) {
            singleton = new Engine(pApplet);
        }
        return singleton;
    }

    protected static Engine getEngine() {
        return singleton;
    }

    private Engine(PApplet pApplet) {
        int n;
        if (singleton != null) {
            return;
        }
        this.synth = JSyn.createSynthesizer((AudioDeviceManager)Engine.getAudioManager());
        for (n = 0; n < Engine.getAudioManager().getDeviceCount(); ++n) {
            if (Engine.checkDeviceHasOutputs(n)) {
                this.outputDevice = n;
                break;
            }
            if (n != Engine.getAudioManager().getDeviceCount()) continue;
            Engine.printError("library initalization failed: could not find any audio devices with a stereo output");
            return;
        }
        for (n = 0; n < Engine.getAudioManager().getDeviceCount(); ++n) {
            if (Engine.checkDeviceHasInputs(n)) {
                this.inputDevice = n;
                break;
            }
            if (n != Engine.getAudioManager().getDeviceCount()) continue;
            Engine.printWarning("could not find any sound devices with input channels, you won't be able to use the AudioIn class");
        }
        this.lineOut = new LineOut();
        this.synth.add((UnitGenerator)this.lineOut);
        this.lineOut.start();
        this.leftOut = new Multiply();
        this.rightOut = new Multiply();
        this.setVolume(1.0);
        this.leftOut.output.connect(0, this.lineOut.input, 0);
        this.rightOut.output.connect(0, this.lineOut.input, 1);
        this.synth.add((UnitGenerator)this.leftOut);
        this.synth.add((UnitGenerator)this.rightOut);
        this.startSynth();
        singleton = this;
        Callback callback = new Callback();
        pApplet.registerMethod("dispose", (Object)callback);
        pApplet.registerMethod("pause", (Object)callback);
        pApplet.registerMethod("resume", (Object)callback);
    }

    protected void startSynth() {
        if (this.synth.isRunning()) {
            this.synth.stop();
        }
        this.synth.start(this.sampleRate, this.inputDevice, Engine.getAudioManager().getMaxInputChannels(this.inputDevice), this.outputDevice, Engine.getAudioManager().getMaxOutputChannels(this.outputDevice));
    }

    protected static AudioDeviceManager getAudioManager() {
        if (audioManager == null) {
            try {
                Class.forName("javax.sound.sampled.AudioSystem");
                audioManager = AudioDeviceFactory.createAudioDeviceManager();
            }
            catch (ClassNotFoundException classNotFoundException) {
                audioManager = new JSynAndroidAudioDeviceManager();
            }
        }
        return audioManager;
    }

    protected void setSampleRate(int n) {
        Engine.singleton.sampleRate = n;
        singleton.startSynth();
    }

    private static boolean checkDeviceHasInputs(int n) {
        return Engine.getAudioManager().getMaxInputChannels(n) > 0;
    }

    private static boolean checkDeviceHasOutputs(int n) {
        return Engine.getAudioManager().getMaxOutputChannels(n) > 1;
    }

    protected void selectInputDevice(int n) {
        if (Engine.checkDeviceHasInputs(n)) {
            Engine.singleton.inputDevice = n;
            singleton.startSynth();
        } else {
            Engine.printError("audio device #" + n + " has no input channels");
        }
    }

    protected void selectOutputDevice(int n) {
        if (Engine.checkDeviceHasOutputs(n)) {
            Engine.singleton.outputDevice = n;
            singleton.startSynth();
        } else {
            Engine.printError("audio device #" + n + " has no stereo output channel");
        }
    }

    protected void setVolume(double d) {
        if (Engine.checkRange(d, "volume")) {
            this.leftOut.inputB.set(d);
            this.rightOut.inputB.set(d);
        }
    }

    protected int getSampleRate() {
        return this.synth.getFrameRate();
    }

    protected void add(UnitGenerator unitGenerator) {
        if (unitGenerator.getSynthesisEngine() == null) {
            this.synth.add(unitGenerator);
        }
    }

    protected void remove(UnitGenerator unitGenerator) {
        this.synth.remove(unitGenerator);
    }

    protected void play(UnitSource unitSource) {
        unitSource.getOutput().connect(0, this.leftOut.inputA, 0);
        unitSource.getOutput().connect(1, this.rightOut.inputA, 0);
    }

    protected void stop(UnitSource unitSource) {
        unitSource.getOutput().disconnect(0, this.leftOut.inputA, 0);
        unitSource.getOutput().disconnect(1, this.rightOut.inputA, 0);
    }

    protected static boolean checkAmp(float f) {
        if (f < -1.0f || f > 1.0f) {
            Engine.printError("amplitude has to be in [-1,1]");
            return false;
        }
        if ((double)f == 0.0) {
            Engine.printWarning("an amplitude of 0 means this sound is not audible now");
        }
        return true;
    }

    protected static boolean checkPan(float f) {
        if (f < -1.0f || f > 1.0f) {
            Engine.printError("pan has to be in [-1,1]");
            return false;
        }
        return true;
    }

    protected static boolean checkRange(double d, String string) {
        if (d < 0.0 || d > 1.0) {
            Engine.printError(string + " parameter has to be between 0 and 1 (inclusive)");
            return false;
        }
        return true;
    }

    protected static void printWarning(String string) {
        PApplet.println((String)("Sound library warning: " + string));
    }

    protected static void printError(String string) {
        PApplet.println((String)("Sound library error: " + string));
    }

    public class Callback {
        public void dispose() {
            Engine.this.lineOut.stop();
            Engine.this.synth.stop();
        }

        public void pause() {
        }

        public void resume() {
        }
    }
}

