/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.DoubleBoundedRangeModel;

public class ExponentialRangeModel
extends DoubleBoundedRangeModel {
    private static final long serialVersionUID = -142785624892302160L;
    double a = 1.0;
    double b = -1.0;
    double span = 1.0;
    double root = 10.0;

    public ExponentialRangeModel(String string, int n, double d, double d2, double d3) {
        this(string, n, d, d2, d3, 1.0);
    }

    ExponentialRangeModel(String string, int n, double d, double d2, double d3, double d4) {
        super(string, n, d, d2, d3);
        this.setRoot(10.0);
        this.setSpan(d4);
        this.setDoubleValue(d3);
    }

    private void updateCoefficients() {
        this.a = (this.getDoubleMaximum() - this.getDoubleMinimum()) / (Math.pow(this.root, this.span) - 1.0);
        this.b = this.getDoubleMinimum() - this.a;
    }

    private void setRoot(double d) {
        this.root = d;
        this.updateCoefficients();
    }

    public double getRoot() {
        return this.root;
    }

    public void setSpan(double d) {
        this.span = d;
        this.updateCoefficients();
    }

    public double getSpan() {
        return this.span;
    }

    @Override
    public double sliderToDouble(int n) {
        this.updateCoefficients();
        double d = (double)n / (double)this.getMaximum();
        double d2 = this.a * Math.pow(this.root, this.span * d) + this.b;
        return d2;
    }

    @Override
    public int doubleToSlider(double d) {
        this.updateCoefficients();
        double d2 = (d - this.b) / this.a;
        double d3 = Math.log(d2) / (this.span * Math.log(this.root));
        return (int)Math.round(d3 * (double)this.getMaximum());
    }

    public void test(int n) {
        double d = this.sliderToDouble(n);
        int n2 = this.doubleToSlider(d);
        System.out.println(n + " => " + d + " => " + n2);
    }
}

