#!/usr/bin/awk -f 
BEGIN{
WIKINAME="aalaya"
DATAPATH="./aalaya.d"
TMPL["html"]="aalaya.tmpl"
PN="65536"
print "Content-type: text/html\n\n"

initpage();
#print load_sidebar()
} # awk begin terminated.

# -------------- functions ---------------


function initpage(pageid){

   if (ENVIRON["QUERY_STRING"] == "")  {printpage(0); exit 0} 
   if (ENVIRON["QUERY_STRING"] == "p") {recvpage();   exit 0}
   if (ENVIRON["QUERY_STRING"] == "e" ){pushpage();   exit 0}
   else {
# need to validate QUERY_STRING !
      pageid=ENVIRON["QUERY_STRING"]
   if (pageid ~/../ ) {
     exit 0 } else {
      printpage(pageid)
      exit 0
     }
   }
}

function printpage(pageid){
   while ((getline page <  TMPL["html"]) > 0 ){
      pagedata[n++] =  page
   }

   for(x=0;x<=n;x++) {

   gsub(/{PAGE_CONTENT}/,
    load_page(pageid),pagedata[x])
   gsub(/{PAGE_TITLE}/, 
         page_title, pagedata[x])

     print pagedata[x]
   }
   close(TMPL["html"])
}


function load_page(pageid){
 
  while ((getline content < (DATAPATH "/" pageid) ) > 0 )
  {
     contentdata[m++] = content
  }
   
  text = "<h2>" pageid ": " substr(contentdata[0],1) "</h2>\n"

  page_title=WIKINAME "_No." pageid "(" \
           substr(contentdata[0],1) ")"

  for (y=1;y<=m;y++) {
    text = text contentdata[y] "<br>\n"
  }
  return text;
  close(DATAPATH "/" pageid)

}

function pushpage(){
print "<HTML LANG=\"ja\">"
print "<head><title>" page_title "</title></head>"
print "<BODY>"
print "<FORM ACTION=\"aalaya.cgi?p\" METHOD=\"post\">"
print "<INPUT TYPE=\"submit\" NAME=\"b1\"><br>"
print "<TEXTAREA NAME=\"pagetext\" ROWS=\"40\" COLS=\"80\"></TEXTAREA>"
print "</FORM></BODY></HTML>"
}

function recvpage(){
  if ((ENVIRON["REQUEST_METHOD"] == "POST") && ENVIRON["QUERY_STRING"] == "p"){
   getline ptext < "/dev/stdin" 
    print "<HTML LANG=\"ja\">" 
    print "<head>"
    print "<LINK REL=\"stylesheet\" HREF=\"aalaya.css\" TYPE=\"text/css\">"
    print "<title>" "page_title" "</title></head>"
    print "<BODY>" 
   print "<a href=\"aalaya.cgi?255\"> jump to page 255</a> " 
    print "<pre>" 
     print decode(ptext) > (DATAPATH "/255")
     print decode(ptext)
    print "</pre>"           
    print "</BODY></HTML>"
  }
}

function decode(tx){
  split(tx, lines, "&");
  for (t in lines) {
      if (match(lines[t],"pagetext")!=0){
        gsub("pagetext=","",lines[t]);
        gsub(/%0D%0A/,"\n", lines[t]);
        return lines[t];
      }
  }

}
