/****************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Determine if this is a online snapshot build
    var snapshotBuild = false;
    var isSnapshotStr = "false";
    if (['true', 'yes', '1'].indexOf(isSnapshotStr) >= 0)
        snapshotBuild = true;

    if (snapshotBuild) {
        // Add automatic dependency for preview component
        var autoDependency = component.value("AutoDependOn");
        var dependencyStr = "preview.qt.qt6.61.ios";
        if (autoDependency) {
            component.setValue("AutoDependOn", autoDependency+","+dependencyStr)
        }
        else {
            component.setValue("AutoDependOn", dependencyStr)
        }
    }

    var hostDependencyStr = "";
    var hostDependency = component.value("Dependencies");
    if (hostDependency) {
        if (installer.value("os") == "mac") {
            hostDependencyStr = "qt.qt6.611.clang_64"
        }
    component.setValue("Dependencies", hostDependencyStr)
    }
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    var qtPath = "@TargetDir@" + "/6.1.1/ios";
    var qmakeBinary = "";
    var cmakeBinary = "";
    var platform = "";
    var qmakeScript = "";
    var qtCMakeScript = "";
    var targetQtConf = "";
    var targetQtConf_documentation = "Documentation=../../Docs/Qt-6.1.1";
    var targetQtConf_examples = "Examples=../../Examples/Qt-6.1.1";
    var originalQmakePath = "";
    var newQmakePath = "";
    var originalSetCMakePath ="";
    var newSetCMakePath = "";
    var originalQtCMakeStandaloneTestPath = "/Users/qt/work/install/target";
    var newQtCMakeStandaloneTestPath = "";
    var originalHostPrefix = "HostPrefix=../../";
    var newHostPrefix = "";
    var originalHostData = "HostData=target";
    var newHostData = "";
    var qtToolchainCmake = "";
    var qtBuildInternalsExtraCmake = "";
    var originalQtHostPath = "/Users/qt/work/install";
    var newQtHostPath = "";
    var originalQtHostPathCmakeDir = "/Users/qt/work/install/lib/cmake";
    var newQtHostPathCmakeDir = "";
    var originalQtHostTargetPath = "/Users/qt/work/install/target";
    var newQtHostTargetPath = "";

    if (installer.value("os") == "mac") {
        // Host qmake installed via dependencies
        qmakeBinary = "@TargetDir@" + "/6.1.1/clang_64/bin/qmake";
        // CMake is installed under Tools by default for all Qt installations
        cmakeBinary = "@TargetDir@" + "/Tools/CMake/bin/cmake";
        platform = "mac";

        qmakeScript = qtPath + "/bin/qmake";
        qtCMakeScript = qtPath + "/bin/qt-cmake";
        qtCMakePrivateScript = qtPath + "/bin/qt-cmake-private";
        qtCMakeStandaloneTestScript = qtPath + "/bin/qt-cmake-standalone-test";
        targetQtConf = qtPath + "/bin/target_qt.conf";
        qtToolchainCmake = qtPath + "/lib/cmake/Qt6/qt.toolchain.cmake";
        qtBuildInternalsExtraCmake = qtPath + "/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake";

        // Initialize variables used for patching host qmake location
        // Host is qmake installed via dependencies
        originalQmakePath = "/Users/qt/work/install/bin/qmake";
        newQmakePath = "@TargetDir@" + "/6.1.1/clang_64/bin/qmake";

        // Initialize variables used for patching CMake to under Tools
        originalSetCMakePath = "/Applications/CMake.app/Contents/bin/cmake";
        newSetCMakePath = cmakeBinary;

        // Initialize variable with path to bin/qt-cmake-private(.bat)
        newQtCMakeStandaloneTestPath = qtPath;

        // Set new patched values for target_qt.confs
        newHostPrefix = "HostPrefix=../../clang_64";
        newHostData = "HostData=../ios";

        // Set new patched values for qt.toolchain.cmake
        // __qt_initial_qt_host_path
        newQtHostPath = "@TargetDir@" + "/6.1.1/clang_64";
        //__qt_initial_qt_host_path_cmake_dir
        newQtHostPathCmakeDir = "@TargetDir@" + "/6.1.1/clang_64/lib/cmake";

        // Set new patched values for QtBuildInternalsExtra.cmake
        newQtHostTargetPath = qtPath;
    }

    // Patch build time paths from target\bin\qmake(.bat) script
    console.log("Patching qmake script: " + qmakeScript);
    console.log("  from originalQmakePath: " + originalQmakePath);
    console.log("  to newQmakePath: " + newQmakePath);
    component.addOperation("Replace", qmakeScript, originalQmakePath, newQmakePath);

    // Patch build time CMake path from qt-cmake(.bat) script
    console.log("Patching CMake path from qt-cmake script: " + qtCMakeScript);
    console.log("  from originalSetCMakePath: " + originalSetCMakePath);
    console.log("  to newSetCMakePath: " + newSetCMakePath);
    component.addOperation("Replace", qtCMakeScript, originalSetCMakePath, newSetCMakePath);

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    console.log("Patching CMake path from qt-cmake-private script: " + qtCMakePrivateScript);
    console.log("  from originalSetCMakePath: " + originalSetCMakePath);
    console.log("  to newSetCMakePath: " + newSetCMakePath);
    component.addOperation("Replace", qtCMakePrivateScript, originalSetCMakePath, newSetCMakePath);

    // Patch build time CMAke paths from qt-cmake-standalone-test(.bat) script
    console.log("Patching path from qt-cmake-standalone-test script: " + qtCMakeStandaloneTestScript);
    console.log("  from originalQtCMakeStandaloneTestPath: " + originalQtCMakeStandaloneTestPath);
    console.log("  to newQtCMakeStandaloneTestPath: " + newQtCMakeStandaloneTestPath);
    component.addOperation("Replace", qtCMakeStandaloneTestScript, originalQtCMakeStandaloneTestPath, newQtCMakeStandaloneTestPath);

    // Patch Host Prefix and Host Data paths from target_qt.conf
    console.log("Patching Host Prefix and Host Data from target_qt.conf: " + targetQtConf);
    console.log("  from originalHostPrefix: " + originalHostPrefix);
    console.log("  to newHostPrefix: " + newHostPrefix);
    console.log("  from originalHostData: " + originalHostData);
    console.log("  to newHostData: " + newHostData);
    component.addOperation("Replace", targetQtConf, originalHostPrefix, newHostPrefix);
    component.addOperation("Replace", targetQtConf , originalHostData, newHostData);

    // Append target_qt.conf with relative paths to documentation and examples
    console.log("Appending " + targetQtConf_documentation + " and " + targetQtConf_examples + " to targetQtConf" + targetQtConf);
    component.addOperation("AppendFile", targetQtConf, targetQtConf_documentation);
    component.addOperation("AppendFile", targetQtConf, "\n");
    component.addOperation("AppendFile", targetQtConf, targetQtConf_examples);

    // Patch Qt install path from qt.toolchain.cmake
    console.log("Patching install path from qt.toolchain.cmake : " + qtToolchainCmake);
    console.log("set __qt_initial_qt_host_path");
    console.log("  from originalQtHostPath: " + originalQtHostPath);
    console.log("  to newQtHostPath: " + newQtHostPath);
    component.addOperation("Replace", qtToolchainCmake, originalQtHostPath, newQtHostPath);
    console.log("set __qt_initial_qt_host_path_cmake_dir");
    console.log("  from originalQtHostPathCmakeDir: " + originalQtHostPathCmakeDir);
    console.log("  to newQtHostPathCmakeDir: " + newQtHostPathCmakeDir);
    component.addOperation("Replace", qtToolchainCmake, originalQtHostPathCmakeDir, newQtHostPathCmakeDir);

    // Patch Qt install path from QtBuildInternalsExtra.cmake
    console.log("Patching install path from QtBuildInternalsExtra.cmake : " + qtBuildInternalsExtraCmake);
    console.log("  from originalQtHostTargetPath: " + originalQtHostTargetPath);
    console.log("  to newQtHostTargetPath: " + newQtHostTargetPath);
    component.addOperation("Replace", qtBuildInternalsExtraCmake, originalQtHostTargetPath, newQtHostTargetPath);

    addInitQtPatchOperation(component, platform, qtPath, qmakeScript, "emb-arm-qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} for iOS",
                            "--type", "Qt4ProjectManager.QtVersion.Ios",
                            "--qmake", qmakeScript,
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    // patch/register docs and examples
    var installationPath = installer.value("TargetDir") + "/6.1.1/ios";
    print("Register documentation and examples for: " + installationPath);
    patchQtExamplesAndDoc(component, installationPath, "Qt-6.1.1");

    // is this OpenSource installation?
        var isOpenSource = "true";
        if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
            // patch qconfig.pri
            var qconfigFile = qtPath + "/mkspecs/qconfig.pri";
            component.addOperation("LineReplace", qconfigFile, "QT_EDITION =", "QT_EDITION = OpenSource");
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck_mac", "QT_LICHECK =");
        }
}

