#include "odbc.h"
#include <odbcinst.h>
#include "resource.h"
#include "connection.h"

HINSTANCE g_hModule;

void TestConnection(HWND hWnd, const TCHAR* szConnectionString);
void ReadFromDialogItems(HWND hdlg, TCHAR** parameters);

BOOL WINAPI
DllMain(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_DETACH:
			return TRUE;
		case DLL_PROCESS_ATTACH:
			g_hModule = hInst;
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		default:
			break;
	}
	return TRUE;
} 

const TCHAR*
GetDSN(const TCHAR* lpszAttributes)
{
	const TCHAR* lpszAttribute = lpszAttributes;

	while(lpszAttribute[0])
	{
		if (0 == _tcsncmp(lpszAttribute, _T("DSN="), STR_SIZEOF("DSN=")))
		{
			lpszAttribute += STR_SIZEOF("DSN=");
			/* check DSN for validity */
			return lpszAttribute;
		}
		lpszAttribute += _tcslen(lpszAttribute) + 1;
	}

	return lpszAttribute;
}

int CALLBACK
TestConnectionDlgProc(HWND hdlg, UINT wMsg, WPARAM wParam, LPARAM lParam)
{
	switch (wMsg)
	{
		case WM_INITDIALOG:
			SetDlgItemText(hdlg, IDC_CONNECTION_STATUS, (TCHAR*) lParam);
			return TRUE;
		case WM_COMMAND:
			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
					EndDialog(hdlg, wParam);
					return TRUE;
			}
	}
	return FALSE;
}


int CALLBACK
ConfigDlgProc(HWND hdlg, UINT wMsg, WPARAM wParam, LPARAM lParam)
{
	int    i;
	DWORD  cmd;
	TCHAR* szConnectionString;
	static TCHAR** parameters;

	SQLSMALLINT nLength;

	switch (wMsg)
	{
		case WM_INITDIALOG:
			parameters = (TCHAR**)lParam;
			/* fill edits with text data */
			for (i=0;i<DS_EDIT_PARAMETERS_NUMBER;i++)
				SetDlgItemText(hdlg, c_stDSParameters[i].unDialogItemID, parameters[i]);
			/* set check boxes' states */
			for (i;i<DS_PARAMETERS_NUMBER;i++)
				if (_T('Y') == *parameters[i])
					CheckDlgButton(hdlg, c_stDSParameters[i].unDialogItemID, BST_CHECKED);

			SetDlgItemText(hdlg, IDE_DSN, parameters[DS_PARAMETERS_NUMBER]);
			return TRUE;
		case WM_COMMAND:
			switch (cmd = GET_WM_COMMAND_ID(wParam, lParam))
			{
				/* save and exit */
				case IDOK:
					/* read data from dialog items */
					ReadFromDialogItems(hdlg, parameters);
				/* no break! */
				case IDCANCEL:
					EndDialog(hdlg, wParam);
					return TRUE;
				/* check connection by sending en Empty Query String */
				case IDC_TEST:
					/* read data from dialog items */
					ReadFromDialogItems(hdlg, parameters);
					/* prepare Connection String */
					PrepareConnectionString(NULL, 0, &nLength, parameters, NULL);
					nLength = (nLength+1)*sizeof(TCHAR);
					szConnectionString = (TCHAR*)malloc(nLength);
					PrepareConnectionString(szConnectionString, nLength, &nLength, parameters, NULL);
					TestConnection(hdlg, szConnectionString);
					free(szConnectionString);
					return TRUE;
			}
	}
	return FALSE;
}

BOOL CALLBACK
ConfigDSN_ (HWND hwndParent, WORD fRequest, LPCTSTR lpszDriver, LPCTSTR lpszAttributes)
{
	BOOL    fResult = FALSE;
	LPCTSTR lpDSN;
	TCHAR*  pBuffer;
	int     i;

	TCHAR* parameters[DS_PARAMETERS_NUMBER+1];
	TCHAR  parameters_buffer[DS_PARAMETERS_BUFFER_SIZE+DSN_MAX_LENGTH+1];

	switch (fRequest)
	{
		case ODBC_REMOVE_DSN:
			if (lpDSN = GetDSN(lpszAttributes)) fResult = SQLRemoveDSNFromIni(lpDSN);
			break;
		case ODBC_ADD_DSN:
		case ODBC_CONFIG_DSN:
			memset(parameters_buffer, 0, sizeof(parameters_buffer));
			pBuffer = parameters_buffer;
			for (i=0;i<DS_PARAMETERS_NUMBER;i++)
			{
				parameters[i] = pBuffer;
				pBuffer += c_stDSParameters[i].unMaxValueLength + 1;
			}
			parameters[DS_PARAMETERS_NUMBER] = pBuffer;
			_tcsncpy(parameters[DS_PARAMETERS_NUMBER], GetDSN(lpszAttributes), DSN_MAX_LENGTH);
			if(_T('\0') == parameters[DS_PARAMETERS_NUMBER][0])
				_tcscpy(parameters[DS_PARAMETERS_NUMBER], c_szDriverName);
			ReadFromDS(parameters, (SQLTCHAR*)parameters[DS_PARAMETERS_NUMBER], SQL_NTS);

			if (hwndParent && (IDOK != DialogBoxParam(g_hModule, MAKEINTRESOURCE(DLG_CONFIG), hwndParent, (DLGPROC)ConfigDlgProc, (LPARAM) parameters)))
				return TRUE;

			fResult = SQLWriteDSNToIni(parameters[DS_PARAMETERS_NUMBER], c_szDriverName);
			WriteToDS(parameters, parameters[DS_PARAMETERS_NUMBER]);
	}

	return fResult;
}

/*-----------------------------------------------------------------------------
 * TestConnection
 *-----------------------------------------------------------------------------
 */
void TestConnection(HWND hWnd, const TCHAR* ConnectionString)
{
	const TCHAR* szConnectionStatus;

  SQLHENV  henv  = NULL;
  SQLHDBC  hdbc  = NULL;
  SQLHSTMT hstmt = NULL;

	if (SQL_ERROR != SQLAllocHandle(SQL_HANDLE_ENV,  NULL, &henv) &&
	    SQL_ERROR != SQLSetEnvAttr(henv, SQL_ATTR_ODBC_VERSION, (void*)SQL_OV_ODBC3, SQL_IS_INTEGER) &&
	    SQL_ERROR != SQLAllocHandle(SQL_HANDLE_DBC,  henv, &hdbc)
	   )
	{
		if (SQL_ERROR != SQLDriverConnect(hdbc, hWnd, (SQLTCHAR*)ConnectionString, SQL_NTS, NULL, 0, NULL, SQL_DRIVER_NOPROMPT) &&
		    SQL_ERROR != SQLDisconnect(hdbc)
		   )
			szConnectionStatus = _T("succeeded.");
		else
			szConnectionStatus = _T("failed.");
	}
	else
	{
		/* can't allocate statement */

	}

	DialogBoxParam(g_hModule, MAKEINTRESOURCE(DLG_TEST_RESULTS), hWnd, TestConnectionDlgProc, (WPARAM)szConnectionStatus);

	if (NULL != hstmt) SQLFreeHandle(SQL_HANDLE_STMT, hstmt);
	if (NULL != hdbc)  SQLFreeHandle(SQL_HANDLE_DBC,  hdbc);
	if (NULL != henv)  SQLFreeHandle(SQL_HANDLE_ENV,  henv);
}

/*-----------------------------------------------------------------------------
 * ReadFromDialogItems
 *-----------------------------------------------------------------------------
 */
void ReadFromDialogItems(HWND hdlg, TCHAR** parameters)
{
	unsigned int i;

	/* read all text data in edit items */
	for (i=0;i<DS_EDIT_PARAMETERS_NUMBER;i++)
		GetDlgItemText(hdlg, c_stDSParameters[i].unDialogItemID, parameters[i], c_stDSParameters[i].unMaxValueLength);
	/* read check boxes' states */
	for (;i<DS_PARAMETERS_NUMBER;i++)
		*parameters[i] = (BST_CHECKED == IsDlgButtonChecked(hdlg, c_stDSParameters[i].unDialogItemID)) ? _T('Y') : _T('N');

	GetDlgItemText(hdlg, IDE_DSN, parameters[DS_PARAMETERS_NUMBER], DSN_MAX_LENGTH);
}
