$NetBSD: patch-vroot.h,v 1.1 2025/02/13 21:09:02 vins Exp $

Fix signedness mismatch warning.

--- vroot.h.orig	2014-07-02 05:48:38.000000000 +0000
+++ vroot.h
@@ -45,7 +45,7 @@ VirtualRootWindowOfScreen( Screen* scree
 	if (screen != save_screen) {
 		Display *dpy = DisplayOfScreen(screen);
 		Atom __SWM_VROOT = None;
-		int i;
+		unsigned int i;
 		Window rootReturn, parentReturn, *children;
 		unsigned int numChildren;
 
@@ -59,14 +59,16 @@ VirtualRootWindowOfScreen( Screen* scree
 				Atom actual_type;
 				int actual_format;
 				unsigned long nitems, bytesafter;
-				Window *newRoot = (Window *)0;
+				Window *newRoot;
+				unsigned char *newRootTmp = NULL;
 
 				if (XGetWindowProperty(dpy, children[i],
 					__SWM_VROOT, 0, 1, False, XA_WINDOW,
 					&actual_type, &actual_format,
 					&nitems, &bytesafter,
-					(unsigned char **) &newRoot) == Success
-				    && newRoot) {
+					&newRootTmp) == Success
+				    && newRootTmp) {
+				    newRoot = (Window *) newRootTmp;
 				    root = *newRoot;
 				    break;
 				}
