#ifndef _mpc_streaminfo_h_
#define _mpc_streaminfo_h_

#include "config_types.h"

#ifndef _mpc_dec_h_
class MPC_reader;
#endif


// error codes
#define ERROR_CODE_OK            0
#define ERROR_CODE_FILE         -1
#define ERROR_CODE_SV7BETA       1
#define ERROR_CODE_CBR           2
#define ERROR_CODE_IS            3
#define ERROR_CODE_BLOCKSIZE     4
#define ERROR_CODE_INVALIDSV     5


class StreamInfo {
public:
  typedef mpc_int32_t off_t;

  typedef struct {
    mpc_uint32_t        SampleFreq;
    mpc_uint32_t        Channels;
    off_t               HeaderPosition;     // byte position of header
    mpc_uint32_t        StreamVersion;      // Streamversion of current file
    mpc_uint32_t        Bitrate;            // bitrate of current file (bps)
    double              AverageBitrate;     // Average bitrate in bits/sec
    mpc_uint32_t        Frames;             // number of frames contained
    mpc_int64_t           PCMSamples;
    mpc_uint32_t        MaxBand;            // maximum band-index used (0...31)
    mpc_uint32_t        IS;                 // Intensity Stereo (0: off, 1: on)
    mpc_uint32_t        MS;                 // Mid/Side Stereo (0: off, 1: on)
    mpc_uint32_t        BlockSize;          // only needed for SV4...SV6 -> not supported
    mpc_uint32_t        Profile;            // quality profile
    const char*         ProfileName;

    // ReplayGain related data
    mpc_int16_t               GainTitle;
    mpc_int16_t               GainAlbum;
    mpc_uint16_t      PeakAlbum;
    mpc_uint16_t      PeakTitle;

    // true gapless stuff
    mpc_uint32_t        IsTrueGapless;      // is true gapless used?
    mpc_uint32_t        LastFrameSamples;   // number of valid samples within last frame

    mpc_uint32_t        EncoderVersion;     // version of encoder used
    char                Encoder[256];

    off_t TagOffset;
    off_t TotalFileLength;
  } BasicData;

  BasicData           simple;

public:
  StreamInfo ();
  mpc_int32_t ReadStreamInfo ( MPC_reader *fp );
  mpc_int64_t GetLengthSamples();
  double GetLength();//in seconds

private:
  mpc_int32_t ReadHeaderSV6 ( mpc_uint32_t HeaderData [8] );
  mpc_int32_t ReadHeaderSV7 ( mpc_uint32_t HeaderData [8] );
  mpc_int32_t ReadHeaderSV8 ( MPC_reader* fp );
};

#endif //_mpc_streaminfo_h_
