/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.AbstractExportCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.ResultSetExportCsvController;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvController;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ResultSetExportData;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortFactoryCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetExportCommand
extends AbstractExportCommand {
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultSetExportCommand.class);
    static ILogger log = LoggerController.createLogger(ResultSetExportCommand.class);
    private ResultSet resultSet;
    private DialectType dialect;
    private String sql;
    private Statement stmt;
    private ProgressAbortFactoryCallback progressControllerFactory;

    public ResultSetExportCommand(Statement stmt, String sql, DialectType dialect, ProgressAbortFactoryCallback progressControllerFactory) {
        this.sql = sql;
        this.stmt = stmt;
        this.dialect = dialect;
        this.progressControllerFactory = progressControllerFactory;
    }

    @Override
    protected boolean checkMissingData(String sepChar) {
        return false;
    }

    @Override
    protected IExportData createExportData(TableExportCsvController ctrl) throws ExportDataException {
        try {
            super.progress(i18n.EXECUTING_QUERY);
            ResultSetExportCsvController controller = (ResultSetExportCsvController)ctrl;
            if (!controller.exportComplete()) {
                this.stmt.setMaxRows(controller.getMaxRows());
            }
            this.resultSet = this.stmt.executeQuery(this.sql);
            return new ResultSetExportData(this.resultSet, this.dialect);
        }
        catch (SQLException e) {
            log.error(i18n.ERROR_EXECUTE_STATEMENT, e);
            throw new ExportDataException(i18n.ERROR_EXECUTE_STATEMENT, e);
        }
    }

    @Override
    protected TableExportCsvController createTableExportController(final JFrame owner) {
        try {
            final ResultSetExportCsvController[] buf = new ResultSetExportCsvController[1];
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    buf[0] = new ResultSetExportCsvController(owner);
                }
            };
            GUIUtils.processOnSwingEventThread(runnable, true);
            return buf[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ProgressAbortCallback createProgressController() {
        return this.progressControllerFactory.create();
    }

    public String getSql() {
        return this.sql;
    }

    static interface i18n {
        public static final String ERROR_EXECUTE_STATEMENT = s_stringMgr.getString("ResultSetExportCommand.errorExecuteStatement");
        public static final String EXECUTING_QUERY = s_stringMgr.getString("ResultSetExportCommand.executingQuery");
    }
}

