/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.igoweb.go.Loc;
import org.igoweb.go.sgf.FileIo;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.SgfException;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.CommentWidget;
import org.igoweb.go.swing.Editor;
import org.igoweb.go.swing.GameLayout;
import org.igoweb.go.swing.GamePanel;
import org.igoweb.go.swing.GobanPrinter;
import org.igoweb.go.swing.NumberingWindow;
import org.igoweb.go.swing.VarLabelWindow;
import org.igoweb.go.swing.sgf.NodeNameListWin;
import org.igoweb.go.swing.sgf.SelectFile;
import org.igoweb.go.swing.sgf.gameInfo.DisplayWindow;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.JnlpIo;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.SingletonWindow;

public class SgfGamePanel
extends GamePanel {
    private FileIo sgfFile;
    private final SingletonWindow nodeNameListWin = new SingletonWindow();
    private boolean closeAfterSave = false;
    private JButton saveBut;
    private final Editor editor;
    private final JMenuItem cutMI = new JMenuItem(Defs.getString(1096335311));
    private final JMenuItem pasteMI = new JMenuItem(Defs.getString(1096335324));
    private final JMenuItem upMI = new JMenuItem(Defs.getString(1096335337));
    private final JMenuItem downMI = new JMenuItem(Defs.getString(1096335312));
    private Node sgfClipboard = null;
    private final EventListener treeEventListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            Node active = SgfGamePanel.this.getSgfTree().getActiveNode();
            Node activeParent = active.parent;
            SgfGamePanel.this.cutMI.setEnabled(activeParent != null);
            SgfGamePanel.this.upMI.setEnabled(activeParent != null && activeParent.countChildren() > 1 && active != activeParent.getChild(0));
            SgfGamePanel.this.downMI.setEnabled(activeParent != null && activeParent.countChildren() > 1 && active != activeParent.getChild(activeParent.countChildren() - 1));
        }
    };

    public SgfGamePanel(FileIo sgf) {
        this.init(sgf.tree, new GameLayout(this));
        this.sgfFile = sgf;
        this.setGameInfoMenuItems();
        this.setNodeChangeEnabled(true);
        this.saveBut.setEnabled(this.sgfFile.getFile() != null);
        this.cutMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SgfGamePanel.this.getSgfTree().delete(SgfGamePanel.this.sgfClipboard = SgfGamePanel.this.getSgfTree().getActiveNode());
                SgfGamePanel.this.pasteMI.setEnabled(true);
            }
        });
        this.pasteMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SgfGamePanel.this.getSgfTree().insertCopy(SgfGamePanel.this.sgfClipboard);
            }
        });
        this.pasteMI.setEnabled(false);
        this.upMI.addActionListener(new NodeMover(-1));
        this.downMI.addActionListener(new NodeMover(1));
        this.getSgfTree().addListener(this.treeEventListener);
        this.treeEventListener.handleEvent(null);
        this.editor = new Editor(this);
        this.editor.addToolMenu(new JComponent[]{null, this.cutMI, this.pasteMI, null, this.upMI, this.downMI});
        this.editor.addMap();
        this.editor.setTool(0);
    }

    @Override
    public void changeActiveNode(Node node) {
        this.getSgfTree().setActiveNode(node);
    }

    @Override
    public void closePressed() {
        ((CommentWidget)this.getCommentWidget()).updateComments();
        if (this.sgfFile.isModified()) {
            String saveQuit = Defs.getString(1436228521);
            final String justQuit = Defs.getString(1436228522);
            final String noCancel = Defs.getString(720104027);
            new MsgOut(Defs.getString(1096335307), this.sgfFile.getFile() == null ? Defs.getString(1096335335) : Defs.getString(1096335334, this.sgfFile.getFile()), 2, (Component)this, new String[]{saveQuit, justQuit, noCancel}, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String cmd = event.getActionCommand();
                    if (!cmd.equals(noCancel)) {
                        if (cmd.equals(justQuit)) {
                            SgfGamePanel.this.emit(2);
                        } else if (SgfGamePanel.this.sgfFile.getFile() == null) {
                            SgfGamePanel.this.saveAsPressed(true);
                        } else {
                            try {
                                SgfGamePanel.this.sgfFile.save();
                                SgfGamePanel.this.emit(2);
                            }
                            catch (IOException excep) {
                                String message = excep.getMessage();
                                if (message == null) {
                                    message = excep.toString();
                                }
                                new Errout(Defs.getString(1096335306, new Object[]{SgfGamePanel.this.sgfFile.getFile(), message}));
                            }
                        }
                    }
                }
            });
        } else {
            this.emit(2);
        }
    }

    @Override
    protected AFrame buildGameInfoWindow() {
        return new DisplayWindow(this.getSgfTree(), this, true);
    }

    public void savePressed() {
        if (JnlpIo.isAvailable()) {
            this.saveAsPressed(false);
            return;
        }
        try {
            ((CommentWidget)this.getCommentWidget()).updateComments();
            this.sgfFile.save();
        }
        catch (IOException excep) {
            String message = excep.getMessage();
            if (message == null) {
                message = excep.toString();
            }
            new Errout(Defs.getString(1096335306, new Object[]{this.sgfFile.getFile(), message}));
        }
    }

    public void saveAsPressed(boolean closeWanted) {
        File fName;
        ((CommentWidget)this.getCommentWidget()).updateComments();
        this.closeAfterSave = closeWanted;
        if (JnlpIo.isAvailable()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.sgfFile.save(out);
            }
            catch (IOException excep) {
                Logger.getLogger("global").log(Level.WARNING, "SgfGamePanel.saveAsPressed: Error writing to byte array output", excep);
                return;
            }
            JnlpIo.FileAccessResult far = JnlpIo.saveAsFile(this.sgfFile.getFile(), new ByteArrayInputStream(out.toByteArray()));
            if (far != null) {
                if (far.isFileSelected()) {
                    String fileName = far.getFileName();
                    if (fileName != null) {
                        this.sgfFile.setFile(new File(fileName));
                    }
                    if (this.closeAfterSave) {
                        this.emit(2);
                    }
                }
                return;
            }
        }
        if ((fName = SelectFile.getFile((Component)this, Defs.getString(1096335309), this.sgfFile.getFile(), true)) != null) {
            this.saveFileAs(fName);
        }
    }

    public void saveFileAs(File fileOut) {
        if (fileOut != null) {
            try {
                this.sgfFile.save(fileOut);
                this.saveBut.setEnabled(true);
                if (this.closeAfterSave) {
                    this.emit(2);
                }
            }
            catch (IOException excep) {
                this.closeAfterSave = false;
                new Errout(Defs.getString(1096335306, new Object[]{fileOut, excep.toString()}));
            }
        }
        this.closeAfterSave = false;
    }

    @Override
    protected String helpUrl() {
        return "app/editor.html#goban";
    }

    @Override
    protected void buildControlButtonList(ArrayList<JComponent> list) {
        this.saveBut = new JButton(Defs.getString(1096335330));
        this.saveBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SgfGamePanel.this.savePressed();
            }
        });
        JButton saveAsBut = new JButton(Defs.getString(1096335332));
        saveAsBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SgfGamePanel.this.saveAsPressed(false);
            }
        });
        list.add(this.helpBut);
        list.add(this.gameInfoBut);
        list.add(this.getGobanWidget().passBut);
        list.add(this.saveBut);
        list.add(saveAsBut);
        list.add(this.closeBut);
        super.buildControlButtonList(list);
    }

    private void setGameInfoMenuItems() {
        JMenuItem printMI = new JMenuItem(Defs.getString(1096335326));
        printMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setPageable(new GobanPrinter(SgfGamePanel.this.getSgfTree()));
                job.setJobName(SgfGamePanel.this.getTitleText());
                if (job.printDialog()) {
                    try {
                        job.print();
                    }
                    catch (PrinterException excep) {
                        new Errout(Defs.getString(1096335327, new Object[]{excep.toString()}));
                    }
                }
            }
        });
        this.rulesMI.setText(Defs.getString(1096335316));
        JMenuItem nodeListMI = new JMenuItem(Defs.getString(1096335319));
        nodeListMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!SgfGamePanel.this.nodeNameListWin.raiseIfOpen()) {
                    SgfGamePanel.this.nodeNameListWin.setWindow(new NodeNameListWin(SgfGamePanel.this.getSgfTree(), (Component)SgfGamePanel.this));
                }
            }
        });
        JMenuItem mergeMI = new JMenuItem(Defs.getString(1096335339));
        mergeMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SgfGamePanel.this.mergePressed();
            }
        });
        this.setGameInfoMenuItems(new JMenuItem[]{this.rulesMI, this.scoreEstMI, nodeListMI, null, printMI, mergeMI, null, NumberingWindow.createMenuItem(this), VarLabelWindow.createMenuItem(this)});
    }

    @Override
    public void addProp(Node node, Prop param) {
        if (node == null) {
            node = this.getSgfTree().getActiveNode();
        }
        if (!(param.type != 14 && param.type != 17 || param.type != 14 && node.findProp(14) == null)) {
            Node child = this.getSgfTree().addNode(node);
            if (node == this.getSgfTree().getActiveNode()) {
                this.getSgfTree().setActiveNode(child);
            }
            node = child;
        }
        node.add(param);
    }

    @Override
    public void removeProp(Node node, Prop param) {
        node.remove(param);
    }

    @Override
    public void addNode(Node parent, boolean makeActive) {
        Node child = this.getSgfTree().addNode(parent);
        if (makeActive) {
            this.getSgfTree().setActiveNode(child);
        }
    }

    @Override
    protected boolean changeWhoseMove(int newWhoseMove) {
        if (this.getGame().isPlayOver()) {
            return false;
        }
        this.getSgfTree().getActiveNode().removeType(26);
        Prop toAdd = new Prop(26, newWhoseMove);
        if (!this.getSgfTree().getActiveNode().hasConflicts(toAdd)) {
            this.getSgfTree().add(toAdd);
        }
        this.getGame().setWhoseMove(newWhoseMove);
        return true;
    }

    @Override
    protected void changeScoreMarks(boolean tryToRemove) {
        Tree tree = this.getSgfTree();
        Node activeNode = tree.getActiveNode();
        if (tryToRemove) {
            Prop param;
            tryToRemove = false;
            while ((param = tree.getActiveNode().findProp(23)) != null) {
                activeNode.remove(param);
            }
            while ((param = tree.getActiveNode().findProp(22)) != null) {
                activeNode.remove(param);
            }
        } else {
            this.editor.changeLiveness(Loc.PASS, false);
        }
    }

    private void mergePressed() {
        File fName = SelectFile.getFile((Component)this, Defs.getString(1096335339), (String)null, false);
        if (fName == null) {
            return;
        }
        FileIo fio = null;
        String error = null;
        try {
            fio = new FileIo(fName, null);
        }
        catch (IOException excep) {
            error = excep.toString();
        }
        catch (SgfException excep) {
            error = excep.getMessage();
        }
        if (error != null) {
            new Errout(Defs.getString(1096335340, new Object[]{fName, error}), this);
            return;
        }
        int mergeSize = fio.tree.root.findProp(0).getRules().getSize();
        if (mergeSize != this.getGame().size) {
            new Errout(Defs.getString(1096335341, new Object[]{new Integer(this.getGame().size), new Integer(mergeSize)}), this);
            return;
        }
        Tree tree = this.getSgfTree();
        ArrayList<Prop> myRootChanges = SgfGamePanel.getRootChanges(tree);
        ArrayList<Prop> mergeRootChanges = SgfGamePanel.getRootChanges(fio.tree);
        Node parent = tree.root;
        if (!myRootChanges.equals(mergeRootChanges)) {
            parent = tree.addNode(tree.root);
            for (Prop p : myRootChanges) {
                parent.add(new Prop(17, 2, p.getLoc()));
            }
            for (Prop p : mergeRootChanges) {
                if (p.type == 17) {
                    System.err.println("Adding " + p);
                    parent.add(p);
                    continue;
                }
                parent.add(new Prop(17, p.getColor(), p.getLoc()));
            }
        }
        Node oldActiveNode = tree.getActiveNode();
        Iterator<Node> iter = fio.tree.root.children().iterator();
        while (iter.hasNext()) {
            tree.setActiveNode(parent);
            tree.insertCopy(iter.next());
        }
        tree.setActiveNode(oldActiveNode);
    }

    private static ArrayList<Prop> getRootChanges(Tree tree) {
        ArrayList<Prop> result = new ArrayList<Prop>();
        for (Prop p : tree.root) {
            if ((p.type != 17 || p.getColor() == 2) && p.type != 14) continue;
            result.add(p);
        }
        return result;
    }

    protected FileIo getSgfFile() {
        return this.sgfFile;
    }

    protected JButton getSaveButton() {
        return this.saveBut;
    }

    private class NodeMover
    implements ActionListener {
        private final int direction;

        public NodeMover(int direction) {
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SgfGamePanel.this.getSgfTree().getActiveNode().parent.moveActiveChild(this.direction);
        }
    }
}

