/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client;

import java.util.Arrays;
import java.util.Comparator;
import org.igoweb.igoweb.client.CGame;
import org.igoweb.igoweb.client.CGameListEntry;
import org.igoweb.igoweb.shared.GameType;
import org.igoweb.igoweb.shared.Role;

public class CGameComparator
implements Comparator<CGameListEntry> {
    public static final int SORT_BY_OPEN = 0;
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_OBSERVERS = 2;
    public static final int SORT_BY_RANK = 3;
    private int sortType;
    private int[] ranks1 = new int[Role.count()];
    private int[] ranks2 = new int[Role.count()];

    public CGameComparator() {
        this(0);
    }

    public CGameComparator(int newSortType) {
        this.sortType = newSortType;
    }

    public void setSortType(int newType) {
        this.sortType = newType;
    }

    public int getSortType() {
        return this.sortType;
    }

    @Override
    public int compare(CGameListEntry g1, CGameListEntry g2) {
        String n2;
        String n1;
        int diff;
        int mySortType;
        if (g1 == null) {
            return g2 == null ? 0 : -1;
        }
        if (g2 == null) {
            return 1;
        }
        if (g1.isEvent()) {
            if (!g2.isEvent()) {
                return -1;
            }
        } else if (g2.isEvent()) {
            return 1;
        }
        if ((mySortType = this.sortType) == 0) {
            boolean test;
            if (g1.gameType == GameType.CHALLENGE) {
                if (g2.gameType != GameType.CHALLENGE) {
                    return -1;
                }
            } else if (g2.gameType == GameType.CHALLENGE) {
                return 1;
            }
            if ((test = g1.isAdjourned()) != g2.isAdjourned()) {
                return test ? 1 : -1;
            }
            mySortType = 3;
        }
        int obsCmp = (g2.gameType == GameType.CHALLENGE ? 0 : ((CGame)g2).getNumObservers()) - (g1.gameType == GameType.CHALLENGE ? 0 : ((CGame)g1).getNumObservers());
        if (mySortType == 3 || mySortType == 2 && obsCmp == 0) {
            int i;
            for (i = 0; i < this.ranks1.length; ++i) {
                Role role = Role.get(i);
                this.ranks1[i] = g1.gameType.isMainRole(role) ? g1.getPlayer(role).getRankSortValue() : -1;
                this.ranks2[i] = g2.gameType.isMainRole(role) ? g2.getPlayer(role).getRankSortValue() : -1;
            }
            Arrays.sort(this.ranks1);
            Arrays.sort(this.ranks2);
            for (i = this.ranks1.length - 1; i >= 0; --i) {
                if (this.ranks1[i] == this.ranks2[i]) continue;
                return this.ranks2[i] - this.ranks1[i];
            }
        }
        if ((mySortType == 2 || mySortType == 3) && obsCmp != 0) {
            return obsCmp;
        }
        int r1 = 0;
        int r2 = 0;
        do {
            Role role;
            n1 = null;
            n2 = null;
            do {
                if (r1 >= Role.count()) {
                    n1 = "";
                    continue;
                }
                if (!g1.gameType.isRole(role = Role.get(r1++))) continue;
                n1 = g1.getPlayer((Role)role).name;
            } while (n1 == null);
            do {
                if (r2 >= Role.count()) {
                    n2 = "";
                    continue;
                }
                if (!g2.gameType.isRole(role = Role.get(r2++))) continue;
                n2 = g2.getPlayer((Role)role).name;
            } while (n2 == null);
        } while ((diff = n1.compareToIgnoreCase(n2)) == 0 && !n1.isEmpty() && !n2.isEmpty());
        return diff;
    }
}

