/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.jsp.logic;

import java.rmi.Naming;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.igoweb.igoweb.jsp.logic.Invoice;
import org.igoweb.igoweb.jsp.logic.Product;
import org.igoweb.igoweb.jsp.logic.TimeUnit;
import org.igoweb.igoweb.remoteLogger.TransmitHandler;
import org.igoweb.igoweb.shared.PUser;
import org.igoweb.igoweb.shared.Subscription;
import org.igoweb.igoweb.shared.server.ServerControl;
import org.igoweb.util.DatedFileHandler;
import org.igoweb.util.DbConn;
import org.igoweb.util.DbConnFactory;
import org.igoweb.util.LockOrder;
import org.igoweb.util.jsp.AbstractInvoiceManager;
import org.igoweb.util.jsp.InvoiceState;
import org.igoweb.util.jsp.PaymentMethod;

public class InvoiceManager
extends AbstractInvoiceManager<Product, Invoice> {
    public static LockOrder LOCK_ORDER = new LockOrder(InvoiceManager.class);
    private static final TimeZone UTC;

    public InvoiceManager(DbConnFactory masterFactory, Logger logger) {
        super(masterFactory, logger);
    }

    @Override
    protected List<Product> loadProductList(DbConn db) throws SQLException {
        return Product.getAll(db);
    }

    @Override
    protected Invoice createInvoice(ResultSet rs) throws SQLException {
        return new Invoice(rs);
    }

    @Override
    protected boolean setState(DbConn db, Invoice invoice, InvoiceState newState) throws SQLException {
        if (invoice.getState().isFunded() == newState.isFunded()) {
            return true;
        }
        this.getLogger().info("Changing invoice " + invoice.id + " from state " + (Object)((Object)invoice.getState()) + " to state " + (Object)((Object)newState));
        Subscription[] subs = Subscription.load(db, invoice.accountId);
        if (newState.isFunded()) {
            this.addOrExtend(subs, invoice, db);
        } else if (!this.remove(subs, invoice, db)) {
            return false;
        }
        try {
            ServerControl ctrl = (ServerControl)Naming.lookup(ServerControl.RMI_URL);
            ctrl.subscriptionUpdated(invoice.accountId);
        }
        catch (Exception excep) {
            this.getLogger().log(Level.WARNING, "Updated database for invoice " + invoice + ", but was unable to contact server about change.", excep);
        }
        return true;
    }

    private void addOrExtend(Subscription[] subs, Invoice invoice, DbConn db) throws SQLException {
        long now = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance(UTC, Locale.US);
        if (Subscription.isSubscribed(now, subs)) {
            Subscription sub = subs[subs.length - 1];
            invoice.setSubscriptionId(db, sub.getSubscriptionId());
            cal.setTimeInMillis(sub.end);
            InvoiceManager.addGenerously(cal, invoice.getDuration(), invoice.getDurationUnits());
            sub.updateEnd(db, cal.getTimeInMillis());
        } else {
            cal.setTimeInMillis(now);
            InvoiceManager.addGenerously(cal, invoice.getDuration(), invoice.getDurationUnits());
            Subscription sub = new Subscription(now, cal.getTimeInMillis());
            sub.store(db, invoice.accountId);
            invoice.setSubscriptionId(db, sub.getSubscriptionId());
            PUser.setLongLivedInDb(db, invoice.accountId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Subscription[] subs, Invoice invoice, DbConn db) throws SQLException {
        int prevSubId = invoice.getSubscriptionId();
        invoice.setSubscriptionId(db, -1);
        if (subs != null) {
            for (Subscription sub : subs) {
                if (sub.getSubscriptionId() != prevSubId) continue;
                long newEnd = 0L;
                try (ResultSet rs = null;){
                    PreparedStatement ps = db.get("SELECT COUNT(*) FROM invoices  WHERE subscription_id = ?");
                    ps.setInt(1, prevSubId);
                    rs = ps.executeQuery();
                    rs.next();
                    if (rs.getInt(1) > 0) {
                        Calendar cal = Calendar.getInstance(UTC, Locale.US);
                        cal.setTimeInMillis(sub.end);
                        cal.add(invoice.getDurationUnits().calendarUnit, -invoice.getDuration());
                        newEnd = cal.getTimeInMillis();
                    }
                }
                sub.updateEnd(db, newEnd);
                return true;
            }
        }
        this.getLogger().warning("Unable to find subscription ID " + prevSubId + " to remove time for invoice " + invoice);
        return false;
    }

    public boolean transferSubscription(PUser from, PUser to, PUser admin, String notes) {
        if (from.id == to.id) {
            throw new IllegalArgumentException("Can't transfer to yourself.");
        }
        DbConn db = this.factory.getDbConn();
        ResultSet rs = null;
        try {
            PreparedStatement ps = db.get("UPDATE subscriptions SET account_id = ? WHERE account_id = ?");
            ps.setInt(1, to.id);
            ps.setInt(2, from.id);
            if (ps.executeUpdate() == 0) {
                boolean bl = false;
                return bl;
            }
            ps = db.get("INSERT INTO invoices_transfers    (transfer_time, src_account_id, dest_account_id,     admin_account_id, notes)  VALUES    (NOW(), ?, ?, ?, ?)");
            ps.setInt(1, from.id);
            ps.setInt(2, to.id);
            ps.setInt(3, admin.id);
            ps.setString(4, notes);
            ps.executeUpdate();
            PUser.setLongLivedInDb(db, to.id, true);
            try {
                ServerControl control = (ServerControl)Naming.lookup(ServerControl.RMI_URL);
                control.subscriptionUpdated(to.id);
                control.subscriptionUpdated(from.id);
            }
            catch (Exception excep) {
                this.logger.log(Level.WARNING, "Unable to update server after completing subscription transfer.", excep);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException excep) {
            db.error();
            throw new RuntimeException(excep);
        }
        finally {
            db.close(rs);
        }
    }

    public Invoice createInvoice(PUser user, Product product, double cost, PaymentMethod paymentMethod, int duration, TimeUnit durationUnits, String notes) {
        return this.createInvoice(user, product, cost, -1, paymentMethod, duration, durationUnits, notes);
    }

    public Invoice createInvoice(PUser user, Product product, PaymentMethod paymentMethod, String notes) {
        return this.createInvoice(user, product, product.getCost(), -1, paymentMethod, product.getDuration(), product.getDurationUnits(), notes);
    }

    public Invoice createInvoice(PUser user, Product product, double cost, int tournId, PaymentMethod paymentMethod, int duration, TimeUnit durationUnits, String notes) {
        try (DbConn db = this.factory.getDbConn();){
            Invoice invoice = new Invoice(db, this.getNewInvoiceId(), user, product, cost, tournId, paymentMethod, duration, durationUnits, notes);
            this.addInvoice(invoice);
            Invoice invoice2 = invoice;
            return invoice2;
        }
    }

    public static void addGenerously(Calendar cal, int duration, TimeUnit unit) {
        int startDay = cal.get(5);
        cal.add(unit.calendarUnit, duration);
        if (unit == TimeUnit.MONTHS) {
            cal.add(5, startDay - cal.get(5));
        }
    }

    static {
        assert (LOCK_ORDER.addInnerOrder(Invoice.LOCK_ORDER));
        assert (Invoice.LOCK_ORDER.addInnerOrder(DatedFileHandler.LOCK_ORDER));
        assert (Invoice.LOCK_ORDER.addInnerOrder(Subscription.LOCK_ORDER));
        assert (Invoice.LOCK_ORDER.addInnerOrder(TransmitHandler.LOCK_ORDER));
        UTC = TimeZone.getTimeZone("UTC");
    }
}

