/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import java.awt.Component;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.igoweb.go.sgf.FileIo;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.SgfEvent;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.CommentLogViewer;
import org.igoweb.go.swing.Editor;
import org.igoweb.go.swing.GameWindow;
import org.igoweb.go.swing.sgf.SgfGamePanel;
import org.igoweb.go.swing.sgf.movie.Controller;
import org.igoweb.go.swing.sgf.movie.PlayerPanel;
import org.igoweb.igoweb.client.CPlayback;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.AudioWidget;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.speex.StreamPlayer;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.MsgOut;

public class PlaybackWindow
extends AFrame
implements EventListener {
    private final CPlayback playback;
    private long lastPosition;
    private long whenLastPositionReceived;
    private PlayerPanel playerPanel;
    private Controller controller;
    private boolean isOver = false;
    private Tree tree = new Tree();
    PipedOutputStream audioOut = new PipedOutputStream();
    StreamPlayer streamPlayer = null;
    private Client client;

    public PlaybackWindow(Client client, final CPlayback playback, AFrame clientWindow) {
        super((Component)clientWindow);
        this.client = client;
        this.setTitle(Defs.getString(-809883778, new Object[]{playback.gameSummary.getLocalDesc(), new Date(playback.gameSummary.id)}));
        this.playback = playback;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                playback.sendUnjoinRequest();
            }
        });
        playback.addListener(this);
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 135: {
                SgfEvent bundledEvent = (SgfEvent)event.arg;
                if (bundledEvent.type < 10) {
                    this.tree.apply(bundledEvent);
                    break;
                }
                this.handlePlaybackEvent(bundledEvent);
                break;
            }
            case 24: {
                this.handleAudioEvent((DataInputStream)event.arg);
                break;
            }
            case 16: {
                this.dispose();
                break;
            }
            case 31: {
                this.playerPanel.setAudioSuppressed(false);
                break;
            }
            case 30: {
                this.playerPanel.setAudioSuppressed(true);
            }
        }
    }

    private void handlePlaybackEvent(Event event) {
        switch (event.type) {
            case 10: {
                this.tree.setActiveNode(this.tree.root);
                while (this.tree.root.countChildren() > 0) {
                    this.tree.delete(this.tree.root.getChild(0));
                }
                Iterator<Prop> iter = this.tree.root.iterator();
                while (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                }
                this.isOver = false;
                break;
            }
            case 11: {
                if (this.playerPanel != null) break;
                this.controller = new KController();
                this.controller.init();
                this.controller.speedChanged(0.0f);
                this.playerPanel = new KPlayerPanel(this.tree, this.controller);
                this.getContentPane().add(this.playerPanel);
                this.pack();
                this.setVisible(true);
                GuiClientUtil.addToWindowList(this.client, this);
                break;
            }
            case 12: {
                this.isOver = true;
                this.controller.speedChanged(0.0f);
                new MsgOut(Defs.getString(-903340709), Defs.getString(-809883771), 1, (Component)this);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                this.lastPosition = ((Number)event.arg).longValue();
                this.whenLastPositionReceived = System.currentTimeMillis();
                if (this.controller == null) break;
                this.controller.updatePlaybackProgress();
            }
        }
    }

    private void handleAudioEvent(DataInputStream audioData) {
        if (this.audioOut == null) {
            return;
        }
        try {
            short fpp = audioData.readShort();
            if (this.streamPlayer == null) {
                if (fpp < 0 || fpp > AudioWidget.MAX_FRAMES_PER_PACKET) {
                    return;
                }
                this.streamPlayer = new StreamPlayer(new PipedInputStream(this.audioOut), fpp);
                this.streamPlayer.setDropLimit(600);
                this.streamPlayer.start();
            } else if (fpp != this.streamPlayer.getFramesPerPacket()) {
                return;
            }
            byte[] newData = new byte[audioData.available()];
            audioData.readFully(newData);
            this.audioOut.write(newData);
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
    }

    @Override
    protected String getSavePositionPref() {
        return "/UQ@sLL|";
    }

    @Override
    public void dispose() {
        if (this.streamPlayer != null) {
            this.streamPlayer.close();
            this.streamPlayer = null;
            try {
                this.audioOut.close();
            }
            catch (IOException excep) {
                throw new RuntimeException(excep);
            }
            this.audioOut = null;
        }
        super.dispose();
    }

    private class KPlayerPanel
    extends PlayerPanel {
        private JMenuItem saveAsMI;
        private JMenuItem viewOfflineMI;

        public KPlayerPanel(Tree tree, Controller controller) {
            super(tree, controller, null);
            this.setAudioSuppressed(true);
        }

        @Override
        protected void init(Tree newTree, LayoutManager2 layout) {
            super.init(newTree, layout);
            boolean isApp = Defs.isApp();
            ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
            if (this.scoreEstMI != null && estimator != null) {
                list.add(this.scoreEstMI);
                list.add(null);
            }
            this.saveAsMI = new JMenuItem(Defs.getString(-903340612));
            this.saveAsMI.addActionListener(this);
            this.saveAsMI.setEnabled(isApp);
            list.add(this.saveAsMI);
            this.viewOfflineMI = new JMenuItem(Defs.getString(-903340570));
            this.viewOfflineMI.addActionListener(this);
            this.viewOfflineMI.setEnabled(isApp);
            list.add(this.viewOfflineMI);
            this.setGameInfoMenuItems(list.toArray(new JMenuItem[0]));
            new Editor(this).addMap().setListener(null);
        }

        @Override
        protected JComponent buildCommentWidget() {
            return new CommentLogViewer(this.getSgfTree());
        }

        @Override
        protected void buildControlButtonList(ArrayList<JComponent> list) {
            list.add(this.helpBut);
            list.add(this.gameInfoBut);
            super.buildControlButtonList(list);
            list.add(this.closeBut);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.saveAsMI) {
                GuiClientUtil.get(PlaybackWindow.this.client).save(this, ((PlaybackWindow)PlaybackWindow.this).playback.gameSummary, PlaybackWindow.this.tree);
            } else if (event.getSource() == this.viewOfflineMI) {
                new GameWindow(1096335315, null, new SgfGamePanel(new FileIo(new Tree(PlaybackWindow.this.tree))));
            } else {
                super.actionPerformed(event);
            }
        }

        @Override
        protected String helpUrl() {
            return "playback.html";
        }

        @Override
        public void closePressed() {
            PlaybackWindow.this.playback.sendUnjoinRequest();
        }

        @Override
        protected boolean isStoneVolumeSliderNeeded() {
            return false;
        }
    }

    private class KController
    extends Controller {
        private KController() {
        }

        @Override
        public void setPlaybackParams(float newSpeed, long position) {
            if (position != -1L || !PlaybackWindow.this.isOver) {
                PlaybackWindow.this.playback.sendSetPosition(newSpeed, position);
                this.speedChanged(newSpeed);
            }
        }

        @Override
        public long getPlaybackPosition() {
            return PlaybackWindow.this.lastPosition + (long)((float)(System.currentTimeMillis() - PlaybackWindow.this.whenLastPositionReceived) * this.getPlaybackSpeed());
        }

        @Override
        public long getPlaybackLength() {
            return ((PlaybackWindow)PlaybackWindow.this).playback.length;
        }
    }
}

