/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.ACharBasic;
import org.sablecc.sablecc.node.ACharChar;
import org.sablecc.sablecc.node.AConcat;
import org.sablecc.sablecc.node.ARegExp;
import org.sablecc.sablecc.node.AStringBasic;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.AUnExp;
import org.sablecc.sablecc.node.PBasic;
import org.sablecc.sablecc.node.PChar;
import org.sablecc.sablecc.node.PConcat;
import org.sablecc.sablecc.node.PUnExp;

public class GenTokens
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    String text;

    public GenTokens(ResolveIds ids) {
        this.ids = ids;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("tokens.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to open tokens.txt.");
        }
        this.pkgDir = new File(ids.pkgDir, "node");
        String string = this.pkgName = ids.pkgName.equals("") ? "node" : ids.pkgName + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    @Override
    public void inATokenDef(ATokenDef node) {
        AConcat concat;
        LinkedList<PUnExp> unExps;
        BufferedWriter file;
        String name = (String)this.ids.names.get(node);
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, name + ".java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, name + ".java").getAbsolutePath());
        }
        this.text = null;
        ARegExp regExp = (ARegExp)node.getRegExp();
        LinkedList<PConcat> concats = regExp.getConcats();
        if (concats.size() == 1 && (unExps = (concat = (AConcat)concats.getFirst()).getUnExps()).size() == 1) {
            PChar pChar;
            AUnExp unExp = (AUnExp)unExps.getFirst();
            PBasic basic = unExp.getBasic();
            if (basic instanceof AStringBasic && unExp.getUnOp() == null) {
                this.text = ((AStringBasic)basic).getString().getText();
                this.text = this.text.substring(1, this.text.length() - 1);
            } else if (basic instanceof ACharBasic && unExp.getUnOp() == null && (pChar = ((ACharBasic)basic).getChar()) instanceof ACharChar) {
                this.text = ((ACharChar)pChar).getChar().getText();
                this.text = this.text.substring(1, this.text.length() - 1);
            }
        }
        try {
            if (this.text == null) {
                this.ids.fixedTokens.put(node, new Boolean(false));
                this.macros.apply(file, "VariableTextToken", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : this.ids.pkgName + ".analysis", name});
            } else {
                this.ids.fixedTokens.put(node, new Boolean(true));
                this.macros.apply(file, "FixedTextToken", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : this.ids.pkgName + ".analysis", name, this.processText(this.text)});
                this.ids.errorNames.put(node, "'" + this.text + "'");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, name + ".java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String processText(String s) {
        StringBuffer result = new StringBuffer();
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    result.append("\\t");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\r': {
                    result.append("\\r");
                    continue block10;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    result.append("\\'");
                    continue block10;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

