<?php
header('Content-Type: text/xml');
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"; ?>
<definitions name="SoapInteropCompound" 
		targetNamespace="http://soapinterop.org/" 
		xmlns:wsdlns="http://soapinterop.org/" 
		xmlns:typens="http://soapinterop.org/xsd"
		xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/" 
		xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
		xmlns="http://schemas.xmlsoap.org/wsdl/">
	<types>
		<schema targetNamespace="http://soapinterop.org/xsd" 
		xmlns="http://www.w3.org/2001/XMLSchema" 
		elementFormDefault="qualified">			
			<complexType name="Person">
				<sequence>
					<element minOccurs="1" maxOccurs="1" name="Age" type="double"/>
					<element minOccurs="1" maxOccurs="1" name="ID" type="xsd:float"/>					
				</sequence>
				<attribute name="Name" type="string"/>
				<attribute name="Male" type="boolean"/>
			</complexType>
			<element name="x_Person" type="typens:Person"/>	
			<element name="result_Person" type="typens:Person"/>
			
			<complexType name="Document">
			<simpleContent>
			 <extension base="string">
			   <xsd:attribute name ="ID" type="string"/>
			 </extension>
			</simpleContent>
			</complexType>	
			<element name="x_Document" type="typens:Document"/>	
			<element name="result_Document" type="typens:Document"/>	
		</schema>
	</types>
	<message name="echoPerson">
		<part name="x" element="typens:x_Person"/>
	</message>
	<message name="echoPersonResponse">
		<part name="Result" element="typens:result_Person"/>
	</message>
	<message name="echoDocument">
		<part name="x" element="typens:x_Document"/>
	</message>
	<message name="echoDocumentResponse">
		<part name="Result" element="typens:result_Document"/>
	</message>
	<portType name="SoapInteropCompound1PortType">
		<operation name="echoPerson" parameterOrder="x">
			<input message="wsdlns:echoPerson"/>
			<output message="wsdlns:echoPersonResponse"/>
		</operation>
		<operation name="echoDocument" parameterOrder="x">
			<input message="wsdlns:echoDocument"/>
			<output message="wsdlns:echoDocumentResponse"/>
		</operation>
	</portType>
	<binding name="SoapInteropCompound1Binding" type="wsdlns:SoapInteropCompound1PortType">
		<soap:binding style="document" transport="http://schemas.xmlsoap.org/soap/http"/>
		<operation name="echoPerson">
			<soap:operation soapAction="http://soapinterop/echoPerson"/>
			<input>
				<soap:body use="literal"/>
			</input>
			<output>
				<soap:body use="literal"/>
			</output>
		</operation>
		<operation name="echoDocument">
			<soap:operation soapAction="http://soapinterop/echoDocument"/>
			<input>
				<soap:body use="literal"/>
			</input>
			<output>
				<soap:body use="literal"/>
			</output>
		</operation>

	</binding>
	<service name="Compound1">
		<port name="SoapInteropCompound1Port" binding="wsdlns:SoapInteropCompound1Binding">
			<soap:address location="http://<?php echo $_SERVER["SERVER_NAME"].':'.$_SERVER["SERVER_PORT"];?>/soap_interop/server_Round3GroupDCompound1.php"/>
		</port>
	</service>
</definitions>
