/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import org.igoweb.igoweb.client.CChannel;
import org.igoweb.igoweb.client.CGame;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.ChatPane;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.ATextField;

public class CommentViewer
extends ChatPane {
    public CommentViewer(Client client, CGame game) {
        super(client, game, 100);
        this.setShowRanks(true);
    }

    @Override
    protected void handleChat(CChannel.Chat chat) {
        if (!(chat.moderated || !chat.announcement && this.getChannel().isCensored(chat.user))) {
            StringBuilder sb = new StringBuilder();
            if (chat.user != null) {
                sb.append(chat.user.getNameAndRank());
                for (int i = sb.length() - 1; i >= 0; --i) {
                    if (sb.charAt(i) != ' ') continue;
                    sb.setCharAt(i, '\u00a0');
                }
                sb.append(':').append('\u00a0');
            }
            sb.append(chat.text).append('\n');
            this.append(sb.toString(), chat.announcement ? 1 : 0, this.getCommentMoveNum());
        }
    }

    public void append(String comment, int moveNum) {
        this.append(comment, 0, moveNum);
    }

    public void append(String comment, int format, int moveNum) {
        StringBuilder line = new StringBuilder();
        int cLen = comment.length();
        int charNum = 0;
        while (charNum < cLen) {
            String userName;
            char c;
            int lineStart = charNum;
            line.setLength(0);
            int spcIndex = -1;
            while (charNum < cLen && (c = comment.charAt(charNum)) != '\n') {
                line.append(c);
                if (!(spcIndex != -1 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                    spcIndex = charNum;
                }
                ++charNum;
            }
            String string = userName = spcIndex < 0 ? "*" : comment.substring(lineStart, spcIndex);
            while (charNum < cLen && comment.charAt(charNum) == '\n') {
                if (format == 1 || !this.getChannel().isCensored(userName)) {
                    line.append('\n');
                }
                ++charNum;
            }
            if (format != 1 && this.getChannel().isCensored(userName)) continue;
            this.append(line.toString(), format, false);
        }
    }

    @Override
    protected String handleInput(ATextField src) {
        String text = super.handleInput(src);
        if (text != null && !((CGame)this.getChannel()).hasChatAccess()) {
            this.append(Defs.getString(-903340494, text) + '\n', 2, this.getCommentMoveNum());
        }
        return text;
    }

    public int getCommentMoveNum() {
        CGame cGame = (CGame)this.getChannel();
        return cGame.isOver() ? -1 : cGame.getMoveNum();
    }
}

