/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.connection.DatasourceConnectionProvider;

public class InjectedDataSourceConnectionProvider
extends DatasourceConnectionProvider {
    private String user;
    private String pass;
    private static final Log log = LogFactory.getLog(InjectedDataSourceConnectionProvider.class);

    public void setDataSource(DataSource ds) {
        super.setDataSource(ds);
    }

    public void configure(Properties props) throws HibernateException {
        this.user = props.getProperty("hibernate.connection.username");
        this.pass = props.getProperty("hibernate.connection.password");
        if (this.getDataSource() == null) {
            throw new HibernateException("No datasource provided");
        }
        log.info((Object)"Using provided datasource");
    }

    public Connection getConnection() throws SQLException {
        if (this.user != null || this.pass != null) {
            return this.getDataSource().getConnection(this.user, this.pass);
        }
        return this.getDataSource().getConnection();
    }
}

