/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.WindowManager;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class SQLFilterCommand
implements ICommand {
    private final IObjectTreeAPI _objectTree;
    private final IDatabaseObjectInfo _objectInfo;

    public SQLFilterCommand(IObjectTreeAPI objectTree, IDatabaseObjectInfo objectInfo) {
        if (objectInfo == null) {
            throw new IllegalArgumentException("Null IDatabaseObjectInfo passed");
        }
        if (objectTree == null) {
            throw new IllegalArgumentException("Null IObjectTreeAPI passed");
        }
        this._objectTree = objectTree;
        this._objectInfo = objectInfo;
    }

    @Override
    public void execute() {
        if (this._objectTree != null) {
            ISession session = this._objectTree.getSession();
            IApplication app = session.getApplication();
            WindowManager winMgr = app.getWindowManager();
            winMgr.showSQLFilterDialog(this._objectTree, this._objectInfo);
        }
    }
}

