require 'tofu/tofu'
require 'webrick'

module WEBrick
  class Tofulet < WEBrick::HTTPServlet::AbstractServlet
    include Tofu::ContextMixin

    def initialize(config, *options)
      @bartender = options.shift
      super(config, *options)
      @logger.debug("#{self.class}(initialize)")
      @req = @res = nil
    end
    attr_reader :logger, :config, :options, :bartender

    def service(req, res)
      @req = req
      @res = res
      bartender.service(self)
    end

    # req/res interface
    # params
    def req_params
      hash = {}
      @req.query.each do |k,v|
	hash[k] = v.list
      end
      hash
    end

    # cookie
    def req_cookie(name)
      found = @req.cookies.find {|c| c.name == name}
      found ? found.value : nil
    end

    def req_cookies
      hash = {}
      @req.cookies.each do |c|
	hash[c.name] = c.value
      end
      hash
    end

    def res_add_cookie(name, value, expires=nil)
      c = WEBrick::Cookie.new(name, value)
      c.expires = expires if expires
      @res.cookies.push(c)
    end
    
    # method
    def req_method
      @req.request_method
    end
    
    def res_method_not_allowed
      raise HTTPStatus::MethodNotAllowed, "unsupported method `#{req_method}'."
    end
    
    # meta
    def req_path_info
      @req.path_info
    end

    def req_script_name
      @req.script_name
    end
    
    def req_query_string
      @req.query_string
    end
    
    def req_meta_vars
      @req.meta_vars
    end
    
    def req_https?
      config[:SSLEnable]
    end

    # reply
    def res_body(v)
      @res.body = v
    end

    def res_header(k, v)
      if k.downcase == 'status'
	@res.status = v.to_i
	return
      end
      @res[k] = v
    end
  end
end
