/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.predictions;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.HashSet;
import java.util.Set;

public class FormatIndelVCF {
    public String fromVCF;
    public Set<String> toVCF;
    public Object2ObjectMap<String, String> mapBeforeAfter = new Object2ObjectArrayMap();

    public FormatIndelVCF(String from, Set<String> to, char refBase) {
        String string;
        HashSet<String> toRemove = new HashSet<String>();
        HashSet<Object> toAdd = new HashSet<Object>();
        for (String alt : to) {
            if (alt.length() != 1) continue;
            toRemove.add(alt);
            String refOrSnp = alt + (from.length() > 1 ? from.substring(1, from.length()) : "");
            toAdd.add(refOrSnp);
        }
        to.removeAll(toRemove);
        to.addAll(toAdd);
        int newLen = 1;
        int maxLen = -1;
        for (String string2 : to) {
            if (string2.length() <= maxLen) continue;
            maxLen = string2.length();
        }
        maxLen = Math.max(maxLen, from.length());
        for (int i = 0; i < maxLen; ++i) {
            if (from.length() > i && from.charAt(i) == '-') {
                newLen = i + 1;
            }
            for (String alt : to) {
                if (alt.length() <= i || alt.charAt(i) != '-') continue;
                newLen = i + 1;
            }
        }
        String postfix = newLen < from.length() ? from.substring(newLen, from.length()) : "";
        String string3 = this.trimPostfix(from, postfix);
        this.fromVCF = string = string3.replace("-", "");
        this.mapBeforeAfter.put((Object)from, (Object)string);
        this.toVCF = new ObjectArraySet();
        for (String alt : to) {
            String newAlt = this.trimPostfix(alt, postfix);
            newAlt = newAlt.replace("-", "");
            this.toVCF.add(newAlt);
            this.mapBeforeAfter.put((Object)alt, (Object)newAlt);
        }
    }

    private String trimPostfix(String from, String postfix) {
        if (from.endsWith(postfix)) {
            from = from.substring(0, from.length() - postfix.length());
        }
        return from;
    }

    public String mapped(String allele) {
        String result = (String)this.mapBeforeAfter.get((Object)allele);
        if (result != null) {
            return result;
        }
        return null;
    }
}

