/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import org.broad.igv.ui.util.MessageUtils;

public class RuntimeUtils {
    private static Logger log = Logger.getLogger(RuntimeUtils.class);

    public static long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return freeMemory + (maxMemory - allocatedMemory);
    }

    public static double getAvailableMemoryFraction() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return (double)(freeMemory + (maxMemory - allocatedMemory)) / (double)maxMemory;
    }

    public static Process startExternalProcess(String[] msg, String[] envp, File dir) throws IOException {
        Process pr = Runtime.getRuntime().exec(msg, envp, dir);
        RuntimeUtils.startErrorReadingThread(pr);
        return pr;
    }

    private static Process startErrorReadingThread(Process pr) {
        final BufferedReader err = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
        Thread runnable = new Thread(){
            private boolean messageDisplayed = false;

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = err.readLine()) != null) {
                        log.error((Object)line);
                        if (this.messageDisplayed || !line.toLowerCase().contains("error")) continue;
                        MessageUtils.showMessage(line + "<br>See igv.log for more details");
                        this.messageDisplayed = true;
                    }
                    err.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
        runnable.start();
        return pr;
    }

    @Deprecated
    public static String executeShellCommand(String cmd, String[] envp, File dir) throws IOException {
        return RuntimeUtils.executeShellCommand(new String[]{cmd}, envp, dir);
    }

    public static String executeShellCommand(String[] cmd, String[] envp, File dir) throws IOException {
        return RuntimeUtils.executeShellCommand(cmd, envp, dir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeShellCommand(String[] cmd, String[] envp, File dir, boolean waitFor) throws IOException {
        Process pr = RuntimeUtils.startExternalProcess(cmd, envp, dir);
        if (waitFor) {
            try {
                pr.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        InputStream inputStream = null;
        String line = "";
        try {
            inputStream = pr.getInputStream();
            BufferedReader buf = new BufferedReader(new InputStreamReader(inputStream));
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            while ((line = buf.readLine()) != null) {
                pw.println(line);
            }
            pw.close();
            String string = writer.toString();
            return string;
        }
        finally {
            OutputStream os;
            if (inputStream != null) {
                inputStream.close();
            }
            if ((os = pr.getOutputStream()) != null) {
                os.close();
            }
        }
    }
}

