/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2009  Kouhei Sutou <kou@clear-code.com>
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __CUT_CONSOLE_H__
#define __CUT_CONSOLE_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define CUT_CONSOLE_COLOR_RED "\033[01;31m"
#define CUT_CONSOLE_COLOR_RED_BACK "\033[41m"
#define CUT_CONSOLE_COLOR_GREEN "\033[01;32m"
#define CUT_CONSOLE_COLOR_GREEN_BACK "\033[01;42m"
#define CUT_CONSOLE_COLOR_YELLOW "\033[01;33m"
#define CUT_CONSOLE_COLOR_BLUE "\033[01;34m"
#define CUT_CONSOLE_COLOR_BLUE_BACK "\033[01;44m"
#define CUT_CONSOLE_COLOR_MAGENTA "\033[01;35m"
#define CUT_CONSOLE_COLOR_CYAN "\033[01;36m"
#define CUT_CONSOLE_COLOR_CYAN_BACK "\033[01;46m"
#define CUT_CONSOLE_COLOR_WHITE "\033[01;37m"
#define CUT_CONSOLE_COLOR_WHITE_BACK "\033[01;47m"
#define CUT_CONSOLE_COLOR_BLACK_BACK "\033[01;40m"
#define CUT_CONSOLE_COLOR_NORMAL "\033[00m"

gboolean cut_console_guess_color_usability (void);
gboolean cut_console_parse_color_arg       (const gchar  *option_name,
                                            const gchar  *value,
                                            gboolean     *use_color,
                                            GError      **error);

G_END_DECLS

#endif /* __CUT_CONSOLE_H__ */

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
