# defines if select() shall be used, normally 1, put to 0, if you are
# using old kernels (select() produces there a higher CPU-load).
use_select 1

# --------------------------------------------------------------------------

# 0 for real TNC at serial port, 1 for TFKISS on a UNIX-socket,
# 2 for TFKISS on other socket
soft_tnc 0

# serial port to which TNC is connected, UNIX-socket of TFKISS or
# other socket for TFKISS
device /dev/ttyS0

# lockfile for serial port or TFKISS
tnt_lockfile /var/lock/LCK..ttyS0

# baudrate used, only used if TNC at serial port
speed 19200

# timinig parameters for interface to tfkiss (soft_tnc is 1)
# 1: fixed wait (10ms) after each hostmode-packet sent to tfkiss
fixed_wait 1
# if fixed_wait == 0, number of sent characters to tfkiss after which
# tnt will wait 10ms 
amount_wait 20

# --------------------------------------------------------------------------

# number of channels of TNC
tnc_channels 10

# first channel with reduced backscroll buffer
r_channels 4

# --------------------------------------------------------------------------

# enable static huffman compression (//COMP)
tnt_comp 1

# try to uncompress frames in the monitor window
moni_decomp 1

# disable binary packets
moni_chkbin 1

# packet length for transmission of files
file_paclen 255

# set to 1 to disconnect all channels on startup
disc_on_start 0

# --------------------------------------------------------------------------

# UNIX-user for remote permissions
remote_user guest

### Only available if compiled with GEN_NEW_USER support!
# If set to 1, new users will be created, if set to 0, all new users will
# be logged in as user defined by 'remote_user'.
#unix_new_user 1

# lowest user-id for creation of new users
#unix_first_uid 410

# highest user-id for creation of new users
#unix_user_max 4095

# group-id for new users
#unix_user_gid 101
###

# --------------------------------------------------------------------------

# timeout packet assembly (in seconds) for SHELL/REDIR and interface
pty_timeout 2

# --------------------------------------------------------------------------

# set to 1 for request of R:-headers in boxlist read command
blist_add_plus 0

# --------------------------------------------------------------------------

# SSID of DPBox (A channel with this SSID must exist in TNC!)
tnt_box_ssid 7

# Call and SSID of DPBox (A channel with this Call and SSID
# must exist in TNC!)
# (If this parameter is used, 'tnt_box_ssid' will be ignored)
#tnt_box_call

# SSID of a node connect (not yet ready)
tnt_node_ssid 9

# Call and SSID of a node connect (not yet ready)
#tnt_node_call

# --------------------------------------------------------------------------

# work/spool directory
tnt_work_dir /var/spool/tnt
# configuration directory
tnt_conf_dir /usr/pkg/share/tnt/conf
# doc dir directory
tnt_doc_dir /usr/pkg/share/doc/tnt
# log file directory
tnt_log_dir /var/log
# pid/socket directory
tnt_proc_dir /var/run
# remote directory
remote_dir remote/
# ctext directory
ctext_dir ctext/
# directory for corrupt autobin-files
abin_dir abin/
# directory for uploads
upload_dir up/
# directory for downloads
download_dir down/
# directory for 7plus
tnt_7plus_dir 7plus/
# directory for YAPP
yapp_dir yapp/
# directory for executable programs
tnt_bin_dir /usr/pkg/libexec/tnt
# home-dir for new users (only if compiled with GEN_NEW_USER support)
#unix_user_dir tntusers/
# dir for macro-texts
macrotext_dir macro/
# dir for box-broadcastfiles
tnt_bcnewmaildir bcast/newmail/
# dir for broadcastfiles
tnt_bcsavedir bcast/save/
# dir for temporary broadcastfiles
tnt_bctempdir /tmp/
# dir for tnt soundfiles (only if compiled with TNT_SOUND!)
tnt_sound_dir /usr/pkg/share/tnt/sounds
# upfile
tnt_upfile tnt.up
# downfile
tnt_downfile tnt.dwn
# file containing process id
proc_file tnt.pid
# remote infofile
rem_info_file tntrem.inf
# remote helpfile
rem_help_file tntrem.hlp.en
# tnthelpfile
tnt_help_file tnt.hlp.en
# cookiefile
tnt_cookiefile /usr/games/fortunes/startrek
# namesfile
name_file_name names.tnt
# routesfile
route_file_name routes.tnt
# newsfile
news_file_name news.tnt
# connect text
tnt_ctextfile ctext.tnt
# quit text
tnt_qtextfile qtext.tnt
# logbook file
tnt_logbookfile tnt.log
# password file
tnt_pwfile pw.tnt
# sysop access files
tnt_sysfile sys.tnt
# calls with remote disabled
tnt_noremfile norem.tnt
# calls which do flexnet-linkquality-check
tnt_flchkfile flchk.tnt
# own call/SSID not allowed for xconnect
tnt_notownfile notown.tnt
# resync logfile
resy_log_file resy.log
# broadcast logfile
bcast_log_file bcast.log
# socket passwordfile
sock_passfile netpass.tnt
# file for keyboard macros
func_key_file fkeys.tnt
# file for extended remote commands
tnt_extremotefile extrem.tnt
# file for autostart on connect
tnt_autostartfile autostrt.tnt
# file for telltexts
tnt_tellfile telltexte.tnt
# Logfile for saving tnt-session status
tnt_sessionlog /var/log/tntsession_status
# file for sound effects (only if compiled with TNT_SOUND!)
# tnt_soundfile sounds.tnt

# socket for digipoint box
# use "0", if you don't want to use dpbox
box_socket /work/box/stat/socket
# directory for newmail
newmaildir newmail/
# file holding monitored folders
autobox_dir autobox.dir
# file for boxfile endings
tnt_boxender boxender.tnt
# file for f6fbb-definitions
f6fbb_box /work/box/system/f6fbb.box

# socket for tntnode (not yet ready)
node_socket /work/tntnode/socket

# socket for frontend
frontend_socket unix:tntsock

# --------------------------------------------------------------------------

# maximum length of input line
input_linelen 80

# set to 1 if insertmode shall be active after startup
insertmode 0

# maximum number of entries in heardlist
num_heardentries 100

# number of lines for backscroll

# command-screen
lines_command 50
# monitor-screen
lines_monitor 400

# input area of connect-screens
lines_input 20
# output area of connect-screens
lines_output 100
# input area of connect-screens (reduced backscroll)
lines_r_input 5
# output area of connect-screens (reduced backscroll)
lines_r_output 20
# input/output-lines ratio on real screen (connect)
scr_divide 5
# monitor lines on connect-screens
lines_moncon 0

# input area of mailbox-screen
lines_mbinput 10
# output area of mailbox-screen
lines_mboutput 200
# input/output-lines ratio on real screen (mailbox)
mbscr_divide 8

# input area of extended monitor screens
lines_xmon_pre 10
# output area of extended monitor screens
lines_xmon 100
# input/output-lines ratio on real screen (extended monitor)
xmon_scr_divide 5

# --------------------------------------------------------------------------

# 0: monochrom, 1: use color attributes if TERM = 'linux' or 'conXXX',
# otherwise use monochrom attributes and termcap, 2: use color attributes,
# 3: use color attributes and termcap if TERM = 'xterm'
color 1

# 0: don't use termcap, 1: use termcap
termcap 0

# 1: alternative channel status line
altstat 0

# --------------------------------------------------------------------------

# attributes for color

# normal characters
attc_normal 0x47
# characters in bottom statusline
attc_statline 0x3A
# characters in monitor-headers
attc_monitor 0x4A
# characters in channel statusline
attc_cstatline 0x74
# control-characters
attc_controlchar 0x07
# remote-answers
attc_remote 0x4F
# special features
attc_special 0x0F
# color for port 1
attc_monport1 0x4B
# color for port 2
attc_monport2 0x43

# --------------------------------------------------------------------------

# attributes for monochrom

# normal characters
attm_normal 0x00
# characters in bottom statusline
attm_statline 0x08
# characters in monitor-headers
attm_monitor 0x10
# characters in channel statusline
attm_cstatline 0x10
# control-characters
attm_controlchar 0x10
# remote-answers and own transmitted text
attm_remote 0x10
# special features
attm_special 0x10
# color for port 1
attm_monport1 0x10
# color for port 2
attm_monport2 0x08

# --------------------------------------------------------------------------

# these values must remain unchanged using LINUX

# 1: terminal puts cursor to a new line after character in last column
auto_newline 0

# 1: don't display characters 128-160
supp_hicntl 0

# --------------------------------------------------------------------------

# AX25 Port (only if compiled with USE_AX25K)
# ax25k_port P3

# Fullmoniflag (0: display only received frames, 1: display all frames)
# NOTE: a value of '1' means that TNT have to analysis all frames of the
#       network which will cause a high load if you are using a busy ethernet
# fullmoni_flag 0

