/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.autoupdate;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.spi.autoupdate.PluginInstallerImplementation;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.UserCancelException;

public final class PluginInstaller {
    private static final Logger LOG = Logger.getLogger(PluginInstaller.class.getName());
    private static PluginInstaller INSTANCE;

    public static PluginInstaller getDefault() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new PluginInstaller();
        return INSTANCE;
    }

    public Object install(@NonNull String string, @NonNull String string2, Lookup lookup, Object ... objectArray) {
        try {
            return this.install(Collections.singleton(string), string2, lookup, objectArray);
        }
        catch (UserCancelException userCancelException) {
            LOG.log(Level.FINE, "User cancelled", userCancelException);
            return NotifyDescriptor.CANCEL_OPTION;
        }
        catch (OperationException operationException) {
            LOG.log(Level.WARNING, "Exception during install of " + string, operationException);
            return NotifyDescriptor.CANCEL_OPTION;
        }
    }

    public Object install(@NonNull String string) {
        return this.install(string, null, null, new Object[0]);
    }

    public Object install(@NonNull Set<String> set, String string, Lookup lookup, Object ... objectArray) throws OperationException, UserCancelException {
        PluginInstallerImplementation pluginInstallerImplementation = (PluginInstallerImplementation)Lookup.getDefault().lookup(PluginInstallerImplementation.class);
        if (pluginInstallerImplementation == null) {
            throw new UserCancelException();
        }
        Object object = pluginInstallerImplementation.install(set, string, lookup == null ? Lookup.EMPTY : lookup, objectArray);
        if (object == NotifyDescriptor.CLOSED_OPTION) {
            return NotifyDescriptor.CANCEL_OPTION;
        }
        return object;
    }
}

