/*
 * Decompiled with CFR 0.152.
 */
package org.fife.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fife.help.HelpTreeNode;
import org.fife.help.TopicsFoundDialog;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.RTreeSelectionModel;
import org.fife.ui.StatusBar;
import org.fife.ui.UIUtil;
import org.fife.ui.app.GUIApplication;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HelpDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private GUIApplication app;
    private JTabbedPane tabbedPane;
    private DefaultMutableTreeNode root;
    private JTree tocTree;
    private boolean rootVisible;
    private JEditorPane editorPane;
    private JList indexList;
    private JButton indexDisplayButton;
    private JTextField indexField;
    private JList searchList;
    private JButton searchDisplayButton;
    private JButton listTopicsButton;
    private JTextField searchField;
    private JButton backButton;
    private JButton forwardButton;
    private String searchString;
    private boolean highlightSearchString;
    private ArrayList history;
    private int historyPos;
    private boolean updateHistory;
    private boolean clickedOnTOCTree;
    private JLabel keywordToFindLabel;
    private JLabel keywordToFindLabel2;
    private JLabel topicToDisplayLabel;
    private String baseDir;
    private URL baseURL;
    private String noMatchHTML;
    private boolean webUrlsInRealBrowser;
    private ResourceBundle treeBundle;
    private String[] indexElements;
    private static final String HTML_TYPE = "text/html";
    private static final String TEXT_TYPE = "text/plain";
    private static final String INDEXITEMS = "IndexItems";
    private static final String NAME = "name";
    private static final String PAGE = "Page";
    private static final String PAGE_VALUE = "page";
    private static final String PROPERTIES_FILE = "PropertiesFile";
    private static final String ROOT_ELEMENT = "HelpDialogContents";
    private static final String TREE_NODE = "Node";
    private static final String TREE_ROOT_NODE = "RootNode";
    private static final String VISIBLE = "visible";
    private static final int BUF_SIZE = 16384;

    public HelpDialog(GUIApplication owner, String contentsFile, String baseDir) {
        this.app = owner;
        Border border8080 = BorderFactory.createEmptyBorder(8, 0, 8, 0);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        boolean ltr = orientation.isLeftToRight();
        ResourceBundle msg = this.getHelpBundle();
        HelpListener listener = new HelpListener();
        this.webUrlsInRealBrowser = true;
        this.noMatchHTML = "<html><body><h2>" + msg.getString("NoMatch") + "</h2><HR ALIGN=\"center\" WIDTH=\"100%\"></body></html>";
        this.baseDir = baseDir;
        try {
            this.setBaseURL(new File(baseDir).toURI().toURL());
        }
        catch (Exception e) {
            this.app.displayException(this, (Throwable)e);
        }
        this.createRoot(contentsFile);
        this.editorPane = new JEditorPane();
        this.editorPane.setFont(new Font("Monospaced", 0, 12));
        this.editorPane.setPreferredSize(new Dimension(648, 300));
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(listener);
        this.editorPane.setContentType(HTML_TYPE);
        this.editorPane.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        JPanel tocPanel = UIUtil.newTabbedPanePanel();
        tocPanel.setLayout(new BoxLayout(tocPanel, 1));
        tocPanel.setBorder(UIUtil.getEmpty5Border());
        this.tocTree = new JTree(this.root);
        this.tocTree.setRootVisible(this.rootVisible);
        this.tocTree.setSelectionModel(new RTreeSelectionModel());
        this.tocTree.addTreeSelectionListener(listener);
        this.tocTree.addKeyListener(listener);
        RScrollPane scrollPane = new RScrollPane(1, 1, this.tocTree);
        scrollPane.setHorizontalScrollBarPolicy(32);
        tocPanel.add(scrollPane);
        JPanel indexPanel = UIUtil.newTabbedPanePanel();
        indexPanel.setLayout(new BorderLayout());
        indexPanel.setBorder(UIUtil.getEmpty5Border());
        JPanel indexInputPanel = UIUtil.newTabbedPanePanel();
        indexInputPanel.setLayout(new BoxLayout(indexInputPanel, 1));
        this.keywordToFindLabel = new JLabel(msg.getString("KeywordLabel"));
        JPanel ilPanel = UIUtil.newTabbedPanePanel();
        ilPanel.setLayout(new BorderLayout());
        ilPanel.add((Component)this.keywordToFindLabel, "Before");
        this.indexField = new JTextField();
        this.indexField.setMaximumSize(new Dimension(3000, 20));
        this.indexField.getDocument().addDocumentListener(listener);
        this.indexField.addKeyListener(listener);
        indexInputPanel.add(ilPanel);
        indexInputPanel.add(this.indexField);
        this.indexList = new JList<String>(this.indexElements);
        this.indexElements = null;
        this.indexList.addMouseListener(listener);
        this.indexList.addKeyListener(listener);
        this.indexList.setSelectionModel(new RListSelectionModel());
        RScrollPane indexScrollPane = new RScrollPane(1, 1, this.indexList);
        indexScrollPane.setPreferredSize(new Dimension(100, 200));
        indexScrollPane.setVerticalScrollBarPolicy(22);
        JPanel indexButtonPanel = UIUtil.newTabbedPanePanel();
        indexButtonPanel.setLayout(new BoxLayout(indexButtonPanel, 2));
        this.indexDisplayButton = UIUtil.newTabbedPaneButton(msg.getString("Display"));
        this.indexDisplayButton.setActionCommand("Display");
        this.indexDisplayButton.addActionListener(this);
        indexButtonPanel.add(Box.createHorizontalGlue());
        indexButtonPanel.add(this.indexDisplayButton);
        indexPanel.add((Component)indexInputPanel, "North");
        JPanel temp = UIUtil.newTabbedPanePanel();
        temp.setLayout(new BorderLayout());
        temp.setBorder(border8080);
        temp.add(indexScrollPane);
        indexPanel.add(temp);
        indexPanel.add((Component)indexButtonPanel, "South");
        this.indexList.setSelectedIndex(0);
        JPanel searchPanel = UIUtil.newTabbedPanePanel();
        searchPanel.setLayout(new BorderLayout());
        searchPanel.setBorder(UIUtil.getEmpty5Border());
        JPanel searchInputPanel = UIUtil.newTabbedPanePanel();
        searchInputPanel.setLayout(new BoxLayout(searchInputPanel, 1));
        this.keywordToFindLabel2 = new JLabel(msg.getString("KeywordLabel"));
        JPanel slPanel = UIUtil.newTabbedPanePanel();
        slPanel.setLayout(new BorderLayout());
        slPanel.add((Component)this.keywordToFindLabel2, "Before");
        this.searchField = new JTextField();
        this.searchField.setMaximumSize(new Dimension(3000, 20));
        this.searchField.getDocument().addDocumentListener(listener);
        this.searchField.addKeyListener(listener);
        this.listTopicsButton = UIUtil.newTabbedPaneButton(msg.getString("ListTopics"));
        this.listTopicsButton.setActionCommand("ListTopics");
        this.listTopicsButton.addActionListener(this);
        this.listTopicsButton.setEnabled(false);
        JPanel ltbPanel = UIUtil.newTabbedPanePanel();
        ltbPanel.setLayout(new BoxLayout(ltbPanel, 2));
        ltbPanel.add(Box.createHorizontalGlue());
        ltbPanel.add(this.listTopicsButton);
        this.topicToDisplayLabel = new JLabel(msg.getString("TopicToDisplay"));
        JPanel stlPanel = UIUtil.newTabbedPanePanel();
        stlPanel.setLayout(new BorderLayout());
        stlPanel.add((Component)this.topicToDisplayLabel, "Before");
        searchInputPanel.add(slPanel);
        searchInputPanel.add(this.searchField);
        searchInputPanel.add(Box.createVerticalStrut(5));
        searchInputPanel.add(ltbPanel);
        searchInputPanel.add(Box.createVerticalStrut(5));
        searchInputPanel.add(stlPanel);
        this.searchList = new JList();
        this.searchList.addMouseListener(listener);
        this.searchList.addKeyListener(listener);
        this.searchList.setSelectionModel(new RListSelectionModel());
        RScrollPane searchScrollPane = new RScrollPane(1, 1, this.searchList);
        searchScrollPane.setPreferredSize(new Dimension(100, 200));
        searchScrollPane.setVerticalScrollBarPolicy(22);
        JPanel searchButtonPanel = UIUtil.newTabbedPanePanel();
        searchButtonPanel.setLayout(new BoxLayout(searchButtonPanel, 2));
        this.searchDisplayButton = UIUtil.newTabbedPaneButton(msg.getString("Display"));
        this.searchDisplayButton.setActionCommand("Display");
        this.searchDisplayButton.addActionListener(this);
        this.searchDisplayButton.setEnabled(false);
        searchButtonPanel.add(Box.createHorizontalGlue());
        searchButtonPanel.add(this.searchDisplayButton);
        searchPanel.add((Component)searchInputPanel, "North");
        temp = UIUtil.newTabbedPanePanel();
        temp.setLayout(new BorderLayout());
        temp.setBorder(border8080);
        temp.add(searchScrollPane);
        searchPanel.add(temp);
        searchPanel.add((Component)searchButtonPanel, "South");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(listener);
        this.tabbedPane.addTab(msg.getString("Contents"), tocPanel);
        this.tabbedPane.addTab(msg.getString("Index"), indexPanel);
        this.tabbedPane.addTab(msg.getString("Search"), searchPanel);
        JPanel leftPanel = new JPanel(new GridLayout(1, 1));
        leftPanel.setPreferredSize(new Dimension(300, 400));
        leftPanel.add(this.tabbedPane);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setContinuousLayout(true);
        RScrollPane rightScrollPane = new RScrollPane(400, 200, this.editorPane);
        rightScrollPane.setVerticalScrollBarPolicy(22);
        if (ltr) {
            splitPane.setLeftComponent(leftPanel);
            splitPane.setRightComponent(rightScrollPane);
        } else {
            splitPane.setLeftComponent(rightScrollPane);
            splitPane.setRightComponent(leftPanel);
        }
        JToolBar toolBar = new JToolBar();
        this.backButton = UIUtil.newButton(msg, "Back", this);
        this.backButton.setActionCommand("Back");
        this.backButton.setEnabled(false);
        toolBar.add(this.backButton);
        this.forwardButton = UIUtil.newButton(msg, "Forward", this);
        this.forwardButton.setActionCommand("Forward");
        this.forwardButton.setEnabled(false);
        toolBar.add(this.forwardButton);
        toolBar.setFloatable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)toolBar, "North");
        contentPane.add((Component)splitPane, "Center");
        contentPane.add((Component)new StatusBar(""), "South");
        this.pack();
        this.history = new ArrayList();
        this.updateHistory = true;
        this.clickedOnTOCTree = true;
        this.historyPos = -1;
        this.tocTree.setSelectionRow(0);
        this.backButton.setEnabled(false);
        this.setTitle(msg.getString("Title"));
        msg = null;
        this.setIconImage(owner.getIconImage());
        this.applyComponentOrientation(orientation);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String actionCommand = e.getActionCommand();
        if (source.equals(this.indexDisplayButton)) {
            this.loadSelectedHelpPageIndex();
        } else if (source.equals(this.searchDisplayButton)) {
            this.loadSelectedHelpPageSearch();
        } else if (actionCommand.equals("ListTopics")) {
            this.searchString = this.searchField.getText();
            this.populateSearchList();
        } else if (actionCommand.equals("Back")) {
            this.updateHistory = false;
            this.highlightSearchString = false;
            if (this.historyPos > 0) {
                --this.historyPos;
                this.setHelpPageURL(((HelpTreeNode)this.history.get((int)this.historyPos)).url);
            } else {
                this.setHelpPageURL(null);
            }
            if (this.historyPos == 0) {
                this.backButton.setEnabled(false);
            }
            if (this.historyPos < this.history.size() - 1) {
                this.forwardButton.setEnabled(true);
            }
        } else if (actionCommand.equals("Forward")) {
            this.updateHistory = false;
            this.highlightSearchString = false;
            ++this.historyPos;
            this.setHelpPageURL(((HelpTreeNode)this.history.get((int)this.historyPos)).url);
            if (this.historyPos == this.history.size() - 1) {
                this.forwardButton.setEnabled(false);
            }
            if (this.historyPos > 0) {
                this.backButton.setEnabled(true);
            }
        }
    }

    private void createRoot(String helpXMLFile) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        org.w3c.dom.Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new FileReader(helpXMLFile));
            doc = db.parse(is);
        }
        catch (Exception ex) {
            this.app.displayException(this, (Throwable)ex);
            return;
        }
        this.root = this.initializeFromXMLFile(doc.getDocumentElement());
    }

    private ArrayList getArrayList(DefaultMutableTreeNode root, String searchString) {
        ArrayList<HelpTreeNode> arrayList = new ArrayList<HelpTreeNode>();
        int count = root.getChildCount();
        String searchStringLower = searchString.toLowerCase();
        for (int i = 0; i < count; ++i) {
            ArrayList temp;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            HelpTreeNode node = (HelpTreeNode)child.getUserObject();
            String contents = this.getContents(node);
            if ((contents = contents.replaceAll("<[^>]*>", "")).toLowerCase().indexOf(searchStringLower) != -1) {
                arrayList.add(node);
            }
            if (child.getChildCount() <= 0 || (temp = this.getArrayList(child, searchString)).size() <= 0) continue;
            arrayList.addAll(temp);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContents(HelpTreeNode node) {
        String contents = "";
        if (node != null && node.url != null) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(node.url.openConnection().getInputStream()));
                try {
                    contents = HelpDialog.read(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                this.app.displayException(this, (Throwable)e);
            }
            if (this.highlightSearchString) {
                int searchStringLength = this.searchString.length();
                String searchStringLower = this.searchString.toLowerCase();
                int pos = contents.toLowerCase().indexOf(searchStringLower);
                while (pos != -1) {
                    int gtPos = contents.indexOf(">", pos);
                    if (gtPos < contents.indexOf("<", pos)) {
                        pos = contents.toLowerCase().indexOf(searchStringLower, gtPos + 1);
                        continue;
                    }
                    int tempEnd = pos + searchStringLength;
                    contents = contents.substring(0, pos) + "<font bgcolor=\"#FFFF00\">" + contents.substring(pos, tempEnd) + "</font>" + contents.substring(tempEnd, contents.length());
                    int startPos = pos + searchStringLength + "<font bgcolor=\"#FFFF00\">".length() + "</font>".length();
                    pos = contents.toLowerCase().indexOf(searchStringLower, startPos);
                }
            }
        }
        return contents;
    }

    public final String getContentsTabText() {
        return this.tabbedPane.getTitleAt(0);
    }

    public final String getDisplayButtonText() {
        return this.indexDisplayButton.getText();
    }

    private final ResourceBundle getHelpBundle() {
        return ResourceBundle.getBundle("org.fife.help.HelpDialog", this.getLocale());
    }

    public final String getIndexTabText() {
        return this.tabbedPane.getTitleAt(1);
    }

    public final String getKeywordFieldLabelText() {
        return this.keywordToFindLabel.getText();
    }

    public final String getListTopicsButtonText() {
        return this.listTopicsButton.getText();
    }

    public boolean getOpenWebUrlsInRealBrowser() {
        return this.webUrlsInRealBrowser;
    }

    public final String getSearchTabText() {
        return this.tabbedPane.getTitleAt(2);
    }

    public final String getTopicToDisplayFieldLabelText() {
        return this.topicToDisplayLabel.getText();
    }

    private static final String guessContentType(String path) {
        String lower;
        if (path != null && ((lower = path.toLowerCase()).endsWith("html") || lower.endsWith("htm") || lower.endsWith("jsp"))) {
            return HTML_TYPE;
        }
        return TEXT_TYPE;
    }

    private DefaultMutableTreeNode handleNodePage(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null || attributes.getLength() != 2) {
            return null;
        }
        String name = null;
        String file = null;
        for (int i = 0; i < 2; ++i) {
            Node node2 = attributes.item(i);
            String v = node2.getNodeValue();
            if (node2.getNodeName().equals(NAME)) {
                name = this.treeBundle.getString(v);
                continue;
            }
            if (!node2.getNodeName().equals(PAGE_VALUE)) continue;
            file = this.baseDir + v;
        }
        if (name == null || file == null) {
            return null;
        }
        HelpTreeNode tempNode = new HelpTreeNode(name, file);
        return new DefaultMutableTreeNode(tempNode);
    }

    private DefaultMutableTreeNode handleNodeIndexItems(Node node) {
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            int length = childNodes.getLength();
            ArrayList<String> elements = new ArrayList<String>(length / 2);
            for (int i = 0; i < length; ++i) {
                Node node2 = childNodes.item(i);
                if (node2.getNodeType() == 3) continue;
                NamedNodeMap attributes = node2.getAttributes();
                if (attributes == null || attributes.getLength() != 1) {
                    return null;
                }
                node2 = attributes.item(0);
                if (!HelpDialog.validateAttributeNode(node2, NAME)) continue;
                String name = node2.getNodeValue();
                elements.add(name);
            }
            int size = elements.size();
            this.indexElements = new String[size];
            for (int i = 0; i < size; ++i) {
                this.indexElements[i] = (String)elements.get(i);
            }
        }
        return null;
    }

    private DefaultMutableTreeNode handleNodePropertiesFile(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null || attributes.getLength() != 1) {
            return null;
        }
        Node node2 = attributes.item(0);
        if (!HelpDialog.validateAttributeNode(node2, NAME)) {
            return null;
        }
        String name = node2.getNodeValue();
        try {
            this.treeBundle = new PropertyResourceBundle(new FileInputStream(this.baseDir + name));
        }
        catch (Exception e) {
            this.app.displayException(e);
            return null;
        }
        return null;
    }

    private DefaultMutableTreeNode initializeFromXMLFile(Node node) {
        if (node == null) {
            return null;
        }
        short type = node.getNodeType();
        if (type == 1) {
            String nodeName = node.getNodeName();
            if (nodeName.equals(ROOT_ELEMENT)) {
                NodeList childNodes = node.getChildNodes();
                if (childNodes != null) {
                    int length = childNodes.getLength();
                    for (int i = 0; i < length; ++i) {
                        this.initializeFromXMLFile(childNodes.item(i));
                    }
                }
                this.treeBundle = null;
                return this.root;
            }
            if (nodeName.equals(PROPERTIES_FILE)) {
                return this.handleNodePropertiesFile(node);
            }
            if (nodeName.equals(TREE_ROOT_NODE)) {
                NamedNodeMap attributes = node.getAttributes();
                if (attributes == null || attributes.getLength() < 2) {
                    return null;
                }
                String name = null;
                String file = null;
                int count = attributes.getLength();
                for (int i = 0; i < count; ++i) {
                    Node node2 = attributes.item(i);
                    String v = node2.getNodeValue();
                    if (node2.getNodeName().equals(NAME)) {
                        name = this.treeBundle.getString(v);
                        continue;
                    }
                    if (node2.getNodeName().equals(VISIBLE)) {
                        this.rootVisible = new Boolean(v);
                        continue;
                    }
                    if (!node2.getNodeName().equals(PAGE_VALUE)) continue;
                    file = this.baseDir + v;
                }
                if (name == null) {
                    return null;
                }
                HelpTreeNode helpRoot = file == null ? new HelpTreeNode(name) : new HelpTreeNode(name, file);
                this.root = new DefaultMutableTreeNode(helpRoot);
                NodeList childNodes = node.getChildNodes();
                if (childNodes != null) {
                    int length = childNodes.getLength();
                    for (int i = 0; i < length; ++i) {
                        DefaultMutableTreeNode dmtn = this.initializeFromXMLFile(childNodes.item(i));
                        if (dmtn == null) continue;
                        this.root.add(dmtn);
                    }
                }
                return this.root;
            }
            if (nodeName.equals(TREE_NODE)) {
                NamedNodeMap attributes = node.getAttributes();
                if (attributes == null || attributes.getLength() < 1) {
                    return null;
                }
                String name = null;
                String file = null;
                int count = attributes.getLength();
                for (int i = 0; i < count; ++i) {
                    Node node2 = attributes.item(i);
                    String v = node2.getNodeValue();
                    if (node2.getNodeName().equals(NAME)) {
                        name = this.treeBundle.getString(v);
                        continue;
                    }
                    if (!node2.getNodeName().equals(PAGE_VALUE)) continue;
                    file = this.baseDir + v;
                }
                HelpTreeNode tempNode = file == null ? new HelpTreeNode(name) : new HelpTreeNode(name, file);
                DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(tempNode);
                NodeList childNodes = node.getChildNodes();
                if (childNodes != null) {
                    int length = childNodes.getLength();
                    for (int i = 0; i < length; ++i) {
                        DefaultMutableTreeNode newNode = this.initializeFromXMLFile(childNodes.item(i));
                        if (newNode == null) continue;
                        dmtn.add(newNode);
                    }
                }
                return dmtn;
            }
            if (nodeName.equals(PAGE)) {
                return this.handleNodePage(node);
            }
            if (nodeName.equals(INDEXITEMS)) {
                return this.handleNodeIndexItems(node);
            }
            throw new InternalError("Should never get here (nodename=='" + nodeName + "')");
        }
        return null;
    }

    private void loadSelectedHelpPageIndex() {
        String selected = (String)this.indexList.getSelectedValue();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tocTree.getModel().getRoot();
        ArrayList matchNodes = this.getArrayList(root, selected);
        int size = matchNodes.size();
        if (size == 1) {
            HelpTreeNode node = (HelpTreeNode)matchNodes.get(0);
            if (node.url != null) {
                this.updateHistory = true;
                this.highlightSearchString = false;
                this.setHelpPageURL(node.url);
            }
        } else if (size > 1) {
            TopicsFoundDialog tfDialog = new TopicsFoundDialog(this, matchNodes);
            tfDialog.setVisible(true);
            int selectedIndex = tfDialog.getSelectedIndex();
            if (selectedIndex != -1) {
                HelpTreeNode node = (HelpTreeNode)matchNodes.get(selectedIndex);
                if (node.url != null) {
                    this.updateHistory = true;
                    this.highlightSearchString = false;
                    this.setHelpPageURL(node.url);
                }
            }
        } else if (size == 0) {
            this.editorPane.setText(this.noMatchHTML);
        }
    }

    private void loadSelectedHelpPageSearch() {
        HelpTreeNode chosenNode = (HelpTreeNode)this.searchList.getSelectedValue();
        if (chosenNode.url != null) {
            this.updateHistory = true;
            this.highlightSearchString = true;
            this.setHelpPageURL(chosenNode.url);
        }
    }

    private void populateSearchList() {
        String selected = this.searchField.getText();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tocTree.getModel().getRoot();
        ArrayList matchNodes = this.getArrayList(root, selected);
        this.searchList.setListData(matchNodes.toArray());
        if (matchNodes.size() > 0) {
            this.searchDisplayButton.setEnabled(true);
            this.searchList.setSelectedIndex(0);
        } else {
            this.searchDisplayButton.setEnabled(false);
        }
    }

    private static String read(Reader in) throws IOException {
        int nch;
        char[] buff = new char[16384];
        boolean lastWasCR = false;
        StringBuffer sb = new StringBuffer();
        while ((nch = in.read(buff, 0, buff.length)) != -1) {
            int last = 0;
            block5: for (int counter = 0; counter < nch; ++counter) {
                switch (buff[counter]) {
                    case '\r': {
                        if (lastWasCR) {
                            if (counter == 0) {
                                sb.append("\n");
                                continue block5;
                            }
                            buff[counter - 1] = 10;
                            continue block5;
                        }
                        lastWasCR = true;
                        continue block5;
                    }
                    case '\n': {
                        if (!lastWasCR) continue block5;
                        if (counter > last + 1) {
                            sb.append(buff, last, counter - last - 1);
                        }
                        lastWasCR = false;
                        last = counter;
                        continue block5;
                    }
                    default: {
                        if (!lastWasCR) continue block5;
                        if (counter == 0) {
                            sb.append("\n");
                        } else {
                            buff[counter - 1] = 10;
                        }
                        lastWasCR = false;
                    }
                }
            }
            if (last < nch) {
                if (lastWasCR) {
                    if (last < nch - 1) {
                        sb.append(buff, last, nch - last - 1);
                    }
                } else {
                    sb.append(buff, last, nch - last);
                }
            }
            if (!lastWasCR) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setBackButtonIcon(Icon icon) {
        if (this.backButton.getComponentOrientation().isLeftToRight()) {
            this.backButton.setIcon(icon);
        } else {
            this.forwardButton.setIcon(icon);
        }
    }

    public void setBaseURL(URL url) {
        this.baseURL = url;
    }

    public void setContentsTabText(String text) {
        this.tabbedPane.setTitleAt(0, text);
    }

    public void setDisplayButtonText(String text) {
        this.indexDisplayButton.setText(text);
        this.searchDisplayButton.setText(text);
    }

    public void setForwardButtonIcon(Icon icon) {
        if (this.forwardButton.getComponentOrientation().isLeftToRight()) {
            this.forwardButton.setIcon(icon);
        } else {
            this.backButton.setIcon(icon);
        }
    }

    private void setHelpPageURL(URL url) {
        this.clickedOnTOCTree = false;
        if (url == null) {
            this.tocTree.setSelectionRow(0);
            return;
        }
        if ("http".equals(url.getProtocol()) && this.webUrlsInRealBrowser || "ftp".equals(url.getProtocol())) {
            if (!UIUtil.browse(url.toString())) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
            return;
        }
        for (int i = 0; i < this.tocTree.getRowCount(); ++i) {
            DefaultMutableTreeNode temp = (DefaultMutableTreeNode)this.tocTree.getPathForRow(i).getLastPathComponent();
            this.tocTree.expandRow(i);
            HelpTreeNode htn = (HelpTreeNode)temp.getUserObject();
            if (htn.url == null || !htn.url.equals(url)) continue;
            this.tocTree.setSelectionRow(i);
            this.tocTree.scrollRowToVisible(i);
            return;
        }
        ResourceBundle msg = this.getHelpBundle();
        JOptionPane.showMessageDialog(this, msg.getString("PageNotFound"), msg.getString("Error"), 0);
        msg = null;
    }

    public void setIndexTabText(String text) {
        this.tabbedPane.setTitleAt(1, text);
    }

    public void setKeywordFieldLabelText(String text) {
        this.keywordToFindLabel.setText(text);
        this.keywordToFindLabel2.setText(text);
    }

    public void setListTopicsButtonText(String text) {
        this.listTopicsButton.setText(text);
    }

    public void setOpenWebUrlsInRealBrowser(boolean inRealBrowser) {
        this.webUrlsInRealBrowser = inRealBrowser;
    }

    public void setSearchTabText(String text) {
        this.tabbedPane.setTitleAt(2, text);
    }

    public void setTopicToDisplayFieldLabelText(String text) {
        this.topicToDisplayLabel.setText(text);
    }

    private static final boolean validateAttributeNode(Node node, String name) {
        return node != null && node.getNodeType() == 2 && node.getNodeName().equals(name);
    }

    protected class HelpListener
    extends MouseAdapter
    implements ChangeListener,
    HyperlinkListener,
    DocumentListener,
    KeyListener,
    TreeSelectionListener {
        protected HelpListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            HyperlinkEvent.EventType eventType = e.getEventType();
            if (eventType.equals(HyperlinkEvent.EventType.ACTIVATED)) {
                HelpDialog.this.updateHistory = true;
                HelpDialog.this.highlightSearchString = false;
                URL url = e.getURL();
                if (url == null) {
                    try {
                        url = new URL("file://" + HelpDialog.this.baseURL.getPath() + e.getDescription());
                    }
                    catch (MalformedURLException mue) {
                        HelpDialog.this.app.displayException(HelpDialog.this, (Throwable)mue);
                    }
                }
                String anchor = null;
                if (url != null && url.getRef() != null) {
                    anchor = url.getRef();
                    try {
                        String protocol = url.getProtocol();
                        if (protocol == null || protocol.equals("")) {
                            protocol = "file://";
                        }
                        String urlString = "file://" + url.getPath();
                        url = new URL(urlString);
                    }
                    catch (MalformedURLException mue) {
                        mue.printStackTrace();
                    }
                }
                HelpDialog.this.setHelpPageURL(url);
                if (anchor != null) {
                    HelpDialog.this.editorPane.scrollToReference(anchor);
                }
            } else if (eventType.equals(HyperlinkEvent.EventType.ENTERED)) {
                HelpDialog.this.editorPane.setToolTipText(e.getDescription());
            } else if (eventType.equals(HyperlinkEvent.EventType.EXITED)) {
                HelpDialog.this.editorPane.setToolTipText(null);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            Document doc = e.getDocument();
            if (doc.equals(HelpDialog.this.indexField.getDocument())) {
                int closestMatch = HelpDialog.this.indexList.getNextMatch(HelpDialog.this.indexField.getText(), 0, Position.Bias.Forward);
                if (closestMatch != -1) {
                    HelpDialog.this.indexList.setSelectedIndex(closestMatch);
                    HelpDialog.this.indexList.ensureIndexIsVisible(HelpDialog.this.indexList.getSelectedIndex());
                }
            } else if (doc.equals(HelpDialog.this.searchField.getDocument())) {
                HelpDialog.this.listTopicsButton.setEnabled(true);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                Object source = e.getSource();
                if (source.equals(HelpDialog.this.indexField) || source.equals(HelpDialog.this.indexList)) {
                    if (HelpDialog.this.indexList.getSelectedIndex() != -1) {
                        HelpDialog.this.loadSelectedHelpPageIndex();
                    }
                } else if (source.equals(HelpDialog.this.searchField)) {
                    HelpDialog.this.searchString = HelpDialog.this.searchField.getText();
                    if (!HelpDialog.this.searchString.equals("")) {
                        HelpDialog.this.populateSearchList();
                    }
                } else if (source.equals(HelpDialog.this.searchList)) {
                    if (HelpDialog.this.indexList.getSelectedIndex() != -1) {
                        HelpDialog.this.loadSelectedHelpPageSearch();
                    }
                } else if (source.equals(HelpDialog.this.tocTree)) {
                    int row = HelpDialog.this.tocTree.getMaxSelectionRow();
                    if (HelpDialog.this.tocTree.isExpanded(row)) {
                        HelpDialog.this.tocTree.collapseRow(row);
                    } else {
                        HelpDialog.this.tocTree.expandRow(row);
                    }
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getComponent().equals(HelpDialog.this.indexList)) {
                    HelpDialog.this.loadSelectedHelpPageIndex();
                } else if (e.getComponent().equals(HelpDialog.this.searchList)) {
                    HelpDialog.this.loadSelectedHelpPageSearch();
                }
            }
        }

        public void removeUpdate(DocumentEvent e) {
            Document doc = e.getDocument();
            if (doc.equals(HelpDialog.this.indexField.getDocument())) {
                int closestMatch = HelpDialog.this.indexList.getNextMatch(HelpDialog.this.indexField.getText(), 0, Position.Bias.Forward);
                if (closestMatch != -1) {
                    HelpDialog.this.indexList.setSelectedIndex(closestMatch);
                    HelpDialog.this.indexList.ensureIndexIsVisible(HelpDialog.this.indexList.getSelectedIndex());
                }
            } else if (doc.equals(HelpDialog.this.searchField.getDocument()) && doc.getLength() == 0) {
                HelpDialog.this.listTopicsButton.setEnabled(false);
            }
        }

        public void stateChanged(ChangeEvent e) {
            int selection = ((JTabbedPane)e.getSource()).getSelectedIndex();
            JTextField field = null;
            if (selection == 1) {
                field = HelpDialog.this.indexField;
            } else if (selection == 2) {
                field = HelpDialog.this.searchField;
            }
            if (field != null) {
                final JTextField field2 = field;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        field2.requestFocusInWindow();
                        field2.selectAll();
                    }
                });
            }
        }

        public void valueChanged(TreeSelectionEvent tse) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)HelpDialog.this.tocTree.getLastSelectedPathComponent();
            if (selectedNode == null) {
                return;
            }
            HelpTreeNode htn = (HelpTreeNode)selectedNode.getUserObject();
            if (htn.url != null) {
                String contentType = HelpDialog.guessContentType(htn.url.getPath());
                if (!contentType.equals(HelpDialog.this.editorPane.getContentType())) {
                    HelpDialog.this.editorPane.setContentType(contentType);
                    HelpDialog.this.editorPane.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                }
                String allText = HelpDialog.this.getContents(htn);
                Document document = HelpDialog.this.editorPane.getDocument();
                if (document instanceof HTMLDocument) {
                    HTMLDocument htmldoc = (HTMLDocument)document;
                    htmldoc.setBase(HelpDialog.this.baseURL);
                }
                HelpDialog.this.editorPane.setText(allText);
                HelpDialog.this.editorPane.setCaretPosition(0);
                if (HelpDialog.this.updateHistory || HelpDialog.this.clickedOnTOCTree) {
                    while (HelpDialog.this.history.size() - 1 > HelpDialog.this.historyPos) {
                        HelpDialog.this.history.remove(HelpDialog.this.history.size() - 1);
                    }
                    HelpDialog.this.history.add(htn);
                    HelpDialog.this.historyPos++;
                    HelpDialog.this.backButton.setEnabled(true);
                    HelpDialog.this.forwardButton.setEnabled(false);
                }
                HelpDialog.this.clickedOnTOCTree = true;
            }
        }
    }
}

