/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SplashStringWriter {
    private static final ILogger s_log = LoggerController.createLogger(SplashStringWriter.class);
    private SplashScreen _splashScreen;
    private boolean _hasTwoLines;
    private int _maxNumberOffCallsToWriteUpperLine;
    private static final Font FONT = new Font("Dialog", 1, 14);
    private static final Color BG = new Color(171, 176, 195);
    private static final Color FG_UPPER = Color.black;
    private static final Color FG_PROGRESS = new Color(74, 91, 153);
    private static final Color FG_LOWER = new Color(74, 91, 153);
    private static final int X_DIST = 10;
    private static final int Y_DIST = 12;
    private static final int X_PROGRESSBAR = 7;
    private Graphics2D _graphics;
    private int _yUpper;
    private int _yLower;
    private int _numberOffCallsToWriteUpperLine;
    private int _yProgressbar;
    private int _maxWidhtProgressbar;
    private int _heightProgressbar;
    private String _lowerLine;
    private String _upperLine;
    private int _paintAreaHeight;

    public SplashStringWriter(SplashScreen splashScreen, boolean hasTwoLines, int maxNumberOffCallsToWriteUpperLine) {
        this._splashScreen = splashScreen;
        this._hasTwoLines = hasTwoLines;
        this._maxNumberOffCallsToWriteUpperLine = maxNumberOffCallsToWriteUpperLine;
        this._graphics = this._splashScreen.createGraphics();
        this._graphics.setFont(FONT);
        this._yLower = this._splashScreen.getSize().height - 12;
        FontMetrics fontMetrics = this._graphics.getFontMetrics(FONT);
        if (this._hasTwoLines) {
            this._yUpper = this._yLower - fontMetrics.getHeight() - 12;
            this._paintAreaHeight = 2 * (12 + fontMetrics.getHeight());
        } else {
            this._yUpper = this._yLower;
            this._paintAreaHeight = 12 + fontMetrics.getHeight();
        }
        this._yProgressbar = this._yUpper - fontMetrics.getHeight() - 2;
        this._maxWidhtProgressbar = this._splashScreen.getSize().width - 20;
        this._heightProgressbar = fontMetrics.getHeight() + 10;
        this._graphics.setColor(FG_UPPER);
        this.paintCopyrigthAndVersion(fontMetrics);
    }

    private void paintCopyrigthAndVersion(FontMetrics fontMetrics) {
        String[] splits = Version.getCopyrightStatement().split("\\n");
        int xVers = (this._splashScreen.getSize().width - fontMetrics.getStringBounds((String)Version.getVersion(), (Graphics)this._graphics).getBounds().width) / 2;
        int yVers = this._splashScreen.getSize().height - (this._paintAreaHeight + (splits.length + 1) * (fontMetrics.getHeight() + 5));
        this._graphics.drawString(Version.getVersion(), xVers, yVers);
        for (int i = 0; i < splits.length; ++i) {
            int xSpilt = (this._splashScreen.getSize().width - fontMetrics.getStringBounds((String)splits[i], (Graphics)this._graphics).getBounds().width) / 2;
            int ySplit = this._splashScreen.getSize().height - (this._paintAreaHeight + (splits.length - i) * (fontMetrics.getHeight() + 5));
            this._graphics.drawString(splits[i], xSpilt, ySplit);
        }
    }

    public void writeUpperProgressLine(String s) {
        this._upperLine = s;
        ++this._numberOffCallsToWriteUpperLine;
        this.paint();
    }

    public void writeLowerProgressLine(String s) {
        this._lowerLine = s;
        this.paint();
    }

    private void paint() {
        this.clear();
        this.paintProgress();
        this.paintStrings();
    }

    private void paintStrings() {
        this.write(this._upperLine, this._yUpper, FG_UPPER);
        if (this._hasTwoLines) {
            this.write(this._lowerLine, this._yLower, FG_LOWER);
        }
    }

    private void paintProgress() {
        if (this._maxNumberOffCallsToWriteUpperLine < this._numberOffCallsToWriteUpperLine + 1) {
            String msg = "Programmer: Please increase _maxNumberOffCallsToWriteUpperLine to make the Progressbar work right";
            s_log.error(msg, new IllegalStateException(msg));
            this._numberOffCallsToWriteUpperLine = this._maxNumberOffCallsToWriteUpperLine;
        }
        int width = (int)((double)this._maxWidhtProgressbar * (double)this._numberOffCallsToWriteUpperLine / (double)this._maxNumberOffCallsToWriteUpperLine);
        this._graphics.setColor(FG_PROGRESS);
        this._graphics.fillRect(7, this._yProgressbar, width, this._heightProgressbar);
    }

    private void clear() {
        this._graphics.setColor(BG);
        this._graphics.fillRect(0, this._splashScreen.getSize().height - this._paintAreaHeight, this._splashScreen.getSize().width, this._paintAreaHeight);
    }

    private String write(String s, int y, Color fg) {
        if (null != s) {
            this._graphics.setColor(fg);
            this._graphics.drawString(s, 10, y);
            this._splashScreen.update();
        }
        return s;
    }
}

