/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.RenderingHints;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.LinkedList;
import java.util.List;

public class SketchifiedImage
extends Image {
    private BufferedImage sketch = null;
    private final List<ImageObserver> observers = new LinkedList<ImageObserver>();
    private static final RenderingHints hints = new RenderingHints(null);
    private static final BandCombineOp invertOp;
    private static final ConvolveOp blurOp;

    public SketchifiedImage(Image image) {
        this.sketch = SketchifiedImage.sketchify(image);
        if (this.sketch == null) {
            MyImageObserver observer = new MyImageObserver();
            this.getGraphics().drawImage(image, 0, 0, observer);
        }
    }

    private static Raster findEdge(Raster alpha, Raster src, WritableRaster dst) {
        WritableRaster invRtr = invertOp.filter(src, null);
        invRtr = blurOp.filter(invRtr, null);
        int width = invRtr.getWidth();
        int height = invRtr.getHeight();
        if (dst == null) {
            dst = Raster.createBandedRaster(0, width, height, 1, null);
        }
        int[] srcVal = new int[1];
        int[] invVal = new int[1];
        int[] alphaVal = new int[1];
        int[] retVal = new int[1];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                src.getPixel(x, y, srcVal);
                invRtr.getPixel(x, y, invVal);
                alpha.getPixel(x, y, alphaVal);
                float c = (float)(srcVal[0] + invVal[0]) / 255.0f;
                c = Math.max(0.0f, Math.min(1.0f, (c - 0.9f) / 0.1f));
                c *= c;
                retVal[0] = (int)((float)alphaVal[0] * (1.0f - c));
                dst.setPixel(x, y, retVal);
            }
        }
        return dst;
    }

    static BufferedImage sketchify(Image origImage) {
        int x;
        int y;
        int width = origImage.getWidth(null);
        int height = origImage.getHeight(null);
        if (width < 0 || height < 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics g = image.getGraphics();
        ((Graphics2D)g).setRenderingHints(hints);
        g.drawImage(origImage, 0, 0, null);
        WritableRaster imageRtr = image.getRaster();
        WritableRaster alphaRtr = image.getAlphaRaster();
        WritableRaster bands = Raster.createBandedRaster(0, width, height, 4, null);
        int[] bandList = new int[1];
        int i = 0;
        while (i < 4) {
            bandList[0] = i++;
            WritableRaster imageBand = imageRtr.createWritableChild(0, 0, width, height, 0, 0, bandList);
            WritableRaster band = bands.createWritableChild(0, 0, width, height, 0, 0, bandList);
            SketchifiedImage.findEdge(alphaRtr, imageBand, band);
        }
        BufferedImage edgeImage = new BufferedImage(width, height, 2);
        alphaRtr = edgeImage.getAlphaRaster();
        int[] pixel = new int[4];
        int[] alpha = new int[1];
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                bands.getPixel(x, y, pixel);
                int a = pixel[0];
                a = Math.max(a, pixel[1]);
                a = Math.max(a, pixel[2]);
                alpha[0] = a = Math.max(a, pixel[3]);
                alphaRtr.setPixel(x, y, alpha);
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                imageRtr.getPixel(x, y, pixel);
                pixel[0] = pixel[0] & 0xE0 | 0x1F;
                pixel[1] = pixel[1] & 0xE0 | 0x1F;
                pixel[2] = pixel[2] & 0xC0 | 0x3F;
                imageRtr.setPixel(x, y, pixel);
            }
        }
        g.drawImage(edgeImage, 0, 0, null);
        return image;
    }

    public int getWidth(ImageObserver observer) {
        if (this.sketch == null) {
            if (observer != null && !this.observers.contains(observer)) {
                this.observers.add(observer);
            }
            return -1;
        }
        return this.sketch.getWidth(observer);
    }

    public int getHeight(ImageObserver observer) {
        if (this.sketch == null) {
            if (observer != null && !this.observers.contains(observer)) {
                this.observers.add(observer);
            }
            return -1;
        }
        return this.sketch.getHeight(observer);
    }

    public ImageProducer getSource() {
        return this.sketch == null ? null : this.sketch.getSource();
    }

    public Graphics getGraphics() {
        return this.sketch == null ? new BufferedImage(1, 1, 2).getGraphics() : this.sketch.getGraphics();
    }

    public Object getProperty(String name, ImageObserver observer) {
        return this.sketch.getProperty(name, observer);
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration gc) {
        return this.sketch == null ? super.getCapabilities(gc) : this.sketch.getCapabilities(gc);
    }

    public Image getScaledInstance(int width, int height, int hints) {
        return this.sketch == null ? null : this.sketch.getScaledInstance(width, height, hints);
    }

    public float getAccelerationPriority() {
        return this.sketch == null ? super.getAccelerationPriority() : this.sketch.getAccelerationPriority();
    }

    public void flush() {
        if (this.sketch != null) {
            this.sketch.flush();
        }
    }

    static {
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        invertOp = new BandCombineOp(new float[][]{{-1.0f, 255.0f}}, hints);
        blurOp = new ConvolveOp(new Kernel(3, 3, new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f}), 1, hints);
    }

    private class MyImageObserver
    implements ImageObserver {
        private MyImageObserver() {
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            SketchifiedImage.this.sketch = SketchifiedImage.sketchify(img);
            SketchifiedImage.this.sketch.setAccelerationPriority(SketchifiedImage.this.getAccelerationPriority());
            return true;
        }
    }
}

