/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matt Chapman, matt@belgarath.demon.co.uk
 *    Nov 1994.
 */

/* main.c - the main function */

#include "scrab.h"
#include "globals.h"

#include "xscrabble.xpm"
#include "slate_green.xpm"

/* option types and default values */
static XtResource resources[] =
{
	{"version","Version",XtRInt,sizeof(int),XtOffsetOf(struct AppData,version),
		XtRImmediate,(XtPointer) 0},
	{"load","Load",XtRBoolean,sizeof(Boolean),XtOffsetOf(struct AppData,load),
		XtRImmediate,(XtPointer) False},
	{"players","Players",XtRInt,sizeof(int),XtOffsetOf(struct AppData,players),
		XtRImmediate,(XtPointer) 1},
	{"time","Time",XtRInt,sizeof(int),XtOffsetOf(struct AppData,timelim),
		XtRImmediate,(XtPointer) 0},
	{"d1","D1",XtRString,sizeof(String),XtOffsetOf(struct AppData,disp[0]),
		XtRImmediate,":0.0"},
	{"d2","D2",XtRString,sizeof(String),XtOffsetOf(struct AppData,disp[1]),
		XtRImmediate,":0.0"},
	{"d3","D3",XtRString,sizeof(String),XtOffsetOf(struct AppData,disp[2]),
		XtRImmediate,":0.0"},
	{"d4","D4",XtRString,sizeof(String),XtOffsetOf(struct AppData,disp[3]),
		XtRImmediate,":0.0"},
	{"n1","N1",XtRString,sizeof(String),XtOffsetOf(struct AppData,name[0]),
		XtRImmediate,"Player 1"},
	{"n2","N2",XtRString,sizeof(String),XtOffsetOf(struct AppData,name[1]),
		XtRImmediate,"Player 2"},
	{"n3","N3",XtRString,sizeof(String),XtOffsetOf(struct AppData,name[2]),
		XtRImmediate,"Player 3"},
	{"n4","N4",XtRString,sizeof(String),XtOffsetOf(struct AppData,name[3]),
		XtRImmediate,"Player 4"},
	{"t1","T1",XtRInt,sizeof(int),XtOffsetOf(struct AppData,t[0]),
		XtRImmediate,(XtPointer) 0},
	{"t2","T2",XtRInt,sizeof(int),XtOffsetOf(struct AppData,t[1]),
		XtRImmediate,(XtPointer) 0},
	{"t3","T3",XtRInt,sizeof(int),XtOffsetOf(struct AppData,t[2]),
		XtRImmediate,(XtPointer) 0},
	{"t4","T4",XtRInt,sizeof(int),XtOffsetOf(struct AppData,t[3]),
		XtRImmediate,(XtPointer) 0},
	{"dictfile","Dictfile",XtRString,sizeof(String),
	 XtOffsetOf(struct AppData,dictfile),XtRImmediate,
	 "/usr/local/lib/OSPD3"},
	{"permfile","Permfile",XtRString,sizeof(String),
	 XtOffsetOf(struct AppData,permfile),XtRImmediate,
	 "/usr/local/lib/scrabble_permutations"},
	{"scorefile","Scorefile",XtRString,sizeof(String),
	 XtOffsetOf(struct AppData,scorefile),XtRImmediate,
	 "/usr/local/lib/xscrabble.scores"},
};

/* resource options */
static XrmOptionDescRec options[] =
{
        {"-load",     	 "*load",        XrmoptionNoArg, "True" },
        {"-players",     "*players",     XrmoptionSepArg, NULL  },
        {"-time",     	 "*time",        XrmoptionSepArg, NULL  },
        {"-d1",      	 "*d1",          XrmoptionSepArg, NULL  },
        {"-d2",      	 "*d2",          XrmoptionSepArg, NULL  },
        {"-d3",      	 "*d3",          XrmoptionSepArg, NULL  },
        {"-d4",      	 "*d4",          XrmoptionSepArg, NULL  },
        {"-n1",      	 "*n1",          XrmoptionSepArg, NULL  },
        {"-n2",      	 "*n2",          XrmoptionSepArg, NULL  },
        {"-n3",      	 "*n3",          XrmoptionSepArg, NULL  },
        {"-n4",      	 "*n4",          XrmoptionSepArg, NULL  },
        {"-t1",      	 "*t1",          XrmoptionSepArg, NULL  },
        {"-t2",      	 "*t2",          XrmoptionSepArg, NULL  },
        {"-t3",      	 "*t3",          XrmoptionSepArg, NULL  },
        {"-t4",      	 "*t4",          XrmoptionSepArg, NULL  },
        {"-dictfile",  	 "*dictfile",    XrmoptionSepArg, NULL  },
        {"-permfile",  	 "*permfile",    XrmoptionSepArg, NULL  },
        {"-scorefile", 	 "*scorefile",   XrmoptionSepArg, NULL  },
};

void main(int argc, char **argv)
{
	char defaultname[MAXPLAYERS][NAMELEN];
	int i;
	Widget topLevel;
	Boolean any_comp=False;

	topLevel = XtVaAppInitialize(&app_context,"XScrabble",options,XtNumber(options),
		&argc,argv,NULL,NULL);

	XtVaGetApplicationResources(topLevel,&app_data,resources,
		XtNumber(resources),NULL);

	if (app_data.version != VERSION)
	{
		fprintf(stderr,"Couldn't find resource file XScrabble.\n");
		exit(1);
	}
	
	for (i=0; i<MAXPLAYERS; i++)
		type[i]=app_data.t[i];
	
	num_players=app_data.players;
	time_limit=app_data.timelim;

	for (i=0; i<num_players; i++)
	{
		dpy[i] = XtOpenDisplay(app_context,app_data.disp[i],argv[0],"XScrabble",
			NULL,0,&argc, argv); 
		if (dpy[i] == NULL)
		{
			printf("Can't open display %s\n",app_data.disp[i]);
			exit(1);
		}
		strcpy(defaultname[i],app_data.name[i]);
		
		/* check for any computer players */
		if (app_data.t[i]>0)
		    any_comp=True;
	}

	loaddict();
	if (any_comp)
	    makeperm(perms,numperms);

	clearboard(cboard);
	clearboard(board);
	makebag();
	shufflebag();
	playersetup(defaultname);

	for (i=0; i<num_players; i++)
	{
		topl[i] =  XtVaAppCreateShell("topl","XScrabble",
			applicationShellWidgetClass,dpy[i],NULL);

		XtVaSetValues(topl[i],XtNtitle,player[i].name,NULL);
		load_data_pixmap(slate_green_xpm,&bgxpm,topl[i]);

		set_board(topl[i],i);
		set_icon_pixmap(xscrabble_xpm,topl[i]);
		acceptQuitPre(topl[i]);
		XtRealizeWidget(topl[i]);
		acceptQuitPost(topl[i]);
	}

	for (i=0; i<num_players; i++)
		XDefineCursor(dpy[i],XtWindow(topl[i]),
			XCreateFontCursor(dpy[i],XC_left_ptr));


	/* select starting player */
	curr_player=rand()%num_players;

	if (app_data.load)
	{
		loadgame();
		curr_player=(curr_player==0) ? (num_players-1) : (curr_player-1);
	}
		
	for (i=0; i<num_players; i++)
		ShowBar(i);
	ShowScores();

	TilesLeft();
	MessageAll("Starting game");
	GotoNextPlayer();

	for (i=0; i<num_players; i++)
		ShowBar(i);
	ShowTiles();
	ShowBoard(False);
	
	XtAppMainLoop(app_context);
}

