/*
 * Copyright (c) 1997, 2000, Mark Buser.
 * Copyright (c) 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/util.h,v 1.4 2003/11/19 19:35:13 danny Exp $
 */
#ifndef util_h
#define util_h

void syntax(int argc, char **argv);
int path_length();

#ifdef XQUOTE

#else /* Xinvest */
void removeFileOption ( int *, char **);  /* Remove -f from passed argc/argv */
void processFileOption ( int, char **);   /* Load -f files from argc/argv */

#define UTILCURR 1                        /* Print as currency */
#define UTILNUM  0                        /* Print as non-currency */
char *utilCurrOut (double, int);          /* Change double to string, int is
                                             currency flag. */
char *utilDateOut (long);                 /* Change long to string */

#endif

#ifdef NeXT
#include <stdlib.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include <strings.h>
#include <sys/dir.h>
#include <sys/param.h>
#define S_ISDIR(mode) (((mode) & 0170000) == 0040000)

char *getcwd (char *, size_t);
char *strdup( const char *);
#endif

#ifdef NEED_STRCASECMP
int strcasecmp (char *, char *);
int strncasecmp (char *, char *, int);
#endif 

#if defined (NEED_STRPTIME)
char *strptime ( char *, char *, struct tm *);
#endif

#endif
