/*
 * Copyright (c) 1997, 2000, Mark Buser.
 * Copyright (c) 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/server.h,v 1.9 2004/12/11 17:33:24 danny Exp $
 */
#ifndef SERVER_H
#define SERVER_H

enum detail_types {
	DETAIL_TITLE = 0,
	DETAIL_URL,
	DETAIL_PRICE,
	DETAIL_CHANGE,
	DETAIL_VOLUME,
	DETAIL_DAILYL,
	DETAIL_DAILYH,
	DETAIL_EXDIV,
	DETAIL_L52,
	DETAIL_H52,
	DETAIL_PE,
	DETAIL_DIV,
	DETAIL_YIELD,
	DETAIL_DATE,
	DETAIL_TIME,
	DETAIL_NAME,
	DETAIL_WEBSERVER,
	DETAIL_TICKER_TYPE,
	DETAIL_SYMBOL,
	DETAIL_TRIGGER_LOW,
	DETAIL_TRIGGER_HIGH,
	/* This must remain the last entry : */
	DETAIL_NUM_QUERY_VALUES
};

typedef struct query_struct {
  char *values[DETAIL_NUM_QUERY_VALUES];
} QUERY_STRUCT;

typedef struct server_struct {
  char *title;
  int num_types;
  QUERY_STRUCT **types;
} SERVER_STRUCT;

#define NEWS  -1              /* Server number for news */

int readServerDatabase(Widget, char *);
void setCurServer (int);
int getCurServer ();
void setCurServerType (int);
char *getServerTitle (int);
char *getServerType (int, int);
char *getServer (int);
int numServer ();
int numCurServerType ();
void serverCB (Widget, XtPointer, XtPointer);

void getProxy ( char **, int *);
void setProxy ( char *, char *);

/*
 * Access functions that don't use a "current" server or type.
 */
extern int ServerSetProperty(int server, int tp, int what, char *value);
extern char *ServerGetProperty(int server, int tp, int what);
extern int numServerTypes(int srv);
#endif
