/*
 * Copyright (c) 1997, 1999, 2000, Mark Buser.
 * Copyright  2001, 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/optdetail.c,v 1.40 2004/12/27 08:38:56 danny Exp $
 */
#undef	DEBUG

#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <Xm/XmAll.h>
#include <Xbae/Matrix.h>

#include "fileXq.h"
#include "optnet.h"
#include "optdetail.h"
#include "opttick.h"
#include "pixmap.h"
#include "server.h"
#include "status.h"
#include "tape.h"
#include "xquote.h"
#include "xutil.h"
#include "optupdate.h"

/* Globals */
static Widget checkbox;  /* toggles of current state */
static int state = 0;    /* state of detail toggle buttons */

int ColumnToField(int c);
int FieldToColumn(int f);

/*
 * This array holds the data to be displayed.
 *
 * The data in this array are mapped 1-to-1 with the XbaeMatrix, so hidden columns
 * aren't in this array.
 *
 * Note that this is different for data->values !
 */
static char	***MatrixData = NULL;
static int	v_nrows = 0, v_ncols = 0;

/*
 * The dimensions of the XbaeMatrix and the 'helper' arrays.
 */
extern Widget	Container;
int		nrows = 0, ncols = -1;
short	*column_widths = NULL;
char	**column_labels = NULL;
static int	xbae_field[DETAIL_NUM_QUERY_VALUES];
static int	xbae_nfields = 0;

/*
** Detail option support
*/

static void ChangeState(int which, int nfields)
{
	int	i;

	if (! column_widths)
		column_widths = (short *)XtCalloc(sizeof(short), DETAIL_NUM_QUERY_VALUES+1);

	if (ncols < 0) {
		XtVaGetValues(Container, XmNcolumns, &ncols, NULL);
	}

	/*
	 * NFIELDS is the number of user-selected fields.
	 * NCOLS is the number of columns in the XbaeMatrix.
	 * NCOLS should be NFIELS+2 to account for the up/down arrows and the ticker
	 */
	if (nfields + 2 != ncols) {
		/* Change XbaeMatrix #columns */
		column_widths[0] = 3;	/* special case, for the pixmaps */
		for (i=1; i<=DETAIL_NUM_QUERY_VALUES; i++)
			column_widths[i] = 1;

		if (nfields+2 < ncols) {
			/* Remove columns */
			int	d = -(nfields + 2 - ncols);
			XbaeMatrixDeleteColumns(Container, 0, d);
			ncols -= d;
		} else if (ncols < nfields+2) {
			/* Add columns */
			short	*wp = NULL;
			int	d = nfields + 2 - ncols;

			wp = (short *)XtCalloc(d, sizeof(short));
			for (i=0; i<d; i++)
				wp[i] = 3;
			XbaeMatrixAddColumns(Container, 0, NULL, NULL, wp, NULL,
				NULL, NULL, NULL, d);
			ncols += d;
			xbae_nfields += d;
			XtFree((char *)wp);

#if 0
			FreeValuesArray();
#endif
		}

		state = (which == 0) ? 1 : 0;	/* To make the test below succeed */
	}
	if (state != which) {
		/* Other fields to display */
		/* FIX ME */
	}

	state = which;
}

static void ChangeNumRows(int count)
{
	int	i;

	if (v_nrows <= count) {
		i = v_nrows;
		v_nrows = count;
		MatrixData = (char ***)XtRealloc((char *)MatrixData,
					sizeof(char **) * (v_nrows));
		for (; i < v_nrows; i++)
			MatrixData[i] = (char **)XtCalloc(DETAIL_NUM_QUERY_VALUES, sizeof(char *));
	}

	if (! column_labels) {
		column_labels = (char **) XtCalloc(sizeof(char *), DETAIL_NUM_QUERY_VALUES + 1);
		for (i=0; i<DETAIL_NUM_QUERY_VALUES+1; i++) {
			column_labels[i] = strdup("");
		}
	}
	if (! column_widths) {
		column_widths = (short *)XtCalloc(sizeof(short), DETAIL_NUM_QUERY_VALUES + 1);
		column_widths[0] = 3;
		for (i=0; i<DETAIL_NUM_QUERY_VALUES+1; i++) {
			column_widths[i] = 5;	/* FIX ME */
		}
	}

	nrows = count;
	XtVaSetValues(Container,
		XmNvisibleRows,			50,
		XmNrows,			nrows,
		XmNcolumns,			ncols,
		XmNrowLabels,			NULL,
		XmNcolumnLabels,		column_labels,
		XmNcolumnWidths,		column_widths,
		XmNcolumnAlignments,		NULL,
		XmNcolumnLabelAlignments,	NULL,
		XmNcolumnMaxLengths,		NULL,
		XmNcolumnFontBold,		NULL,
		XmNcolumnButtonLabels,		NULL,
		XmNshowColumnArrows,		NULL,
		NULL);
}

/* ARGSUSED */
void popupDetailCB( Widget w, XtPointer menu_pos, XtPointer call)
{
	int ticknum;
	char *url;
	int status;
	long item_id;
	XmString labelXm;

	switch ((int)menu_pos) {
	case 0: /* Copy URL to clipboard  */
		XtVaGetValues (XtParent(w), XmNuserData, &ticknum, NULL);
		/* If this isn't a valid ticker, bail */
		if ((ticknum<0) || (ticknum>tickGetNum())) 
			break;

		url = makeQuery (1, ticknum);
		url = strtok (url, " ");       /* Skip GET */
		url = strtok (NULL, " ");      /* Truncate at end of URL */

		/* First the Motif way using the CLIPBOARD */
		labelXm = XmStringCreateLocalized ("Xquote");
		do {
			status = XmClipboardStartCopy (XtDisplayOfObject(w), 
				XtWindowOfObject(w), labelXm,
				CurrentTime, NULL, NULL, &item_id);
		} while (status == ClipboardLocked);
		XmStringFree(labelXm);

		do {
			status = XmClipboardCopy (XtDisplayOfObject(w), XtWindowOfObject(w),
					item_id, "STRING", url, strlen(url)+1, 0L, NULL);
		} while (status == ClipboardLocked);

		do {
			status = XmClipboardEndCopy(XtDisplayOfObject(w),
					XtWindowOfObject(w), item_id);
		} while (status == ClipboardLocked);

		/* Now the Xt way using the PRIMARY selection */
		break;

	case 1:	/* Move up */
		MoveUp(CurrentRow);
		break;
	case 2:	/* Move down */
		MoveDown(CurrentRow);
		break;
	case 3:	/* Insert item before */
		InsertItem(CurrentRow);
		break;
	case 4:	/* Insert item after */
		InsertItem(CurrentRow + 1);
		break;
	case 5:	/* Update from network now */
		triggerUpdate (TRIGGER_REFRESH, (XtIntervalId)NULL);
		break;
	case 6:	/* Live Update - i.e. feed the info to Xinvest */
		workNet(7);
		break;
	default:
		fprintf(stderr, "Popup menu posted : item #%d, Row %d\n",
				(int)menu_pos, CurrentRow);
		break;
	}
}

/*
 * This function gets called by the Details dialog.
 * We're now supposed to figure out which fields the user wants to display.
 */
/* Set which detail variables are selected. */
void detailSetState( int which )
{
  WidgetList children;
  int numChild = 0;
  int i, j;

#undef	XX_1
  if (checkbox)
    XtVaGetValues ( checkbox, XmNchildren, &children,
  		              XmNnumChildren, &numChild,
  		    NULL);
  for (i=0, xbae_nfields=0; i < numChild; i++) {
    XmToggleButtonSetState ( children[i], 
		             (which & (1 << i))?XmSET:XmUNSET, 
			     False);
    if (which & (1 <<i)) {
	xbae_field[i] = xbae_nfields++;
    } else {
	xbae_field[i] = -1;
    }
  }
  ChangeState(which, xbae_nfields);
}

/* Non-zero if state variable 'which' is selected, otherwise entire state. */
int detailGetState( int which )
{
	if (which == -1)
		return (state);
	else
		return (state & (1 << which));
}

void DrawCellCB(Widget w, XtPointer client, XtPointer call)
{
	XbaeMatrixDrawCellCallbackStruct *cbp = (XbaeMatrixDrawCellCallbackStruct *)call;

#if 0
	if (cbp->row == 4 || cbp->row == 5)
		fprintf(stderr, "DrawCellCB(%d,%d) -> %s\n",
			cbp->row, cbp->column, 
			MatrixData ? MatrixData[cbp->row][cbp->column] : "");
#endif
	if (cbp->row >= v_nrows || cbp->column >= v_ncols)
		return;

	if (cbp->column == 0) {
		cbp->pixmap = (Pixmap)XbaeMatrixGetCellUserData(Container, cbp->row, cbp->column);
		if (cbp->pixmap) {
			cbp->type = XbaePixmap;
			cbp->width = cbp->height = 16;
		} else {
			cbp->type = XbaeString;
			cbp->string = "";
		}
	} else {
		cbp->type = XbaeString;
		cbp->string = MatrixData ? MatrixData[cbp->row][cbp->column] : "";
	}
}

static void FreeValuesArray(void)
{
	int	i, j;

	if (MatrixData == NULL)
		return;
	for (i=0; i<v_nrows; i++) {
		for (j=0; j<v_ncols; j++) {
			if (MatrixData[i][j]) {
				XtFree(MatrixData[i][j]);
				MatrixData[i][j] = NULL;	/* Be thorough */
			}
		}
		XtFree((char *)MatrixData[i]);
		MatrixData[i] = NULL;
	}
	XtFree((char *)MatrixData);
	MatrixData = NULL;
}

/* Change main window detail values to match net data */
void detailUpdateMainWindow(int refresh)
{
	extern Widget Container, Scroll;
	Widget NewContainer, popupDetail;

	Widget Item, Pix, w;
	char name[12];
	char * TickString;
	XmString details[DETAIL_NUM_QUERY_VALUES];
	int num_details = 0;
	Pixmap pixmap;

	FILE *fp = getLogFilePointer();     /* File to log to if enabled */
	int fFormat = getLogFileFormat();   /* Format to log with        */
	int some_data, nrows, ncols;
	Widget p = XtParent(Container);
	int	do_resize = 0;

	int i, j, count;

	if (!Container)
		return;

	if (refresh == DETAIL_EDIT)         /* On detail option change, don't log */
		fp = 0;

	AllowShellResize (per->Toplevel, ALLOW);

#ifdef	TOGGLE_REDISPLAY
	XbaeMatrixDisableRedisplay(Container);
#endif

	count = tickGetNum();
	XtVaGetValues(Container, XmNrows, &nrows, XmNcolumns, &ncols, NULL);
	if (! MatrixData) {
		/* Allocate array */
		v_nrows = (count < 5) ? 5 : count;
		MatrixData = (char ***)XtCalloc(v_nrows, sizeof(char **));
		for (i=0; i<v_nrows; i++) {
			MatrixData[i] = (char **)XtCalloc(DETAIL_NUM_QUERY_VALUES, sizeof(char *));
		}
		v_ncols = xbae_nfields + 2;
	}
	ChangeState(state, ncols - 2);
	ChangeNumRows((count < 5) ? 5 : count);

	for (i=0; i < count; i++) {
		/*
		** Fill in detail information.
		*/
		QUERY_STRUCT *data;

		data = tickGetDetail(i);
		TickString = tickGetNickName(i) ? tickGetNickName(i) : tickGetName(i);
#ifdef DEBUG
		fprintf(stderr, "detailUpdateMainWindow %d (nick %s name %s)\n",
				i,
				tickGetNickName(i),
				tickGetName(i));
#endif

		XbaeMatrixSetCell(Container, i, 1, TickString);
		MatrixData[i][0] = NULL;
		if (MatrixData[i][1])
			XtFree(MatrixData[i][1]);
		MatrixData[i][1] = strdup(TickString);		/* LEAK */

		if (column_widths[1] < strlen(TickString))
			column_widths[1] = strlen(TickString) + 1;

		/* Draw a pixmap in the first column */
		if (!data || data->values[DETAIL_CHANGE] == NULL) {
			pixmap = GetPixmap(PERROR, NORMAL, XtDisplay(per->Toplevel));
		} else if (strchr (data->values[DETAIL_CHANGE], '-')) {
			pixmap = GetPixmap(PDOWN, NORMAL, XtDisplay(per->Toplevel));
		} else {
			pixmap = GetPixmap(PUP, NORMAL, XtDisplay(per->Toplevel));
		}
		XbaeMatrixSetCellUserData(Container, i, 0, (XtPointer)pixmap);

		/* Loop over selected detail info filling it in */
		num_details = 0;
		some_data = 0;

		for (j=DETAIL_PRICE; j < DETAIL_NUM_QUERY_VALUES; j++) {
			char tmp[13] = "N/A";

			if (detailGetState(j-DETAIL_PRICE)) {
				if (j == DETAIL_WEBSERVER) {
					sprintf(tmp, "%s", getServerTitle(tickGetServer(i)));
				} else if (j == DETAIL_TICKER_TYPE) {
					int	t = tickGetType(i),
						s = tickGetServer(i);
					sprintf(tmp, "%s", getServerType(s,t));
				} else if (j == DETAIL_SYMBOL) {
					sprintf(tmp, "%s", tickGetName(i));
				} else if (j == DETAIL_TRIGGER_LOW) {
					char	*s = tickGetLowTrigger(i);
					strcpy(tmp, s ? s : "");
				} else if (j == DETAIL_TRIGGER_HIGH) {
					char	*s = tickGetHighTrigger(i);
					strcpy(tmp, s ? s : "");
				} else if (data && data->values[j]) {
					if (j == DETAIL_VOLUME || j == DETAIL_EXDIV
							|| j == DETAIL_DATE || j == DETAIL_TIME
							|| j == DETAIL_NAME )
						sprintf ( tmp, "%-.12s", data->values[j]);
					else
						sprintf ( tmp, "%.12s", data->values[j]);
					some_data = 1;
				}
				if (xbae_field[j-2] >= 0) {
					XbaeMatrixSetCell(Container, i, 2+xbae_field[j-2], tmp);
					if (MatrixData[i][2+xbae_field[j-2]]) {
						XtFree(MatrixData[i][2+xbae_field[j-2]]);
						MatrixData[i][2+xbae_field[j-2]] = NULL;
					}
					MatrixData[i][2+xbae_field[j-2]] = strdup(tmp);
				}
				if (column_widths[2+xbae_field[j-2]] < strlen(tmp))
					column_widths[2+xbae_field[j-2]] = strlen(tmp) + 1;

				/* 
				** File Logging
				*/
				if (fp) { /* Log to file */
					char datebuf[40];
					time_t t = time ((time_t *)NULL);
					struct tm *today = localtime (&t);

					if (fFormat) { /* Xinvest format */
						strftime (datebuf, 40, "%m/%d/%Y", today);
						if (j==DETAIL_PRICE && strcmp(tmp, "N/A") != 0)
							fprintf (fp, "# %s\n%s\tPrice\t%s",
								tickGetName(i), datebuf, tmp);

					} else {       /* CSV format */
						strftime (datebuf, 40, "%c", today);
						if (j==DETAIL_PRICE)
							fprintf (fp, "%s; %s; ", datebuf,
									tickGetName(i));
						fprintf (fp, "%s; ", tmp);
					}
				}

			} /* if detail on */
		} /* for all details */
		if (fp && some_data) {
			fprintf (fp, "\n");
			fflush (fp);
		}
	}
	for (i=1; i < ncols; i++) {
		if (column_widths[i] < strlen(column_labels[i])+1)
		column_widths[i] = strlen(column_labels[i])+1;
#if 0
		fprintf(stderr, "Column %d is %d wide(%s)\n",
				i, column_widths[i], column_labels[i]);
#endif
	}
	XtVaSetValues(Container,
		XmNcolumnWidths,	column_widths,
		NULL);

#ifdef	TOGGLE_REDISPLAY
	XbaeMatrixEnableRedisplay(Container, True);
#endif

	/* Show the time of last update */
	{
		time_t t = time ( (time_t *)NULL ); 
		struct tm *now = localtime(&t);
		char line[80];
		strftime(line, sizeof(line), "Last update : %x %X", now);
		write_lastupdate_line(line);
	}
}

void detailSetHeading ( XmStringTable headings, int num_headings )
{
	int i, m;

	if (! column_widths)
		column_widths = (short *)XtCalloc(sizeof(short), DETAIL_NUM_QUERY_VALUES+1);
	if (! column_labels)
		column_labels = (char **)XtCalloc(sizeof(char *), (DETAIL_NUM_QUERY_VALUES + 1));

	column_widths[0] = 3;	/* special case, for the pixmaps */
	for (i=1; i<DETAIL_NUM_QUERY_VALUES+1; i++)
		column_widths[i] = 1;

	ChangeState(state, num_headings-1);

	for (i=0; i<=DETAIL_NUM_QUERY_VALUES; i++)
		column_labels[i] = strdup("");
	for (i=0; i < num_headings; i++) {
		char *s = NULL;
		if (XmStringGetLtoR(headings[i], XmFONTLIST_DEFAULT_TAG, &s)) {
			XbaeMatrixSetColumnLabel(Container, i+1, s);
			if (column_labels[i+1])
				XtFree(column_labels[i+1]);
			column_labels[i+1] = /* strdup */ (s);
			/* XtFree(s); */
			if (column_widths[i+1] < strlen(s))
				column_widths[i+1] = strlen(s) + 1;
#if 0
			fprintf(stderr, "Heading[%d,%s] width %d\n", i+1, s, column_widths[i+1]);
#endif
		}
	}

	XtVaSetValues(Container,
		XmNcolumnWidths,	column_widths,
		NULL);
}

/* Change main window detail list to match state */
void detailAddMainWindow ()
{
	extern Widget checkbox;
	WidgetList children;
	int numChild;

	XmStringTable headings;
	int nh = 0;
	int i;

	AllowShellResize (per->Toplevel, ALLOW);

	/*
	** Get detail box labels
	*/
	XtVaGetValues ( checkbox, XmNchildren, &children,
		XmNnumChildren, &numChild,
		NULL);
	headings = (XmStringTable) XtMalloc((numChild+1) * sizeof(XmString));
	if (headings == (XmStringTable)NULL)
		write_status ("Could not allocate memory, detail list not changed.", ERR);

	headings[nh++] =  XmStringCreateLocalized("Ticker");
	for (i=0; i < numChild; i++) {
		if ( state & (1<<i) )
			XtVaGetValues(children[i], XmNlabelString, &(headings[nh++]), NULL);
	}

	/*
	** Apply them
	*/
	if (nh)
		detailSetHeading(headings, nh);
	XtFree((char *)headings);

	/*
	** Update main window detail info
	*/
	detailUpdateMainWindow(DETAIL_EDIT);

	AllowShellResize(per->Toplevel, ALLOW);
}


/* Remember or restore toggle button states */

/* ARGSUSED */
void procDetail (Widget w, XtPointer which, XtPointer call)
{
	int oldstate = state;

	int i, numchild, j;
	Widget parent;
	WidgetList children;

	XtVaGetValues ( w, XmNuserData, &parent, NULL);
	XtVaGetValues ( parent, 
		XmNnumChildren, &numchild,
		XmNchildren, &children, 
		NULL);

	switch ((int)which) {
	case 0: /* Ok */
		XtPopdown (GetTopShell(w));

		/* Save toggle settings */
		for (i = 0, xbae_nfields = 0; i < numchild; i++) {
			if (XmToggleButtonGadgetGetState (children[i])) {
				state |= (1<<i);
				xbae_field[i] = xbae_nfields++;
			} else {
				state &= ~(1<<i);
				xbae_field[i] = -1;
			}
		}

		if (state != oldstate)
			detailAddMainWindow ();
		break;
	case 1: /* Cancel */
		XtPopdown (GetTopShell(w));

		/* Restore toggle settings */
		for (i = 0; i < numchild; i++) {
			if (state & (1<<i))
				XmToggleButtonGadgetSetState (children[i], XmSET, False);
			else
				XmToggleButtonGadgetSetState (children[i], XmUNSET, False);
		}
		break;

	default:
		break;
	}
}

/* Create the detail dialog, but don't manage it */
Widget createDetailDialog(void) 
{
	Widget dialog;
	char *buttons[] = {
		"button_0",	/* ok */
		"button_1"	/* cancel */
	};
	char name[10];
	Widget form, pane, button;
	Dimension width, height, border;
	int num;

	dialog = XtVaCreatePopupShell("OptionDetail", xmDialogShellWidgetClass,
			GetTopShell(per->Toplevel),
			XmNmappedWhenManaged,	False,
			NULL);
	pane = XtVaCreateWidget("DetailPane", xmPanedWindowWidgetClass,
			dialog,
			XmNsashWidth,	1,
			XmNsashHeight,	1,
			NULL );
	checkbox = XmVaCreateSimpleCheckBox ( pane,"DetailCheckBox", NULL,
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* price */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* change */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* volume */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* daily low */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* daily high */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* exdiv date */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* 52 week low */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* 52 week high */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* p/e */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* div */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* yield */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* date */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* time */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* name */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* www server */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* ticker-type */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* symbol */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* trigger-low */
			XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,	/* trigger-high */
			NULL);
	XtManageChild(checkbox);

	for (num = 0; num < 19; num++) {
		sprintf (name, "button_%d", num);
		if ((state & (1 << num)) && (button = XtNameToWidget(checkbox, name)))
			XmToggleButtonGadgetSetState(button, True, False);
	}


	/* Buttons to add ok and cancel */
	form = XtVaCreateWidget("ButForm", xmFormWidgetClass, pane, NULL);
	for (num=0; num < XtNumber(buttons); num++) {
		button = XtVaCreateManagedWidget(buttons[num], xmPushButtonWidgetClass, form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNrightAttachment, XmATTACH_POSITION,
			XmNshowAsDefault, (num==0)?True:False,
			XmNdefaultButtonShadowThickness, 1,
			XmNuserData, checkbox,
			NULL);
		XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)procDetail,
				(XtPointer)num);
	}
	XtManageChild (form);
	XtManageChild (pane);

	/* Prevent pane from changing size */
	XtVaGetValues(dialog,
		XmNwidth, &width,
		XmNheight, &height,
		XmNborderWidth, &border,
		NULL);

	XtVaSetValues(dialog,
		XmNminWidth,  width +  border,
		XmNmaxWidth,  width +  border,
		XmNminHeight, height + border,
		XmNmaxHeight, height + border,
		NULL );
	return (dialog);
}

/*
 * Some functions to deal with the fields in XbaeMatrix
 */
int ColumnToField(int c)
{
	int	x = c - 2;
	int	i;
	int	field = -1;

	if (c < 2)
		return -1;
#if 0
	for (i=0; i<DETAIL_NUM_QUERY_VALUES; i++) {
		fprintf(stderr, "XbaeField[%d] = %d\n", i, xbae_field[i]);
	}
#endif
#if 0
	fprintf(stderr, "ColumnToField(%d) -> ", c);
#endif
	for (i=0; i<DETAIL_NUM_QUERY_VALUES; i++) {
		if (xbae_field[i] == x) {
			field = i + 2;
#if 0
			fprintf(stderr, "%d\n", field);
#endif
			return field;
		}
	}
	fprintf(stderr, "ColumnToField -> This should not happen\n");
	return -1;
}

int FieldToColumn(int f)
{
	if (f < 2)
		return -1;
	if (xbae_field[f-2] >= 0)
		return 2+xbae_field[f-2];
	return -1;
}

char *FieldName(int f)
{
	switch (f) {
	case DETAIL_TITLE:		return "DETAIL_TITLE";
	case DETAIL_URL:		return "DETAIL_URL";
	case DETAIL_PRICE:		return "DETAIL_PRICE";
	case DETAIL_CHANGE:		return "DETAIL_CHANGE";
	case DETAIL_VOLUME:		return "DETAIL_VOLUME";
	case DETAIL_DAILYL:		return "DETAIL_DAILYL";
	case DETAIL_DAILYH:		return "DETAIL_DAILYH";
	case DETAIL_EXDIV:		return "DETAIL_EXDIV";
	case DETAIL_L52:		return "DETAIL_L52";
	case DETAIL_H52:		return "DETAIL_H52";
	case DETAIL_PE:			return "DETAIL_PE";
	case DETAIL_DIV:		return "DETAIL_DIV";
	case DETAIL_YIELD:		return "DETAIL_YIELD";
	case DETAIL_DATE:		return "DETAIL_DATE";
	case DETAIL_TIME:		return "DETAIL_TIME";
	case DETAIL_NAME:		return "DETAIL_NAME";
	case DETAIL_WEBSERVER:		return "DETAIL_WEBSERVER";
	case DETAIL_TICKER_TYPE:	return "DETAIL_TICKER_TYPE";
	case DETAIL_SYMBOL:		return "DETAIL_SYMBOL";
	case DETAIL_TRIGGER_LOW:	return "DETAIL_TRIGGER_LOW";
	case DETAIL_TRIGGER_HIGH:	return "DETAIL_TRIGGER_HIGH";
	default:			return "?";
	}
}

/*
 * Deal with user actions in the matrix
 */
static Widget	webserver_option = NULL, *webserver_list = NULL;
static int	placed_webserver_option = 0;
static int	pwo_row, pwo_column;

static Widget	tickertype_option = NULL, *tickertype_list = NULL, tt_pd;
static int	placed_tickertype_option = 0, tt_nitems = 0;
static int	ptt_row, ptt_column;

static void WebServerOptionCB(Widget w, XtPointer client, XtPointer call)
{
	int	ix = (int)client;	/* This is the line number in the menu */
	char	*s = getServerTitle(ix);

#ifdef	DEBUG
	fprintf(stderr, "WebServerOptionCB(%d %d) %d %s\n",
			pwo_row, pwo_column, ix, s);
#endif
	tickSetServer(pwo_row, ix);
	MatrixData[pwo_row][pwo_column] = s;
	/* Do this last, it forces redraw which changing MatrixData doesn't trigger */
	XbaeMatrixSetCell(Container, pwo_row, pwo_column, s);
}

static void TickerTypeOptionCB(Widget w, XtPointer client, XtPointer call)
{
	int	ix = (int)client;	/* This is the line number in the menu */
	int	t = tickGetType(ptt_row);
	int	srv;
	char	*s;

	srv = tickGetServer(ptt_row);
	s = getServerType(srv, ix);
#ifdef	DEBUG
	fprintf(stderr, "TickerTypeOptionCB(%d,%d) %s\n", ptt_row, ix, s);
#endif
	tickSetType(ptt_row, ix);
	MatrixData[ptt_row][ptt_column] = s;
	/* Do this last, it forces redraw which changing MatrixData doesn't trigger */
	XbaeMatrixSetCell(Container, ptt_row, ptt_column, s);
}

static void PlaceWebServerOption(Widget w, int ix)
{
	int	s;

#ifdef	DEBUG
	fprintf(stderr, "PlaceWebServerOption(%d)\n", ix);
#endif
	s = tickGetServer(ix);
	XtVaSetValues(webserver_option, XmNmenuHistory, webserver_list[s], NULL);
}

static void PlaceTickerTypeOption(Widget w, int ix)
{
	int	s;
	int	i, n, t;

	/* Remove old menu items */
	for (i=0; i<tt_nitems; i++)
		XtDestroyWidget(tickertype_list[i]);
	XtFree((void *)tickertype_list);

	/* Add new items */
	t = tickGetType(ix);
	s = tickGetServer(ix);
	n = numServerTypes(s);
#ifdef	DEBUG
	fprintf(stderr, "PlaceTickerTypeOption(item %d -> server %d) count %d\n", ix, s, n);
#endif
	tickertype_list = (Widget *)calloc(n, sizeof(Widget));
	for (i=0; i<n; i++) {
		char	*str = getServerType(s, i);
#ifdef	DEBUG
		fprintf(stderr, "\t[%s]", str);
#endif
		w = XmCreatePushButton(tt_pd, str, NULL, 0);
		tickertype_list[i] = w;
		XtManageChild(w);
		XtAddCallback(w, XmNactivateCallback, TickerTypeOptionCB, (XtPointer)i);
		if (i == t)
			XtVaSetValues(tickertype_option, XmNmenuHistory, w, NULL);
	}
#ifdef	DEBUG
	fprintf(stderr, "\n");
#endif
	tt_nitems = n;
}

static void CreateWebserverOption(void)
{
	Widget	pd, w;
	Arg	al[4];
	int	ac, i, n;

	pd = XmCreatePulldownMenu(Container, "ww", NULL, 0);
	ac = 0;
	XtSetArg(al[ac], XmNsubMenuId, pd); ac++;
	webserver_option = XmCreateOptionMenu(Container, "webserver_option", al, ac);
	XtManageChild(webserver_option);

	n = numServer();
	webserver_list = (Widget *)calloc(n, sizeof(Widget));
	for (i=0; i<numServer(); i++) {
		char	*s = getServerTitle(i);
		w = XmCreatePushButton(pd, s, NULL, 0);
		webserver_list[i] = w;
		XtManageChild(w);
		XtAddCallback(w, XmNactivateCallback, WebServerOptionCB, (XtPointer)i);
	}
}

static void CreateTickerTypeOption(void)
{
	Widget	w;
	Arg	al[4];
	int	ac, i, n;

	tt_pd = XmCreatePulldownMenu(Container, "tt", NULL, 0);
	ac = 0;
	XtSetArg(al[ac], XmNsubMenuId, tt_pd); ac++;
	tickertype_option = XmCreateOptionMenu(Container, "tickertype_option", al, ac);
	XtManageChild(tickertype_option);
}

static void HideThem(void)
{
	fprintf(stderr, "HideThem (%d %d)\n", placed_tickertype_option, placed_webserver_option);
	if (placed_tickertype_option) {
		placed_tickertype_option = 0;
		fprintf(stderr, "Leave -> unmap ptto %d %d\n", ptt_row, ptt_column);
#if 0
		XtUnmanageChild(tickertype_option);
#endif
		XbaeMatrixSetCellWidget(Container, ptt_row, ptt_column, NULL);
#if 0
		XtManageChild(tickertype_option);
#endif
	}

	if (placed_webserver_option) {
		placed_webserver_option = 0;
		fprintf(stderr, "Leave -> unmap pwoo %d %d\n", pwo_row, pwo_column);
#if 0
		XtUnmanageChild(webserver_option);
#endif
		XbaeMatrixSetCellWidget(Container, pwo_row, pwo_column, NULL);
#if 0
		XtManageChild(webserver_option);
#endif
	}
}

extern void EnterCellCB(Widget w, XtPointer client, XtPointer call)
{
	XbaeMatrixEnterCellCallbackStruct *cbp = (XbaeMatrixEnterCellCallbackStruct *)call;
	int	field = ColumnToField(cbp->column);
	Dimension	cw, rh;

#ifdef DEBUG
	fprintf(stderr, "Enter(%d,%d) %s\n",
			cbp->row, cbp->column,
			FieldName(field));
#endif

	if (XbaeVersion < 45101) {
		fprintf(stderr, "XbaeVersion is %d, is too low (requirement >= 4.51.01)\n",
				XbaeVersion);
		return;
	}

	if (field < 0)
		return;	/* This should not happen */

	HideThem();

	switch (field) {
		case DETAIL_WEBSERVER:
			if (! webserver_option)
				CreateWebserverOption();
			XbaeMatrixSetCellWidget(Container, cbp->row, cbp->column, webserver_option);
			PlaceWebServerOption(webserver_option, cbp->row);
			placed_webserver_option = 1;
			pwo_row = cbp->row;
			pwo_column = cbp->column;
			break;
		case DETAIL_TICKER_TYPE:
			if (! tickertype_option)
				CreateTickerTypeOption();
			XbaeMatrixSetCellWidget(Container, cbp->row, cbp->column, tickertype_option);
			PlaceTickerTypeOption(tickertype_option, cbp->row);
			placed_tickertype_option = 1;
			ptt_row = cbp->row;
			ptt_column = cbp->column;
			break;
		case DETAIL_SYMBOL:
		case DETAIL_TRIGGER_LOW:
		case DETAIL_TRIGGER_HIGH:
		default:
			break;
	}
}

extern void LeaveCellCB(Widget w, XtPointer client, XtPointer call)
{
	XbaeMatrixLeaveCellCallbackStruct *cbp = (XbaeMatrixLeaveCellCallbackStruct *)call;
	int	field = ColumnToField(cbp->column);

#ifdef DEBUG
	fprintf(stderr, "Leave(%d,%d) [%s] %s\n",
			cbp->row, cbp->column,
			cbp->value, FieldName(field));
#endif

	HideThem();

	switch (field) {
	case DETAIL_WEBSERVER:
		break;
	case DETAIL_TICKER_TYPE:
		break;
	case DETAIL_SYMBOL:
		tickSetName(cbp->row, cbp->value);
		break;
	case DETAIL_TRIGGER_HIGH:
		if (MatrixData[cbp->row][field])
			free(MatrixData[cbp->row][field]);
		MatrixData[cbp->row][cbp->column] = strdup(cbp->value);
		tickSetHighTrigger(cbp->row, cbp->value);
		break;
	case DETAIL_TRIGGER_LOW:
		if (MatrixData[cbp->row][field])
			free(MatrixData[cbp->row][field]);
		MatrixData[cbp->row][cbp->column] = strdup(cbp->value);
		tickSetLowTrigger(cbp->row, cbp->value);
		break;
	}

	cbp->doit = True;
}

extern void MoveUp(int row)
{
	if (row == 0)
		return;
	tickSwap(row, row-1);
	detailUpdateMainWindow (DETAIL_EDIT);
}

extern void MoveDown(int row)
{
	/* Can't check for numTick here, it doesn't exist in this file. */
	tickSwap(row, row+1);
	detailUpdateMainWindow (DETAIL_EDIT);
}

extern void InsertItem(int row)
{
	fprintf(stderr, "InsertItem(%d)\n", row);
	tickAddItemAt("", row);
	detailUpdateMainWindow (DETAIL_EDIT);
}
