/*

    xpuyopuyo - ppaint-gtk.c       Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org          http://chaos2.org/
    
    Code responsible for drawing the screen
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdlib.h>
#include <stdio.h>
#include <config.h>
#include <ptime.h>
#include <ppaint-gtk.h>
#include <pgame.h>
#include <pnet.h>


static void p_window_paint_border(const pwindow_gtk *w, int dx, int dy) {
/* p_window_paint_border */

   GdkPixmap* bg;
   GdkBitmap* bg_m;
   int i;
   int j;
   int x1;
   int x2;
   int cx;
   int cy;

   /* Initial value calculations */
   cy = dy - P_CELL_HEIGHT;
   x1 = dx - P_CELL_WIDTH;
   x2 = dx + P_WINDOW_FIELD_WIDTH(w->c->fieldwidth);

   /* Top */
   for(i = w->c->fieldwidth + 2, cx = x1; i > 0; i--, cx += P_CELL_WIDTH) {
      p_window_put_image_index(w, P_IMAGE_BORDER_TOP, cx, cy);
   }

   /* Sides */
   cy += P_CELL_HEIGHT;
   p_window_put_image_index(w, P_IMAGE_BORDER_TOPLEFT, x1, cy);
   p_window_put_image_index(w, P_IMAGE_BORDER_TOPRIGHT,x2, cy);
   for(i = w->c->fieldheight - 2, cy += P_CELL_HEIGHT; i > 0; i--, cy += P_CELL_HEIGHT) {
      p_window_put_image_index(w, P_IMAGE_BORDER_LEFT, x1, cy);
      p_window_put_image_index(w, P_IMAGE_BORDER_RIGHT,x2, cy);
   }
   p_window_put_image_index(w, P_IMAGE_BORDER_BOTTOMLEFT, x1, cy);
   p_window_put_image_index(w, P_IMAGE_BORDER_BOTTOMRIGHT,x2, cy);
   cy += P_CELL_HEIGHT;

   /* Bottom */
   for(i = w->c->fieldwidth + 2, cx = x1, j = 0; i > 0; i--, cx += P_CELL_WIDTH) {
      p_window_put_image_index(w, P_IMAGE_BORDER_BOTTOM(j), cx, cy);
      j++;
      if(j >= P_NUM_BOTTOM_TILES) j = 0;
   }

   /* Inactive status tiles */
   /*  cy    is the Next, sum row */
   /*  cy+1  is a blank row       */
   /*  cy+2  is first digits row  */
   /*  cy+3  is second digits row */
   /*  cy+4  is another blank row */
   cy += P_CELL_HEIGHT;
   bg   = P_IMAGE(     w->img, P_IMAGE_CLEAR_BLUE);
   bg_m = P_IMAGE_MASK(w->img, P_IMAGE_CLEAR_BLUE);
   p_window_put_image(w, bg, bg_m,  x1,                     cy);
   p_window_put_image(w, bg, bg_m,  x1,                     cy + 2 * P_CELL_HEIGHT);
   p_window_put_image(w, bg, bg_m,  x1,                     cy + 3 * P_CELL_HEIGHT);
   /*p_window_put_image(w, bg, bg_m,  x1 + 3 * P_CELL_WIDTH,  cy);*/
   for(i = w->c->fieldwidth - 5, cx = dx + P_CELL_WIDTH * 6; i > 0; i--, cx += P_CELL_WIDTH) {
      p_window_put_image(w, bg, bg_m,  cx, cy);
      p_window_put_image(w, bg, bg_m,  cx, cy + 2 * P_CELL_HEIGHT);
      p_window_put_image(w, bg, bg_m,  cx, cy + 3 * P_CELL_HEIGHT);
   }
   for(i = w->c->fieldwidth + 2, cx = x1; i > 0; i--, cx += P_CELL_WIDTH) {
      p_window_put_image(w, bg, bg_m,  cx, cy + P_CELL_HEIGHT);
      p_window_put_image(w, bg, bg_m,  cx, cy + 4 * P_CELL_HEIGHT);
   }

   return;

}


static void p_window_paint_disabled(const pwindow_gtk *w, const pplayer *p, int dx, int dy) {
/* p_window_paint_disabled */

   GdkPixmap *bg;
   GdkBitmap* bg_m;
   int i;
   int j;
   int cx;
   int cy;
   
   /* Preload images to paint disabled background */
   bg   = P_IMAGE(     w->img, P_IMAGE_CLEAR_RED);
   bg_m = P_IMAGE_MASK(w->img, P_IMAGE_CLEAR_RED);
   
   /* Iterate and paint */
   for(j = w->c->fieldheight, cy = dy; j > 0; j--, cy += P_CELL_HEIGHT) {
      for(i = w->c->fieldwidth, cx=dx; i > 0; i--, cx += P_CELL_WIDTH) {
         p_window_put_image(w, bg, bg_m, cx, cy);
      }
   }
   
   return;

}


static void p_window_paint_active_rocks(const pwindow_gtk *w, const pplayer *p, int dx, int dy) {
/* p_window_paint_active_rocks */

   int i;
   int j;
   int a;
   int b;
   int cx;

   /* Determine number of each type of rock */
   j = p->rocks;
   b = j / P_DEMONROCK_NUM;
   a = (j - b * P_DEMONROCK_NUM) / P_BIGROCK_NUM;
   j = j - a * P_BIGROCK_NUM - b * P_DEMONROCK_NUM;
   
   /* Draw rocks (in reverse) */
   cx = dx + P_WINDOW_FIELD_WIDTH(w->c->fieldwidth);
   i = w->c->fieldwidth;
   while(i > 0) {
      cx -= P_CELL_WIDTH;
      if(b)             b--, p_window_put_image_index(w, P_IMAGE_ROCK_DEMON, cx, dy);
      else if(a)        a--, p_window_put_image_index(w, P_IMAGE_ROCK_BIG,   cx, dy);
      else if(j)        j--, p_window_put_image_index(w, P_IMAGE_ROCK_NORMAL,cx, dy);
      else                   p_window_put_image_index(w, P_IMAGE_CLEAR_BLUE, cx, dy);
      i--;
   }
   
   return;
   
}


static void p_window_paint_active(const pwindow_gtk *w, pplayer *p, int dx, int dy) {
/* p_window_paint_active */

   GdkPixmap *unjoined;
   GdkBitmap *unjoined_m;
   GdkPixmap *joined;
   GdkBitmap *joined_m;
   GdkPixmap *im;
   GdkBitmap *im_m;
   GdkPixmap *bg;
   GdkBitmap *bg_m;
   pfield *piece; /* Playing piece */
   pfield *f;     /* Playing field (shortcut) */
   int *src;      /* Pointer into play field */
   int *rsrc;     /* redraw pointer */
   int i;         /* Current tile X */
   int j;         /* Current tile Y */
   int cx;        /* Current pixel X */
   int cy;        /* Current pixel Y */
   int px1;       /* Current piece tile X */
   int py1;       /* Current piece tile Y */
   int px2;       /* Current piece bottomright tile X */
   int py2;       /* Current piece bottomright tile Y */
   int color;     /* Color of current blob */

   /* Setup local variables */   
   f     = p->field;
   piece = P_FIELD_PIECE(f);
   px1   = P_PIECE_X(piece);
   py1   = P_PIECE_Y(piece);
   px2   = px1 + piece->width - 1;
   py2   = py1 + piece->height- 1;
   bg    = P_IMAGE(     w->img, P_IMAGE_CLEAR_BLUE);
   bg_m  = P_IMAGE_MASK(w->img, P_IMAGE_CLEAR_BLUE);
   
   /* Redraw active rocks */
   p_window_paint_active_rocks(w, p, dx, dy);
   
   /* Loop through rows */
   for(j = 1, cy = dy + P_CELL_HEIGHT; j < f->height; j++, cy += P_CELL_HEIGHT) {

      /* Get pointer into playing field */
      src = P_FIELD_XY_P(f, 0, j);
      rsrc= f->redraw + j * f->width;

      /* Loop through columns */
      for(i = 0, cx = dx; i < f->width; i++, cx += P_CELL_WIDTH, src++, rsrc++) {
         if(*rsrc) {
            *rsrc = 0;  /* Have drawn this, don't need a redraw */
            color = *src;
            if(P_IS_CLEAR(color) && (i >= px1 && i <= px2) && (j >= py1 && j <= py2)) color = p_field_get(piece, i - px1, j - py1);
            if(P_IS_COLOR(color) && P_COLOR_VALUE(color) < P_COLORS_MAX) {
               p_window_put_image(w, bg, bg_m, cx, cy);
               /* Colored blob, draw appropriate color (with joins) on the screen */
               unjoined   = P_IMAGE(     w->img, P_IMAGE_UNJOINED(P_COLOR_VALUE(color)));
               unjoined_m = P_IMAGE_MASK(w->img, P_IMAGE_UNJOINED(P_COLOR_VALUE(color)));
               joined     = P_IMAGE(     w->img, P_IMAGE_JOINED(P_COLOR_VALUE(color)));
               joined_m   = P_IMAGE_MASK(w->img, P_IMAGE_JOINED(P_COLOR_VALUE(color)));
               im   = (color & P_JOIN_ANY)   ? joined   : unjoined;
               im_m = (color & P_JOIN_ANY)   ? joined_m : unjoined_m;
               p_window_put_subimage(w, im, im_m, P_CELL_BORDER, P_CELL_BORDER, cx + P_CELL_BORDER, cy + P_CELL_BORDER, P_CELL_WIDTH - 2 * P_CELL_BORDER, P_CELL_HEIGHT - 2 * P_CELL_BORDER);
               /* Make upward joins */
               im   = (color & P_JOIN_NORTH) ? joined   : unjoined;
               im_m = (color & P_JOIN_NORTH) ? joined_m : unjoined_m;
               p_window_put_subimage(w, im, im_m, 0, 0, cx, cy, P_CELL_WIDTH, P_CELL_BORDER);
               /* Make downward joins */
               im   = (color & P_JOIN_SOUTH) ? joined   : unjoined;
               im_m = (color & P_JOIN_SOUTH) ? joined_m : unjoined_m;
               p_window_put_subimage(w, im, im_m, 0, P_CELL_HEIGHT- P_CELL_BORDER, cx, cy + P_CELL_HEIGHT- P_CELL_BORDER, P_CELL_WIDTH, P_CELL_BORDER);
               /* Make joins to the left */
               im   = (color & P_JOIN_WEST)  ? joined   : unjoined;
               im_m = (color & P_JOIN_WEST)  ? joined_m : unjoined_m;
               p_window_put_subimage(w, im, im_m, 0, 0, cx, cy, P_CELL_BORDER, P_CELL_HEIGHT);
               /* Make joins to the right */
               im   = (color & P_JOIN_EAST)  ? joined   : unjoined;
               im_m = (color & P_JOIN_EAST)  ? joined_m : unjoined_m;
               p_window_put_subimage(w, im, im_m, P_CELL_WIDTH - P_CELL_BORDER, 0, cx + P_CELL_WIDTH - P_CELL_BORDER, cy, P_CELL_BORDER, P_CELL_HEIGHT);
            } else if(P_IS_STAR(color)) {
               /* Explosion blob */
               p_window_put_image(w, bg, bg_m, cx, cy);
               p_window_put_image_index(w, P_IMAGE_EXPLOSION,  cx, cy);
            } else if(P_IS_ROCK(color)) {
               /* Rock to be drawn */
               p_window_put_image(w, bg, bg_m, cx, cy);
               p_window_put_image_index(w, P_IMAGE_ROCK_NORMAL,cx, cy);
            } else if(P_IS_INDESTRUCTIBLE(color)) {
               /* Rock to be drawn */
               p_window_put_image(w, bg, bg_m, cx, cy);
               p_window_put_image_index(w, P_IMAGE_ROCK_IND, cx, cy);
            } else {
               p_window_put_image(w, bg, bg_m, cx, cy);
            }
         } /* Need to redraw this tile? */
      } /* Loop thru X */
   } /* Loop thru Y */
   
   p_field_redraw_none(p->field);

   return;

}


static void p_window_paint_digits1(const pwindow_gtk *w, int dx, int dy, int num) {
/* p_window_paint_digits1 */

   if(num < 0) num = 0;
   if(num > 9) num = 9;
   p_window_put_image_index(w, P_IMAGE_CLEAR_BLUE, dx, dy);
   p_window_put_image_index(w, P_IMAGE_NUMBER(num), dx + P_CELL_WIDTH / 2, dy);
   return;

}


static void p_window_paint_digits2(const pwindow_gtk *w, int dx, int dy, int num) {
/* p_window_paint_digits2 */

   if(num < 0)  num = 0;
   if(num > 99) num = 99;
   p_window_put_image_index(w, P_IMAGE_CLEAR_BLUE,    dx, dy);
   p_window_put_image_index(w, P_IMAGE_NUMBER(num / 10), dx, dy);
   p_window_put_image_index(w, P_IMAGE_NUMBER(num % 10), dx + P_CELL_WIDTH / 2, dy);
   return;

}


static void p_window_paint_digits3(const pwindow_gtk *w, int dx, int dy, int num) {
/* p_window_paint_digits3 */

   if(num < 0)   num = 0;
   if(num > 999) num = 999;
   p_window_paint_digits1(w, dx, dy, num / 100);
   p_window_paint_digits2(w, dx + P_CELL_WIDTH, dy, num % 100);
   return;

}


static void p_window_paint_digits4(const pwindow_gtk *w, int dx, int dy, int num) {
/* p_window_paint_digits4 */

   if(num < 0)   num = 0;
   if(num > 9999)num = 9999;
   p_window_paint_digits2(w, dx, dy, num / 100);
   p_window_paint_digits2(w, dx + P_CELL_WIDTH, dy, num % 100);
   return;
   
}


static void p_window_paint_digits6(const pwindow_gtk *w, int dx, int dy, int num) {
/* p_window_paint_digits6 */

   if(num < 0)      num = 0;
   if(num > 999999) num = 999999;
   p_window_paint_digits2(w, dx, dy, num / 10000);
   p_window_paint_digits4(w, dx + P_CELL_WIDTH, dy, num % 10000);
   return;
   
}


static void p_window_paint_digits7(const pwindow_gtk *w, int dx, int dy, int num) {
/* p_window_paint_digits7 */

   if(num < 0)       num = 0;
   if(num > 9999999) num = 9999999;
   p_window_paint_digits1(w, dx, dy, num / 1000000);
   p_window_paint_digits6(w, dx + P_CELL_WIDTH, dy, num % 1000000);
   return;
   
}


static void p_window_paint_status(const pwindow_gtk *w, const pplayer *p, int dx, int dy, int drawall) {
/* p_window_paint_status */

   int cx;
   int i;

   dy += P_WINDOW_FIELD_HEIGHT(w->c->fieldheight) + P_CELL_HEIGHT;

   if(drawall & P_REDRAW_NEXT) {
      if(P_PLAYER_AI(w->c, p) && w->c->aiscore) {
         p_window_paint_digits4(w, dx, dy, p_ai_get_score(p->ai));
      } else for(i = 0, cx = dx; i < 2; i++, cx += P_CELL_WIDTH) {
         p_window_put_image_index(w, P_IMAGE_CLEAR_BLUE, cx, dy);
         p_window_put_image_index(w, P_IMAGE_UNJOINED(P_COLOR_VALUE(p->next.block[i])), cx, dy);
      }
   }
   
   if(drawall & P_REDRAW_TIMER) {
      p_window_paint_digits7(w, dx + P_CELL_WIDTH * 2, dy, p->score);
      p_window_paint_digits3(w, dx + P_CELL_WIDTH * 0, dy + 2 * P_CELL_HEIGHT, p->num_clumps[0]);
      p_window_paint_digits3(w, dx + P_CELL_WIDTH * 2, dy + 2 * P_CELL_HEIGHT, p->num_clumps[1]);
      p_window_paint_digits3(w, dx + P_CELL_WIDTH * 4, dy + 2 * P_CELL_HEIGHT, p->num_clumps[2]);
      p_window_paint_digits3(w, dx + P_CELL_WIDTH * 0, dy + 3 * P_CELL_HEIGHT, p->num_clumps[3]);
      p_window_paint_digits3(w, dx + P_CELL_WIDTH * 2, dy + 3 * P_CELL_HEIGHT, p->num_clumps[4]);
      p_window_paint_digits3(w, dx + P_CELL_WIDTH * 4, dy + 3 * P_CELL_HEIGHT, p->num_clumps[5]);
   }
   
   return;
   
}


static void p_window_paint_field(const pwindow_gtk *w, pplayer *p, int dx, int dy, int drawall) {
/* p_window_paint_field */

   if(drawall & P_REDRAW_SCREEN) p_window_paint_border(w, dx, dy);

   if(!w->c->nodisplay) {
      if(p->state == P_STATE_LOSER || p->state == P_STATE_DISABLED) p_window_paint_disabled(w, p, dx, dy);
      else p_window_paint_active(w, p, dx, dy);
   }

}


static inline void p_window_redraw_screen(const pwindow_gtk *w) {
/* p_window_redraw_screen */

   p_window_put_image_index(w, P_IMAGE_GAME_TITLE, 0, 0);

}


static inline void p_window_paint_game_over(const pwindow_gtk *w) {
/* p_window_paint_game_over */

   GdkPixmap *gameover;
   
   gameover = P_IMAGE(w->img, P_IMAGE_GAME_OVER);
   p_window_put_image_index(w, P_IMAGE_GAME_OVER, (P_WINDOW_WIDTH(w->c->fieldwidth) - pixmap_width(gameover)) / 2, (P_WINDOW_HEIGHT(w->c->fieldheight) - P_CELL_HEIGHT * 4 - pixmap_height(gameover)) / 2);
   return;

}


static inline void p_window_paint_paused(const pwindow_gtk *w) {

   GdkPixmap *paused;
   
   paused = P_IMAGE(w->img, P_IMAGE_PAUSED);
   p_window_put_image_index(w, P_IMAGE_PAUSED, (P_WINDOW_WIDTH(w->c->fieldwidth) - pixmap_width(paused)) / 2, (P_WINDOW_HEIGHT(w->c->fieldheight) - P_CELL_HEIGHT * 4 - pixmap_height(paused)) / 2);
   return;

}


static void p_window_paint_timer(const pwindow_gtk *w, unsigned long time) {   
/* p_window_paint_timer */

   GdkPixmap *bg;
   GdkBitmap *bg_m;
   int i;

   bg   = P_IMAGE(     w->img, P_IMAGE_CLEAR_BLUE);
   bg_m = P_IMAGE_MASK(w->img, P_IMAGE_CLEAR_BLUE);
   for(i = 0; i < P_WINDOW_WIDTH(w->c->fieldwidth) - 5 * P_CELL_WIDTH; i += P_CELL_WIDTH) {
      p_window_put_image(w, bg, bg_m, i, P_WINDOW_HEIGHT(w->c->fieldheight) - P_CELL_HEIGHT);
   }
   p_window_put_subimage_index(w, P_IMAGE_CLEAR_BLUE, P_CELL_WIDTH / 2, 0, P_WINDOW_WIDTH(w->c->fieldwidth) - 3 * P_CELL_WIDTH / 2, P_WINDOW_HEIGHT(w->c->fieldheight) - P_CELL_HEIGHT, P_CELL_WIDTH / 2, P_CELL_HEIGHT);
   p_window_put_subimage_index(w, P_IMAGE_CLEAR_BLUE, 0, 0, P_WINDOW_WIDTH(w->c->fieldwidth) - 3 * P_CELL_WIDTH, P_WINDOW_HEIGHT(w->c->fieldheight) - P_CELL_HEIGHT, P_CELL_WIDTH / 2, P_CELL_HEIGHT);
   
   p_window_paint_digits2(w, P_WINDOW_WIDTH(w->c->fieldwidth) - P_CELL_WIDTH, P_WINDOW_HEIGHT(w->c->fieldheight) - P_CELL_HEIGHT, time % TV_SEC_IN_MIN);
   p_window_paint_digits2(w, P_WINDOW_WIDTH(w->c->fieldwidth) - 5 * P_CELL_WIDTH / 2, P_WINDOW_HEIGHT(w->c->fieldheight) - P_CELL_HEIGHT, (time / TV_SEC_IN_MIN) % TV_MIN_IN_HOUR);
   p_window_paint_digits3(w, P_WINDOW_WIDTH(w->c->fieldwidth) - 5 * P_CELL_WIDTH, P_WINDOW_HEIGHT(w->c->fieldheight) - P_CELL_HEIGHT, time / TV_SEC_IN_HOUR);
   
   return;

}


void p_window_paint(pconfig *c, const pwindow *w_, int redraw) {
/* p_window_paint */

   pwindow_gtk *w = (pwindow_gtk *)w_;
   struct timeval tv;
   
   /* Check if need to redraw everything */
   if(c->needredraw) {
      redraw = P_REDRAW_ALL;
      c->needredraw = 0;
   }

   /* If redraw screen set, redraw _all_ of player fields */   
   if(redraw & P_REDRAW_SCREEN) {
      p_field_redraw_all(P_PLAYER_0(c)->field);
      p_field_redraw_all(P_PLAYER_1(c)->field);
   }

   /* If redraw screen set, redraw window decorations (title etc) */
   if(redraw & P_REDRAW_SCREEN)     p_window_redraw_screen(w);

   /* Redraw players as needed */
   if(redraw & P_REDRAW_PLAYER_0)   p_window_paint_field(w, P_PLAYER_0(c), P_WINDOW_FIELD_X(c->fieldwidth, 0), P_WINDOW_FIELD_Y(c->fieldheight, 0), redraw);
   if(redraw & P_REDRAW_PLAYER_1)   p_window_paint_field(w, P_PLAYER_1(c), P_WINDOW_FIELD_X(c->fieldwidth, 1), P_WINDOW_FIELD_Y(c->fieldheight, 1), redraw);
   
   /* Redraw player statuses as needed */
   p_window_paint_status(w, P_PLAYER_0(c), P_WINDOW_FIELD_X(c->fieldwidth, 0), P_WINDOW_FIELD_Y(c->fieldheight, 0), redraw);
   p_window_paint_status(w, P_PLAYER_1(c), P_WINDOW_FIELD_X(c->fieldwidth, 1), P_WINDOW_FIELD_Y(c->fieldheight, 1), redraw);

   /* Redraw game over message? */
   if(P_GAME_OVER(c) && !c->restart) p_window_paint_game_over(w);
   
   /* Redraw game over message? */
   if(c->paused) p_window_paint_paused(w);
   
   /* Redraw game timer? */
   if(redraw & P_REDRAW_TIMER) {
      TV_COPY(tv, c->t2);
      TV_SUB(tv, c->t1);
      p_window_paint_timer(w, tv.tv_sec);
   }

   return;

}


