/*

    xpuyopuyo - ppiece.h      Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Header file for playing pieces.
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __ppiece_h_included
#define __ppiece_h_included


#include <pfield.h>


/* Please note, that while a piece is floating, it is stored in a 2x2
   "miniature field", with two colored blobs and two clear tiles.  This
   2x2 field can be rotated and whatnot by the functions below.  The 
   nextpiece is only stored as an array of integers;  there is no need
   to store the next piece in a field.  */


/* Interface functions */
void p_piece_renew(pfield *f, nextpiece *n);
void p_piece_new(pfield *f, nextpiece *n);
int p_piece_collided(pfield *field);
void p_piece_rotate(pfield *piece);
void p_piece_rotate_old(pfield *piece);
void p_piece_unrotate(pfield *piece);
int p_piece_rotate_collide(pfield *field);
int p_piece_try_rotate(pfield *field);
void p_piece_fall(pfield *piece);
void p_piece_unfall(pfield *piece);
int p_piece_fall_collide(pfield *field);
int p_piece_try_right(pfield *field);
int p_piece_try_left(pfield *field);


#endif
