/*
  
   xpuyopuyo - phelp.c        Copyright(c) 2001 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Simple help system


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdio.h>
#include <stdlib.h>
#include <xpuyopuyo.h>
#include <psnprintf.h>
#include <phelp.h>


static void _unmunge_line(char *buf) {

   char *d = buf;
   char *s = buf;
   while(*s != '\0') {
      if(!strncmp(s, "\\-", 2)) {
         *d = '-';
         ++d;
         ++s;
      } else if(!strncmp(s, "\\f", 2)) {
         s += 2;
      } else {
         *d = *s;
         ++d;
      }
      ++s;
   }
   *d = '\0';

}


static void _trim_line(char *buf) {

   bool countedspace = true;
   char *d = buf;
   char *s = buf;
   while(*s != '\0') {
      if(*s == ' ' || *s == '\t' || *s == '\n') {
         if(!countedspace) {
            countedspace = true;
            *d = ' ';
            ++d;
         }
      } else {
         countedspace = false;
         *d = *s;
         ++d;
      }
      ++s;
   }
   if(countedspace && d > buf) --d;
   *d = '\0';
   
}


void p_help_text(char *res, int size, const char *idphrase) {
/* p_help_text */

   char buf[0x1000];
   bool match;
   bool done;
   FILE *f;

   /* Sanity checks */
   if(res == NULL || size <= 0 || idphrase == NULL) return;
   
   /* Attempt to open help file */
   if((f = fopen(P_GROFF_MANUAL_FILE, "r")) == NULL) {
      p_snprintf(res, size, "Cannot open help file %s.", P_GROFF_MANUAL_FILE);
      return;
   }
   
   /* Scan help file for the requested text */
   match = false;
   while(!match && fgets(buf, sizeof(buf), f) != NULL) {
      if(!strncmp(buf, ".B", 2)) {
         match = (strstr(buf, idphrase) != NULL);
      }
   }
   
   /* Make sure we found something */
   if(!match) {
      p_snprintf(res, size, "Cannot find help text for %s.", idphrase);
      fclose(f);
      return;
   }
   
   /* Start writing data to the result buffer until we reach a blank line */
   done = false;
   p_strncpy(res, idphrase, size);
   p_strncat(res, ": ", size);
   while(!done && fgets(buf, sizeof(buf), f) != NULL) {
      if(*buf == '.' && strncmp(buf, ".\\\"", 3)) done = true;
      else {
         /* Copy this line (unmunged) into the help buffer */
         p_strncat(res, buf, size);
      }
   }
   
   /* We are done! */
   _unmunge_line(res);
   _trim_line(res);
   fclose(f);
   
}

