/*

    xpuyopuyo - pconfigmo.h   Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Configuration macros
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pconfigm_h_defined
#define __pconfigm_h_defined


/* Constants must be imported */
#include <xpuyopuyo.h>


/* Regarding tournaments */
#if USE_AIBREED
#define P_ALLOW_TOURNAMENT       1                       /* Allow tournaments */
#define P_TOURNAMENT(c)          ((c)->tournament > 0)   /* If true, a tournament is playing */
#define P_TOURNAMENT_WINNER(c)   ((c)->tournament == 1)  /* Tournament has a winner */
#define P_TOURNAMENT_HYPER(c)    ((c)->hypertournament)  /* Tournament is "hyper" */
#else 
#define P_ALLOW_TOURNAMENT       0                       /* Do not allow tournaments */
#define P_TOURNAMENT(c)          0                       /* Always false */
#define P_TOURNAMENT_WINNER(c)   0                       /* Always false */
#define P_TOURNAMENT_HYPER(c)    0                       /* Always false */
#endif


/* Configuration players */
/* Note, in network play the network opponent is marked as AI.  The
   player macros will recognize this special case and mark that player
   instead as a remote player. */
#define P_CONFIG_SINGLE_PLAYER   0x010     /* Numplayers = 1, AI = 0 */
#define P_CONFIG_HUMAN_HUMAN     0x020     /* Numplayers = 2, AI = 0 */
#define P_CONFIG_HUMAN_AI        0x021     /* Numplayers = 2, AI = 1 */
#define P_CONFIG_HUMAN_NET       0x120     /* Network game btwn humans */
#define P_CONFIG_AI_AI           0x022     /* Numplayers = 2, AI = 2 */
#define P_CONFIG_AI_NET          0x121     /* Network game with local AI */

#define P_CONFIG_N_PLAYERS(n)    (((n) >> 4) & 0x0f)     /* Total number of players for n */
#define P_CONFIG_N_AI(n)         ((n) & 0x0f)            /* Number of AI players for n */
#define P_CONFIG_N_NETWORK(n)    (((n) >> 8) & 0x0f)     /* Number of network players for n */

#define P_CONFIG_IS_PLAYERS(c, m)((c)->numplayers == P_CONFIG_N_PLAYERS(m) && \
                                  (c)->ai == P_CONFIG_N_AI(m) && \
                                  (c)->networked == P_CONFIG_N_NETWORK(m))

#define P_CONFIG_IS_SINGLE_PLAYER(c) P_CONFIG_IS_PLAYERS((c), P_CONFIG_SINGLE_PLAYER)
#define P_CONFIG_IS_HUMAN_HUMAN(c)   P_CONFIG_IS_PLAYERS((c), P_CONFIG_HUMAN_HUMAN)
#define P_CONFIG_IS_HUMAN_AI(c)  P_CONFIG_IS_PLAYERS((c), P_CONFIG_HUMAN_AI)
#define P_CONFIG_IS_HUMAN_NET(c) P_CONFIG_IS_PLAYERS((c), P_CONFIG_HUMAN_NET)
#define P_CONFIG_IS_AI_AI(c)     P_CONFIG_IS_PLAYERS((c), P_CONFIG_AI_AI)
#define P_CONFIG_IS_AI_NET(c)    P_CONFIG_IS_PLAYERS((c), P_CONFIG_AI_NET)


/* Setup config for common settings */
#define p_config_players(c, m)   ((c)->numplayers = P_CONFIG_N_PLAYERS(m), \
                                  (c)->ai = P_CONFIG_N_AI(m), \
                                  (c)->networked = P_CONFIG_N_NETWORK(m))
#define p_config_size(c, w, h, m)((c)->fieldwidth = (w), (c)->fieldheight = (h), (c)->fieldmatch = (m))
#define p_config_drop_slow(c)    ((c)->dropspeed = P_DROP_TIME * 5 / 4)
#define p_config_drop_medium(c)  ((c)->dropspeed = P_DROP_TIME * 4 / 4)
#define p_config_drop_fast(c)    ((c)->dropspeed = P_DROP_TIME * 3 / 4)
#define p_config_easy(c)         ((c)->numcolors = 4, \
                                  p_config_drop_slow(c), \
                                  (c)->accel = P_ACCEL_OFF, \
                                  (c)->aicandrop = 0,    \
                                  (c)->nullifyrocks = 1, \
                                  (c)->indestructibles = 0)
#define p_config_medium(c)       ((c)->numcolors = 5, \
                                  p_config_drop_medium(c), \
                                  (c)->accel = P_ACCEL_DEFAULT, \
                                  (c)->aicandrop = 1,    \
                                  (c)->nullifyrocks = 1, \
                                  (c)->indestructibles = 1)
#define p_config_hard(c)         ((c)->numcolors = 6, \
                                  p_config_drop_fast(c), \
                                  (c)->accel = P_ACCEL_DEFAULT, \
                                  (c)->aicandrop = 1,    \
                                  (c)->nullifyrocks = 0, \
                                  (c)->indestructibles = 1)
#define p_config_network(c)      ((c)->tutorial = 0,     \
                                  (c)->restart = 0,      \
                                  p_config_players(c,    \
                                    (c)->networkai ? P_CONFIG_AI_NET : P_CONFIG_HUMAN_NET))
#define p_config_undo_network(c) p_config_players(c, P_CONFIG_HUMAN_AI)


/* Check for configuration incompatibilities here. */
#define p_config_incompat(c)     ((P_TOURNAMENT(c) && ((c)->numplayers < 2 || (c)->ai != (c)->numplayers)) || \
                                  ((c)->networked + (c)->ai > 2) || \
                                  (P_NETWORK(c) && P_TOURNAMENT(c)))


#endif
