/**
 * @file	c86ctlif.h
 * @brief	G.I.M.I.C ANZX NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <map>
#include "../externalchip.h"

namespace c86ctl
{
	class IRealChipBase;
	class IGimic;
	class IRealChip;
}

/**
 * @brief G.I.M.I.C ANZX NX
 */
class C86CtlIf
{
public:
	C86CtlIf();
	~C86CtlIf();
	bool Initialize();
	void Deinitialize();
	void Reset();
	IExternalChip* GetInterface(IExternalChip::ChipType nChipType, UINT nClock);

private:
	c86ctl::IRealChipBase* m_pChipBase;	/*!< `bv x[X CX^X */

	/**
	 * @brief `bv NX
	 */
	class Chip : public IExternalChip
	{
	public:
		Chip(C86CtlIf* pC86CtlIf, c86ctl::IRealChip* pRealChip, c86ctl::IGimic* pGimic, ChipType nChipType, UINT nClock);
		virtual ~Chip();
		virtual ChipType GetChipType();
		virtual void Reset();
		virtual void WriteRegister(UINT nAddr, UINT8 cData);
		virtual INTPTR Message(UINT nMessage, INTPTR nParameter = 0);

	private:
		C86CtlIf* m_pC86CtlIf;				/*!< C86Ctl CX^X */
		c86ctl::IRealChip* m_pRealChip;		/*!< `bv CX^X */
		c86ctl::IGimic* m_pGimic;			/*!< G.I.M.I.C CX^X */
		ChipType m_nChipType;				/*!< `bv ^Cv */
		UINT m_nClock;						/*!< `bv NbN */
	};

	std::map<int, Chip*> m_chips;			/*!< `bv */
	void Detach(Chip* pChip);
	friend class Chip;
};
