/**
 * @file	cmmidioutvermouth.cpp
 * @brief	MIDI OUT Vermouth NX̓̒`s܂
 */

#include "compiler.h"
#include "cmmidioutvermouth.h"

#if defined(VERMOUTH_LIB)

//! nh
extern MIDIMOD vermouth_module;

/**
 * CX^X쐬
 * @return CX^X
 */
CComMidiOutVermouth* CComMidiOutVermouth::CreateInstance()
{
	MIDIHDL vermouth = midiout_create(vermouth_module, 512);
	if (vermouth == NULL)
	{
		return NULL;
	}
	return new CComMidiOutVermouth(vermouth);
}

/**
 * RXgN^
 * @param[in] vermouth nh
 */
CComMidiOutVermouth::CComMidiOutVermouth(MIDIHDL vermouth)
	: m_vermouth(vermouth)
{
	::sound_streamregist(m_vermouth, reinterpret_cast<SOUNDCB>(GetPcm));
}

/**
 * fXgN^
 */
CComMidiOutVermouth::~CComMidiOutVermouth()
{
	::midiout_destroy(m_vermouth);
}

/**
 * V[g bZ[W
 * @param[in] nMessage bZ[W
 */
void CComMidiOutVermouth::Short(UINT32 nMessage)
{
	sound_sync();
	::midiout_shortmsg(m_vermouth, nMessage);
}

/**
 * O bZ[W
 * @param[in] lpMessage bZ[W |C^
 * @param[in] cbMessage bZ[W TCY
 */
void CComMidiOutVermouth::Long(const UINT8* lpMessage, UINT cbMessage)
{
	sound_sync();
	::midiout_longmsg(m_vermouth, lpMessage, cbMessage);
}

/**
 * vZX
 * @param[in] vermouth nh
 * @param[out] lpBuffer obt@
 * @param[in] nBufferCount Tv
 */
void SOUNDCALL CComMidiOutVermouth::GetPcm(MIDIHDL vermouth, SINT32* lpBuffer, UINT nBufferCount)
{
	while (nBufferCount)
	{
		UINT nSize = nBufferCount;
		const SINT32* ptr = ::midiout_get(vermouth, &nSize);
		if (ptr == NULL)
		{
			break;
		}
		nBufferCount -= nSize;
		do
		{
			lpBuffer[0] += ptr[0];
			lpBuffer[1] += ptr[1];
			ptr += 2;
			lpBuffer += 2;
		} while (--nSize);
	}
}

#endif	// defined(VERMOUTH_LIB)
